// Generated by delombok at Mon May 20 07:04:18 UTC 2024
package io.weaviate.client.v1.graphql.query.builder;

import io.weaviate.client.v1.filters.WhereFilter;
import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.argument.AskArgument;
import io.weaviate.client.v1.graphql.query.argument.NearAudioArgument;
import io.weaviate.client.v1.graphql.query.argument.NearDepthArgument;
import io.weaviate.client.v1.graphql.query.argument.NearImageArgument;
import io.weaviate.client.v1.graphql.query.argument.NearImuArgument;
import io.weaviate.client.v1.graphql.query.argument.NearObjectArgument;
import io.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import io.weaviate.client.v1.graphql.query.argument.NearThermalArgument;
import io.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import io.weaviate.client.v1.graphql.query.argument.NearVideoArgument;
import io.weaviate.client.v1.graphql.query.argument.WhereArgument;
import io.weaviate.client.v1.graphql.query.fields.Fields;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import org.apache.commons.lang3.StringUtils;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class AggregateBuilder implements Query {
  private final String className;
  private final Fields fields;
  private final String groupByClausePropertyName;
  private final WhereArgument withWhereFilter;
  private final AskArgument withAskArgument;
  private final NearTextArgument withNearTextFilter;
  private final NearObjectArgument withNearObjectFilter;
  private final NearVectorArgument withNearVectorFilter;
  private final NearImageArgument withNearImageFilter;
  private final NearAudioArgument withNearAudioFilter;
  private final NearVideoArgument withNearVideoFilter;
  private final NearDepthArgument withNearDepthFilter;
  private final NearThermalArgument withNearThermalFilter;
  private final NearImuArgument withNearImuFilter;
  private final Integer objectLimit;
  private final Integer limit;
  private final String tenant;

  private Stream<Argument> buildableArguments() {
    return Stream.of(withWhereFilter, withAskArgument, withNearTextFilter, withNearObjectFilter, withNearVectorFilter, withNearImageFilter, withNearAudioFilter, withNearVideoFilter, withNearDepthFilter, withNearThermalFilter, withNearImuFilter);
  }

  private Stream<Object> nonStringArguments() {
    return Stream.of(objectLimit, limit);
  }

  private Stream<String> stringArguments() {
    return Stream.of(groupByClausePropertyName, tenant);
  }

  private boolean includesFilterClause() {
    return buildableArguments().anyMatch(Objects::nonNull) || nonStringArguments().anyMatch(Objects::nonNull) || stringArguments().anyMatch(StringUtils::isNotBlank);
  }

  private String createFilterClause() {
    if (includesFilterClause()) {
      Set<String> filters = new LinkedHashSet<>();
      if (StringUtils.isNotBlank(tenant)) {
        filters.add(String.format("tenant:%s", Serializer.quote(tenant)));
      }
      if (StringUtils.isNotBlank(groupByClausePropertyName)) {
        filters.add(String.format("groupBy:%s", Serializer.quote(groupByClausePropertyName)));
      }
      buildableArguments().filter(Objects::nonNull).map(Argument::build).forEach(filters::add);
      if (limit != null) {
        filters.add(String.format("limit:%s", limit));
      }
      if (objectLimit != null) {
        filters.add(String.format("objectLimit:%s", objectLimit));
      }
      return String.format("(%s)", String.join(" ", filters));
    }
    return "";
  }

  @Override
  public String buildQuery() {
    String fieldsClause = fields != null ? fields.build() : "";
    return String.format("{Aggregate{%s%s{%s}}}", Serializer.escape(className), createFilterClause(), fieldsClause);
  }

  // created to support both types of setters: WhereArgument and deprecated WhereFilter
  public static class AggregateBuilderBuilder {
    @java.lang.SuppressWarnings("all")
    private String className;
    @java.lang.SuppressWarnings("all")
    private Fields fields;
    @java.lang.SuppressWarnings("all")
    private String groupByClausePropertyName;
    @java.lang.SuppressWarnings("all")
    private AskArgument withAskArgument;
    @java.lang.SuppressWarnings("all")
    private NearTextArgument withNearTextFilter;
    @java.lang.SuppressWarnings("all")
    private NearObjectArgument withNearObjectFilter;
    @java.lang.SuppressWarnings("all")
    private NearVectorArgument withNearVectorFilter;
    @java.lang.SuppressWarnings("all")
    private NearImageArgument withNearImageFilter;
    @java.lang.SuppressWarnings("all")
    private NearAudioArgument withNearAudioFilter;
    @java.lang.SuppressWarnings("all")
    private NearVideoArgument withNearVideoFilter;
    @java.lang.SuppressWarnings("all")
    private NearDepthArgument withNearDepthFilter;
    @java.lang.SuppressWarnings("all")
    private NearThermalArgument withNearThermalFilter;
    @java.lang.SuppressWarnings("all")
    private NearImuArgument withNearImuFilter;
    @java.lang.SuppressWarnings("all")
    private Integer objectLimit;
    @java.lang.SuppressWarnings("all")
    private Integer limit;
    @java.lang.SuppressWarnings("all")
    private String tenant;
    private WhereArgument withWhereFilter;

    @Deprecated
    public AggregateBuilderBuilder withWhereFilter(WhereFilter whereFilter) {
      this.withWhereFilter = WhereArgument.builder().filter(whereFilter).build();
      return this;
    }

    public AggregateBuilderBuilder withWhereFilter(WhereArgument whereArgument) {
      this.withWhereFilter = whereArgument;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    AggregateBuilderBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder className(final String className) {
      this.className = className;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder fields(final Fields fields) {
      this.fields = fields;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder groupByClausePropertyName(final String groupByClausePropertyName) {
      this.groupByClausePropertyName = groupByClausePropertyName;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withAskArgument(final AskArgument withAskArgument) {
      this.withAskArgument = withAskArgument;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withNearTextFilter(final NearTextArgument withNearTextFilter) {
      this.withNearTextFilter = withNearTextFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withNearObjectFilter(final NearObjectArgument withNearObjectFilter) {
      this.withNearObjectFilter = withNearObjectFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withNearVectorFilter(final NearVectorArgument withNearVectorFilter) {
      this.withNearVectorFilter = withNearVectorFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withNearImageFilter(final NearImageArgument withNearImageFilter) {
      this.withNearImageFilter = withNearImageFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withNearAudioFilter(final NearAudioArgument withNearAudioFilter) {
      this.withNearAudioFilter = withNearAudioFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withNearVideoFilter(final NearVideoArgument withNearVideoFilter) {
      this.withNearVideoFilter = withNearVideoFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withNearDepthFilter(final NearDepthArgument withNearDepthFilter) {
      this.withNearDepthFilter = withNearDepthFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withNearThermalFilter(final NearThermalArgument withNearThermalFilter) {
      this.withNearThermalFilter = withNearThermalFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withNearImuFilter(final NearImuArgument withNearImuFilter) {
      this.withNearImuFilter = withNearImuFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder objectLimit(final Integer objectLimit) {
      this.objectLimit = objectLimit;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder limit(final Integer limit) {
      this.limit = limit;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder tenant(final String tenant) {
      this.tenant = tenant;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AggregateBuilder build() {
      return new AggregateBuilder(this.className, this.fields, this.groupByClausePropertyName, this.withWhereFilter, this.withAskArgument, this.withNearTextFilter, this.withNearObjectFilter, this.withNearVectorFilter, this.withNearImageFilter, this.withNearAudioFilter, this.withNearVideoFilter, this.withNearDepthFilter, this.withNearThermalFilter, this.withNearImuFilter, this.objectLimit, this.limit, this.tenant);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "AggregateBuilder.AggregateBuilderBuilder(className=" + this.className + ", fields=" + this.fields + ", groupByClausePropertyName=" + this.groupByClausePropertyName + ", withWhereFilter=" + this.withWhereFilter + ", withAskArgument=" + this.withAskArgument + ", withNearTextFilter=" + this.withNearTextFilter + ", withNearObjectFilter=" + this.withNearObjectFilter + ", withNearVectorFilter=" + this.withNearVectorFilter + ", withNearImageFilter=" + this.withNearImageFilter + ", withNearAudioFilter=" + this.withNearAudioFilter + ", withNearVideoFilter=" + this.withNearVideoFilter + ", withNearDepthFilter=" + this.withNearDepthFilter + ", withNearThermalFilter=" + this.withNearThermalFilter + ", withNearImuFilter=" + this.withNearImuFilter + ", objectLimit=" + this.objectLimit + ", limit=" + this.limit + ", tenant=" + this.tenant + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  AggregateBuilder(final String className, final Fields fields, final String groupByClausePropertyName, final WhereArgument withWhereFilter, final AskArgument withAskArgument, final NearTextArgument withNearTextFilter, final NearObjectArgument withNearObjectFilter, final NearVectorArgument withNearVectorFilter, final NearImageArgument withNearImageFilter, final NearAudioArgument withNearAudioFilter, final NearVideoArgument withNearVideoFilter, final NearDepthArgument withNearDepthFilter, final NearThermalArgument withNearThermalFilter, final NearImuArgument withNearImuFilter, final Integer objectLimit, final Integer limit, final String tenant) {
    this.className = className;
    this.fields = fields;
    this.groupByClausePropertyName = groupByClausePropertyName;
    this.withWhereFilter = withWhereFilter;
    this.withAskArgument = withAskArgument;
    this.withNearTextFilter = withNearTextFilter;
    this.withNearObjectFilter = withNearObjectFilter;
    this.withNearVectorFilter = withNearVectorFilter;
    this.withNearImageFilter = withNearImageFilter;
    this.withNearAudioFilter = withNearAudioFilter;
    this.withNearVideoFilter = withNearVideoFilter;
    this.withNearDepthFilter = withNearDepthFilter;
    this.withNearThermalFilter = withNearThermalFilter;
    this.withNearImuFilter = withNearImuFilter;
    this.objectLimit = objectLimit;
    this.limit = limit;
    this.tenant = tenant;
  }

  @java.lang.SuppressWarnings("all")
  public static AggregateBuilder.AggregateBuilderBuilder builder() {
    return new AggregateBuilder.AggregateBuilderBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public String getClassName() {
    return this.className;
  }

  @java.lang.SuppressWarnings("all")
  public Fields getFields() {
    return this.fields;
  }

  @java.lang.SuppressWarnings("all")
  public String getGroupByClausePropertyName() {
    return this.groupByClausePropertyName;
  }

  @java.lang.SuppressWarnings("all")
  public WhereArgument getWithWhereFilter() {
    return this.withWhereFilter;
  }

  @java.lang.SuppressWarnings("all")
  public AskArgument getWithAskArgument() {
    return this.withAskArgument;
  }

  @java.lang.SuppressWarnings("all")
  public NearTextArgument getWithNearTextFilter() {
    return this.withNearTextFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearObjectArgument getWithNearObjectFilter() {
    return this.withNearObjectFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearVectorArgument getWithNearVectorFilter() {
    return this.withNearVectorFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearImageArgument getWithNearImageFilter() {
    return this.withNearImageFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearAudioArgument getWithNearAudioFilter() {
    return this.withNearAudioFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearVideoArgument getWithNearVideoFilter() {
    return this.withNearVideoFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearDepthArgument getWithNearDepthFilter() {
    return this.withNearDepthFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearThermalArgument getWithNearThermalFilter() {
    return this.withNearThermalFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearImuArgument getWithNearImuFilter() {
    return this.withNearImuFilter;
  }

  @java.lang.SuppressWarnings("all")
  public Integer getObjectLimit() {
    return this.objectLimit;
  }

  @java.lang.SuppressWarnings("all")
  public Integer getLimit() {
    return this.limit;
  }

  @java.lang.SuppressWarnings("all")
  public String getTenant() {
    return this.tenant;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "AggregateBuilder(className=" + this.getClassName() + ", fields=" + this.getFields() + ", groupByClausePropertyName=" + this.getGroupByClausePropertyName() + ", withWhereFilter=" + this.getWithWhereFilter() + ", withAskArgument=" + this.getWithAskArgument() + ", withNearTextFilter=" + this.getWithNearTextFilter() + ", withNearObjectFilter=" + this.getWithNearObjectFilter() + ", withNearVectorFilter=" + this.getWithNearVectorFilter() + ", withNearImageFilter=" + this.getWithNearImageFilter() + ", withNearAudioFilter=" + this.getWithNearAudioFilter() + ", withNearVideoFilter=" + this.getWithNearVideoFilter() + ", withNearDepthFilter=" + this.getWithNearDepthFilter() + ", withNearThermalFilter=" + this.getWithNearThermalFilter() + ", withNearImuFilter=" + this.getWithNearImuFilter() + ", objectLimit=" + this.getObjectLimit() + ", limit=" + this.getLimit() + ", tenant=" + this.getTenant() + ")";
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof AggregateBuilder)) return false;
    final AggregateBuilder other = (AggregateBuilder) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$objectLimit = this.getObjectLimit();
    final java.lang.Object other$objectLimit = other.getObjectLimit();
    if (this$objectLimit == null ? other$objectLimit != null : !this$objectLimit.equals(other$objectLimit)) return false;
    final java.lang.Object this$limit = this.getLimit();
    final java.lang.Object other$limit = other.getLimit();
    if (this$limit == null ? other$limit != null : !this$limit.equals(other$limit)) return false;
    final java.lang.Object this$className = this.getClassName();
    final java.lang.Object other$className = other.getClassName();
    if (this$className == null ? other$className != null : !this$className.equals(other$className)) return false;
    final java.lang.Object this$fields = this.getFields();
    final java.lang.Object other$fields = other.getFields();
    if (this$fields == null ? other$fields != null : !this$fields.equals(other$fields)) return false;
    final java.lang.Object this$groupByClausePropertyName = this.getGroupByClausePropertyName();
    final java.lang.Object other$groupByClausePropertyName = other.getGroupByClausePropertyName();
    if (this$groupByClausePropertyName == null ? other$groupByClausePropertyName != null : !this$groupByClausePropertyName.equals(other$groupByClausePropertyName)) return false;
    final java.lang.Object this$withWhereFilter = this.getWithWhereFilter();
    final java.lang.Object other$withWhereFilter = other.getWithWhereFilter();
    if (this$withWhereFilter == null ? other$withWhereFilter != null : !this$withWhereFilter.equals(other$withWhereFilter)) return false;
    final java.lang.Object this$withAskArgument = this.getWithAskArgument();
    final java.lang.Object other$withAskArgument = other.getWithAskArgument();
    if (this$withAskArgument == null ? other$withAskArgument != null : !this$withAskArgument.equals(other$withAskArgument)) return false;
    final java.lang.Object this$withNearTextFilter = this.getWithNearTextFilter();
    final java.lang.Object other$withNearTextFilter = other.getWithNearTextFilter();
    if (this$withNearTextFilter == null ? other$withNearTextFilter != null : !this$withNearTextFilter.equals(other$withNearTextFilter)) return false;
    final java.lang.Object this$withNearObjectFilter = this.getWithNearObjectFilter();
    final java.lang.Object other$withNearObjectFilter = other.getWithNearObjectFilter();
    if (this$withNearObjectFilter == null ? other$withNearObjectFilter != null : !this$withNearObjectFilter.equals(other$withNearObjectFilter)) return false;
    final java.lang.Object this$withNearVectorFilter = this.getWithNearVectorFilter();
    final java.lang.Object other$withNearVectorFilter = other.getWithNearVectorFilter();
    if (this$withNearVectorFilter == null ? other$withNearVectorFilter != null : !this$withNearVectorFilter.equals(other$withNearVectorFilter)) return false;
    final java.lang.Object this$withNearImageFilter = this.getWithNearImageFilter();
    final java.lang.Object other$withNearImageFilter = other.getWithNearImageFilter();
    if (this$withNearImageFilter == null ? other$withNearImageFilter != null : !this$withNearImageFilter.equals(other$withNearImageFilter)) return false;
    final java.lang.Object this$withNearAudioFilter = this.getWithNearAudioFilter();
    final java.lang.Object other$withNearAudioFilter = other.getWithNearAudioFilter();
    if (this$withNearAudioFilter == null ? other$withNearAudioFilter != null : !this$withNearAudioFilter.equals(other$withNearAudioFilter)) return false;
    final java.lang.Object this$withNearVideoFilter = this.getWithNearVideoFilter();
    final java.lang.Object other$withNearVideoFilter = other.getWithNearVideoFilter();
    if (this$withNearVideoFilter == null ? other$withNearVideoFilter != null : !this$withNearVideoFilter.equals(other$withNearVideoFilter)) return false;
    final java.lang.Object this$withNearDepthFilter = this.getWithNearDepthFilter();
    final java.lang.Object other$withNearDepthFilter = other.getWithNearDepthFilter();
    if (this$withNearDepthFilter == null ? other$withNearDepthFilter != null : !this$withNearDepthFilter.equals(other$withNearDepthFilter)) return false;
    final java.lang.Object this$withNearThermalFilter = this.getWithNearThermalFilter();
    final java.lang.Object other$withNearThermalFilter = other.getWithNearThermalFilter();
    if (this$withNearThermalFilter == null ? other$withNearThermalFilter != null : !this$withNearThermalFilter.equals(other$withNearThermalFilter)) return false;
    final java.lang.Object this$withNearImuFilter = this.getWithNearImuFilter();
    final java.lang.Object other$withNearImuFilter = other.getWithNearImuFilter();
    if (this$withNearImuFilter == null ? other$withNearImuFilter != null : !this$withNearImuFilter.equals(other$withNearImuFilter)) return false;
    final java.lang.Object this$tenant = this.getTenant();
    final java.lang.Object other$tenant = other.getTenant();
    if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof AggregateBuilder;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $objectLimit = this.getObjectLimit();
    result = result * PRIME + ($objectLimit == null ? 43 : $objectLimit.hashCode());
    final java.lang.Object $limit = this.getLimit();
    result = result * PRIME + ($limit == null ? 43 : $limit.hashCode());
    final java.lang.Object $className = this.getClassName();
    result = result * PRIME + ($className == null ? 43 : $className.hashCode());
    final java.lang.Object $fields = this.getFields();
    result = result * PRIME + ($fields == null ? 43 : $fields.hashCode());
    final java.lang.Object $groupByClausePropertyName = this.getGroupByClausePropertyName();
    result = result * PRIME + ($groupByClausePropertyName == null ? 43 : $groupByClausePropertyName.hashCode());
    final java.lang.Object $withWhereFilter = this.getWithWhereFilter();
    result = result * PRIME + ($withWhereFilter == null ? 43 : $withWhereFilter.hashCode());
    final java.lang.Object $withAskArgument = this.getWithAskArgument();
    result = result * PRIME + ($withAskArgument == null ? 43 : $withAskArgument.hashCode());
    final java.lang.Object $withNearTextFilter = this.getWithNearTextFilter();
    result = result * PRIME + ($withNearTextFilter == null ? 43 : $withNearTextFilter.hashCode());
    final java.lang.Object $withNearObjectFilter = this.getWithNearObjectFilter();
    result = result * PRIME + ($withNearObjectFilter == null ? 43 : $withNearObjectFilter.hashCode());
    final java.lang.Object $withNearVectorFilter = this.getWithNearVectorFilter();
    result = result * PRIME + ($withNearVectorFilter == null ? 43 : $withNearVectorFilter.hashCode());
    final java.lang.Object $withNearImageFilter = this.getWithNearImageFilter();
    result = result * PRIME + ($withNearImageFilter == null ? 43 : $withNearImageFilter.hashCode());
    final java.lang.Object $withNearAudioFilter = this.getWithNearAudioFilter();
    result = result * PRIME + ($withNearAudioFilter == null ? 43 : $withNearAudioFilter.hashCode());
    final java.lang.Object $withNearVideoFilter = this.getWithNearVideoFilter();
    result = result * PRIME + ($withNearVideoFilter == null ? 43 : $withNearVideoFilter.hashCode());
    final java.lang.Object $withNearDepthFilter = this.getWithNearDepthFilter();
    result = result * PRIME + ($withNearDepthFilter == null ? 43 : $withNearDepthFilter.hashCode());
    final java.lang.Object $withNearThermalFilter = this.getWithNearThermalFilter();
    result = result * PRIME + ($withNearThermalFilter == null ? 43 : $withNearThermalFilter.hashCode());
    final java.lang.Object $withNearImuFilter = this.getWithNearImuFilter();
    result = result * PRIME + ($withNearImuFilter == null ? 43 : $withNearImuFilter.hashCode());
    final java.lang.Object $tenant = this.getTenant();
    result = result * PRIME + ($tenant == null ? 43 : $tenant.hashCode());
    return result;
  }
}
