/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import io.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class HybridArgument
implements Argument {
    private final String query;
    private final Float alpha;
    private final Float[] vector;
    private final String fusionType;
    private final String[] properties;
    private final String[] targetVectors;
    private final Searches searches;

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        arg.add(String.format("query:%s", Serializer.quote(this.query)));
        if (this.vector != null) {
            arg.add(String.format("vector:%s", Serializer.array(this.vector)));
        }
        if (this.alpha != null) {
            arg.add(String.format("alpha:%s", this.alpha));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.properties)) {
            arg.add(String.format("properties:%s", Serializer.arrayWithQuotes(this.properties)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.fusionType)) {
            arg.add(String.format("fusionType:%s", this.fusionType));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.targetVectors)) {
            arg.add(String.format("targetVectors:%s", Serializer.arrayWithQuotes(this.targetVectors)));
        }
        if (this.searches != null && (this.searches.nearVector != null || this.searches.nearText != null)) {
            LinkedHashSet<String> searchesArgs = new LinkedHashSet<String>();
            if (this.searches.nearVector != null) {
                searchesArgs.add(this.searches.nearVector.build());
            }
            if (this.searches.nearText != null) {
                searchesArgs.add(this.searches.nearText.build());
            }
            arg.add(String.format("searches:{%s}", String.join((CharSequence)" ", searchesArgs)));
        }
        return String.format("hybrid:{%s}", String.join((CharSequence)" ", arg));
    }

    HybridArgument(String query, Float alpha, Float[] vector, String fusionType, String[] properties, String[] targetVectors, Searches searches) {
        this.query = query;
        this.alpha = alpha;
        this.vector = vector;
        this.fusionType = fusionType;
        this.properties = properties;
        this.targetVectors = targetVectors;
        this.searches = searches;
    }

    public static HybridArgumentBuilder builder() {
        return new HybridArgumentBuilder();
    }

    public String getQuery() {
        return this.query;
    }

    public Float getAlpha() {
        return this.alpha;
    }

    public Float[] getVector() {
        return this.vector;
    }

    public String getFusionType() {
        return this.fusionType;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public String[] getTargetVectors() {
        return this.targetVectors;
    }

    public Searches getSearches() {
        return this.searches;
    }

    public String toString() {
        return "HybridArgument(query=" + this.getQuery() + ", alpha=" + this.getAlpha() + ", vector=" + Arrays.deepToString(this.getVector()) + ", fusionType=" + this.getFusionType() + ", properties=" + Arrays.deepToString(this.getProperties()) + ", targetVectors=" + Arrays.deepToString(this.getTargetVectors()) + ", searches=" + this.getSearches() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HybridArgument)) {
            return false;
        }
        HybridArgument other = (HybridArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$alpha = this.getAlpha();
        Float other$alpha = other.getAlpha();
        if (this$alpha == null ? other$alpha != null : !((Object)this$alpha).equals(other$alpha)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getVector(), other.getVector())) {
            return false;
        }
        String this$fusionType = this.getFusionType();
        String other$fusionType = other.getFusionType();
        if (this$fusionType == null ? other$fusionType != null : !this$fusionType.equals(other$fusionType)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getProperties(), other.getProperties())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTargetVectors(), other.getTargetVectors())) {
            return false;
        }
        Searches this$searches = this.getSearches();
        Searches other$searches = other.getSearches();
        return !(this$searches == null ? other$searches != null : !this$searches.equals(other$searches));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HybridArgument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $alpha = this.getAlpha();
        result = result * 59 + ($alpha == null ? 43 : ((Object)$alpha).hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getVector());
        String $fusionType = this.getFusionType();
        result = result * 59 + ($fusionType == null ? 43 : $fusionType.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getProperties());
        result = result * 59 + Arrays.deepHashCode(this.getTargetVectors());
        Searches $searches = this.getSearches();
        result = result * 59 + ($searches == null ? 43 : $searches.hashCode());
        return result;
    }

    public static class HybridArgumentBuilder {
        private String query;
        private Float alpha;
        private Float[] vector;
        private String fusionType;
        private String[] properties;
        private String[] targetVectors;
        private Searches searches;

        HybridArgumentBuilder() {
        }

        public HybridArgumentBuilder query(String query) {
            this.query = query;
            return this;
        }

        public HybridArgumentBuilder alpha(Float alpha) {
            this.alpha = alpha;
            return this;
        }

        public HybridArgumentBuilder vector(Float[] vector) {
            this.vector = vector;
            return this;
        }

        public HybridArgumentBuilder fusionType(String fusionType) {
            this.fusionType = fusionType;
            return this;
        }

        public HybridArgumentBuilder properties(String[] properties) {
            this.properties = properties;
            return this;
        }

        public HybridArgumentBuilder targetVectors(String[] targetVectors) {
            this.targetVectors = targetVectors;
            return this;
        }

        public HybridArgumentBuilder searches(Searches searches) {
            this.searches = searches;
            return this;
        }

        public HybridArgument build() {
            return new HybridArgument(this.query, this.alpha, this.vector, this.fusionType, this.properties, this.targetVectors, this.searches);
        }

        public String toString() {
            return "HybridArgument.HybridArgumentBuilder(query=" + this.query + ", alpha=" + this.alpha + ", vector=" + Arrays.deepToString(this.vector) + ", fusionType=" + this.fusionType + ", properties=" + Arrays.deepToString(this.properties) + ", targetVectors=" + Arrays.deepToString(this.targetVectors) + ", searches=" + this.searches + ")";
        }
    }

    public static class Searches {
        private final NearVectorArgument nearVector;
        private final NearTextArgument nearText;

        Searches(NearVectorArgument nearVector, NearTextArgument nearText) {
            this.nearVector = nearVector;
            this.nearText = nearText;
        }

        public static SearchesBuilder builder() {
            return new SearchesBuilder();
        }

        public NearVectorArgument getNearVector() {
            return this.nearVector;
        }

        public NearTextArgument getNearText() {
            return this.nearText;
        }

        public String toString() {
            return "HybridArgument.Searches(nearVector=" + this.getNearVector() + ", nearText=" + this.getNearText() + ")";
        }

        public static class SearchesBuilder {
            private NearVectorArgument nearVector;
            private NearTextArgument nearText;

            SearchesBuilder() {
            }

            public SearchesBuilder nearVector(NearVectorArgument nearVector) {
                this.nearVector = nearVector;
                return this;
            }

            public SearchesBuilder nearText(NearTextArgument nearText) {
                this.nearText = nearText;
                return this;
            }

            public Searches build() {
                return new Searches(this.nearVector, this.nearText);
            }

            public String toString() {
                return "HybridArgument.Searches.SearchesBuilder(nearVector=" + this.nearVector + ", nearText=" + this.nearText + ")";
            }
        }
    }
}

