/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.argument.NearMediaArgumentHelper;
import java.io.File;
import java.util.Arrays;

public class NearAudioArgument
implements Argument {
    private final String audio;
    private final File audioFile;
    private final Float certainty;
    private final Float distance;
    private final String[] targetVectors;

    @Override
    public String build() {
        return NearMediaArgumentHelper.builder().certainty(this.certainty).distance(this.distance).targetVectors(this.targetVectors).data(this.audio).dataFile(this.audioFile).mediaField("audio").mediaName("nearAudio").build().build();
    }

    NearAudioArgument(String audio, File audioFile, Float certainty, Float distance, String[] targetVectors) {
        this.audio = audio;
        this.audioFile = audioFile;
        this.certainty = certainty;
        this.distance = distance;
        this.targetVectors = targetVectors;
    }

    public static NearAudioArgumentBuilder builder() {
        return new NearAudioArgumentBuilder();
    }

    public String getAudio() {
        return this.audio;
    }

    public File getAudioFile() {
        return this.audioFile;
    }

    public Float getCertainty() {
        return this.certainty;
    }

    public Float getDistance() {
        return this.distance;
    }

    public String[] getTargetVectors() {
        return this.targetVectors;
    }

    public String toString() {
        return "NearAudioArgument(audio=" + this.getAudio() + ", audioFile=" + this.getAudioFile() + ", certainty=" + this.getCertainty() + ", distance=" + this.getDistance() + ", targetVectors=" + Arrays.deepToString(this.getTargetVectors()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NearAudioArgument)) {
            return false;
        }
        NearAudioArgument other = (NearAudioArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$certainty = this.getCertainty();
        Float other$certainty = other.getCertainty();
        if (this$certainty == null ? other$certainty != null : !((Object)this$certainty).equals(other$certainty)) {
            return false;
        }
        Float this$distance = this.getDistance();
        Float other$distance = other.getDistance();
        if (this$distance == null ? other$distance != null : !((Object)this$distance).equals(other$distance)) {
            return false;
        }
        String this$audio = this.getAudio();
        String other$audio = other.getAudio();
        if (this$audio == null ? other$audio != null : !this$audio.equals(other$audio)) {
            return false;
        }
        File this$audioFile = this.getAudioFile();
        File other$audioFile = other.getAudioFile();
        if (this$audioFile == null ? other$audioFile != null : !((Object)this$audioFile).equals(other$audioFile)) {
            return false;
        }
        return Arrays.deepEquals(this.getTargetVectors(), other.getTargetVectors());
    }

    protected boolean canEqual(Object other) {
        return other instanceof NearAudioArgument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $certainty = this.getCertainty();
        result = result * 59 + ($certainty == null ? 43 : ((Object)$certainty).hashCode());
        Float $distance = this.getDistance();
        result = result * 59 + ($distance == null ? 43 : ((Object)$distance).hashCode());
        String $audio = this.getAudio();
        result = result * 59 + ($audio == null ? 43 : $audio.hashCode());
        File $audioFile = this.getAudioFile();
        result = result * 59 + ($audioFile == null ? 43 : ((Object)$audioFile).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTargetVectors());
        return result;
    }

    public static class NearAudioArgumentBuilder {
        private String audio;
        private File audioFile;
        private Float certainty;
        private Float distance;
        private String[] targetVectors;

        NearAudioArgumentBuilder() {
        }

        public NearAudioArgumentBuilder audio(String audio) {
            this.audio = audio;
            return this;
        }

        public NearAudioArgumentBuilder audioFile(File audioFile) {
            this.audioFile = audioFile;
            return this;
        }

        public NearAudioArgumentBuilder certainty(Float certainty) {
            this.certainty = certainty;
            return this;
        }

        public NearAudioArgumentBuilder distance(Float distance) {
            this.distance = distance;
            return this;
        }

        public NearAudioArgumentBuilder targetVectors(String[] targetVectors) {
            this.targetVectors = targetVectors;
            return this;
        }

        public NearAudioArgument build() {
            return new NearAudioArgument(this.audio, this.audioFile, this.certainty, this.distance, this.targetVectors);
        }

        public String toString() {
            return "NearAudioArgument.NearAudioArgumentBuilder(audio=" + this.audio + ", audioFile=" + this.audioFile + ", certainty=" + this.certainty + ", distance=" + this.distance + ", targetVectors=" + Arrays.deepToString(this.targetVectors) + ")";
        }
    }
}

