/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporter.proto;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.ListValue;
import com.google.protobuf.Message;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import io.zeebe.exporter.proto.Schema;
import io.zeebe.protocol.record.Record;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.value.BpmnElementType;
import io.zeebe.protocol.record.value.DeploymentRecordValue;
import io.zeebe.protocol.record.value.ErrorRecordValue;
import io.zeebe.protocol.record.value.IncidentRecordValue;
import io.zeebe.protocol.record.value.JobBatchRecordValue;
import io.zeebe.protocol.record.value.JobRecordValue;
import io.zeebe.protocol.record.value.MessageRecordValue;
import io.zeebe.protocol.record.value.MessageStartEventSubscriptionRecordValue;
import io.zeebe.protocol.record.value.MessageSubscriptionRecordValue;
import io.zeebe.protocol.record.value.TimerRecordValue;
import io.zeebe.protocol.record.value.VariableDocumentRecordValue;
import io.zeebe.protocol.record.value.VariableDocumentUpdateSemantic;
import io.zeebe.protocol.record.value.VariableRecordValue;
import io.zeebe.protocol.record.value.WorkflowInstanceCreationRecordValue;
import io.zeebe.protocol.record.value.WorkflowInstanceRecordValue;
import io.zeebe.protocol.record.value.WorkflowInstanceResultRecordValue;
import io.zeebe.protocol.record.value.WorkflowInstanceSubscriptionRecordValue;
import io.zeebe.protocol.record.value.deployment.DeployedWorkflow;
import io.zeebe.protocol.record.value.deployment.DeploymentResource;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class RecordTransformer {
    private static final EnumMap<ValueType, Function<Record, GeneratedMessageV3>> TRANSFORMERS = new EnumMap(ValueType.class);
    private static final EnumMap<ValueType, Schema.RecordMetadata.ValueType> VALUE_TYPE_MAPPING = new EnumMap(ValueType.class);
    private static final EnumMap<RecordType, Schema.RecordMetadata.RecordType> RECORD_TYPE_MAPPING = new EnumMap<RecordType, Schema.RecordMetadata.RecordType>(Map.of(RecordType.COMMAND, Schema.RecordMetadata.RecordType.COMMAND, RecordType.COMMAND_REJECTION, Schema.RecordMetadata.RecordType.COMMAND_REJECTION, RecordType.EVENT, Schema.RecordMetadata.RecordType.EVENT));
    private static final EnumMap<BpmnElementType, Schema.WorkflowInstanceRecord.BpmnElementType> BPMN_ELEMENT_TYPE_MAPPING = new EnumMap(BpmnElementType.class);
    private static final EnumMap<VariableDocumentUpdateSemantic, Schema.VariableDocumentRecord.UpdateSemantics> UPDATE_SEMANTICS_MAPPING = new EnumMap<VariableDocumentUpdateSemantic, Schema.VariableDocumentRecord.UpdateSemantics>(Map.of(VariableDocumentUpdateSemantic.LOCAL, Schema.VariableDocumentRecord.UpdateSemantics.LOCAL, VariableDocumentUpdateSemantic.PROPAGATE, Schema.VariableDocumentRecord.UpdateSemantics.PROPAGATE));

    private RecordTransformer() {
    }

    public static GeneratedMessageV3 toProtobufMessage(Record record) {
        ValueType valueType = record.getValueType();
        Function<Record, GeneratedMessageV3> toRecordFunc = TRANSFORMERS.get(valueType);
        return toRecordFunc != null ? toRecordFunc.apply(record) : Empty.getDefaultInstance();
    }

    public static Schema.RecordId toRecordId(Record record) {
        return Schema.RecordId.newBuilder().setPartitionId(record.getPartitionId()).setPosition(record.getPosition()).build();
    }

    public static Schema.Record toGenericRecord(Record record) {
        GeneratedMessageV3 protobufRecord = RecordTransformer.toProtobufMessage(record);
        Any anyRecord = Any.pack((Message)protobufRecord);
        return Schema.Record.newBuilder().setRecord(anyRecord).build();
    }

    private static Schema.RecordMetadata toMetadata(Record record) {
        Schema.RecordMetadata.Builder builder = Schema.RecordMetadata.newBuilder().setIntent(record.getIntent().name()).setValueType(RecordTransformer.toValueType(record.getValueType())).setKey(record.getKey()).setRecordType(RecordTransformer.toRecordType(record.getRecordType())).setSourceRecordPosition(record.getSourceRecordPosition()).setPosition(record.getPosition()).setTimestamp(record.getTimestamp()).setPartitionId(record.getPartitionId());
        if (record.getRejectionType() != null) {
            builder.setRejectionType(record.getRejectionType().name());
            builder.setRejectionReason(record.getRejectionReason());
        }
        return builder.build();
    }

    private static Schema.RecordMetadata.ValueType toValueType(ValueType valueType) {
        return VALUE_TYPE_MAPPING.getOrDefault(valueType, Schema.RecordMetadata.ValueType.UNKNOWN_VALUE_TYPE);
    }

    private static Schema.RecordMetadata.RecordType toRecordType(RecordType recordType) {
        return RECORD_TYPE_MAPPING.getOrDefault(recordType, Schema.RecordMetadata.RecordType.UNKNOWN_RECORD_TYPE);
    }

    private static Schema.DeploymentRecord toDeploymentRecord(Record<DeploymentRecordValue> record) {
        Schema.DeploymentRecord.Builder builder = Schema.DeploymentRecord.newBuilder().setMetadata(RecordTransformer.toMetadata(record));
        for (DeploymentResource resource : ((DeploymentRecordValue)record.getValue()).getResources()) {
            builder.addResources(RecordTransformer.toDeploymentRecordResource(resource));
        }
        for (DeployedWorkflow workflow : ((DeploymentRecordValue)record.getValue()).getDeployedWorkflows()) {
            builder.addDeployedWorkflows(RecordTransformer.toDeploymentRecordWorkflow(workflow));
        }
        return builder.build();
    }

    private static Schema.DeploymentRecord.Resource toDeploymentRecordResource(DeploymentResource resource) {
        return Schema.DeploymentRecord.Resource.newBuilder().setResource(ByteString.copyFrom((byte[])resource.getResource())).setResourceName(resource.getResourceName()).setResourceType(resource.getResourceType().name()).build();
    }

    private static Schema.DeploymentRecord.Workflow toDeploymentRecordWorkflow(DeployedWorkflow workflow) {
        return Schema.DeploymentRecord.Workflow.newBuilder().setBpmnProcessId(workflow.getBpmnProcessId()).setResourceName(workflow.getResourceName()).setVersion(workflow.getVersion()).setWorkflowKey(workflow.getWorkflowKey()).build();
    }

    private static Schema.IncidentRecord toIncidentRecord(Record<IncidentRecordValue> record) {
        IncidentRecordValue value = (IncidentRecordValue)record.getValue();
        return Schema.IncidentRecord.newBuilder().setBpmnProcessId(value.getBpmnProcessId()).setElementId(value.getElementId()).setElementInstanceKey(value.getElementInstanceKey()).setErrorMessage(value.getErrorMessage()).setErrorType(value.getErrorType().name()).setJobKey(value.getJobKey()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setWorkflowKey(value.getWorkflowKey()).setVariableScopeKey(value.getVariableScopeKey()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.JobRecord toJobRecord(Record<JobRecordValue> record) {
        Schema.JobRecord.Builder builder = RecordTransformer.toJobRecord((JobRecordValue)record.getValue());
        return builder.setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.JobRecord.Builder toJobRecord(JobRecordValue value) {
        return Schema.JobRecord.newBuilder().setDeadline(value.getDeadline()).setErrorMessage(value.getErrorMessage()).setRetries(value.getRetries()).setType(value.getType()).setWorker(value.getWorker()).setVariables(RecordTransformer.toStruct(value.getVariables())).setCustomHeaders(RecordTransformer.toStruct(value.getCustomHeaders())).setBpmnProcessId(value.getBpmnProcessId()).setElementId(value.getElementId()).setElementInstanceKey(value.getElementInstanceKey()).setWorkflowDefinitionVersion(value.getWorkflowDefinitionVersion()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setWorkflowKey(value.getWorkflowKey());
    }

    private static Schema.JobBatchRecord toJobBatchRecord(Record<JobBatchRecordValue> record) {
        JobBatchRecordValue value = (JobBatchRecordValue)record.getValue();
        Schema.JobBatchRecord.Builder builder = Schema.JobBatchRecord.newBuilder();
        if (!value.getJobs().isEmpty()) {
            for (JobRecordValue job : value.getJobs()) {
                builder.addJobs(RecordTransformer.toJobRecord(job));
            }
        }
        if (!value.getJobKeys().isEmpty()) {
            builder.addAllJobKeys(value.getJobKeys());
        }
        return builder.setMaxJobsToActivate(value.getMaxJobsToActivate()).setTimeout(value.getTimeout()).setType(value.getType()).setWorker(value.getWorker()).setTruncated(value.isTruncated()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.MessageRecord toMessageRecord(Record<MessageRecordValue> record) {
        MessageRecordValue value = (MessageRecordValue)record.getValue();
        return Schema.MessageRecord.newBuilder().setCorrelationKey(value.getCorrelationKey()).setMessageId(value.getMessageId()).setName(value.getName()).setTimeToLive(value.getTimeToLive()).setVariables(RecordTransformer.toStruct(value.getVariables())).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.MessageSubscriptionRecord toMessageSubscriptionRecord(Record<MessageSubscriptionRecordValue> record) {
        MessageSubscriptionRecordValue value = (MessageSubscriptionRecordValue)record.getValue();
        return Schema.MessageSubscriptionRecord.newBuilder().setCorrelationKey(value.getCorrelationKey()).setElementInstanceKey(value.getElementInstanceKey()).setMessageName(value.getMessageName()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setBpmnProcessId(value.getBpmnProcessId()).setMessageKey(value.getMessageKey()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.MessageStartEventSubscriptionRecord toMessageStartEventSubscriptionRecord(Record<MessageStartEventSubscriptionRecordValue> record) {
        MessageStartEventSubscriptionRecordValue value = (MessageStartEventSubscriptionRecordValue)record.getValue();
        Schema.MessageStartEventSubscriptionRecord.Builder builder = Schema.MessageStartEventSubscriptionRecord.newBuilder();
        builder.setWorkflowKey(value.getWorkflowKey()).setMessageName(value.getMessageName()).setStartEventId(value.getStartEventId()).setBpmnProcessId(value.getBpmnProcessId());
        return builder.setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.VariableRecord toVariableRecord(Record<VariableRecordValue> record) {
        VariableRecordValue value = (VariableRecordValue)record.getValue();
        Schema.VariableRecord.Builder builder = Schema.VariableRecord.newBuilder();
        builder.setScopeKey(value.getScopeKey()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setWorkflowKey(value.getWorkflowKey()).setName(value.getName()).setValue(value.getValue());
        return builder.setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.TimerRecord toTimerRecord(Record<TimerRecordValue> record) {
        TimerRecordValue value = (TimerRecordValue)record.getValue();
        return Schema.TimerRecord.newBuilder().setDueDate(value.getDueDate()).setRepetitions(value.getRepetitions()).setElementInstanceKey(value.getElementInstanceKey()).setTargetFlowNodeId(value.getTargetElementId()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setWorkflowKey(value.getWorkflowKey()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.WorkflowInstanceRecord toWorkflowInstanceRecord(Record<WorkflowInstanceRecordValue> record) {
        WorkflowInstanceRecordValue value = (WorkflowInstanceRecordValue)record.getValue();
        return Schema.WorkflowInstanceRecord.newBuilder().setBpmnProcessId(value.getBpmnProcessId()).setElementId(value.getElementId()).setFlowScopeKey(value.getFlowScopeKey()).setVersion(value.getVersion()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setWorkflowKey(value.getWorkflowKey()).setBpmnElementType(RecordTransformer.toBpmnElementType(value.getBpmnElementType())).setParentWorkflowInstanceKey(value.getParentWorkflowInstanceKey()).setParentElementInstanceKey(value.getParentElementInstanceKey()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.WorkflowInstanceRecord.BpmnElementType toBpmnElementType(BpmnElementType type) {
        return BPMN_ELEMENT_TYPE_MAPPING.getOrDefault(type, Schema.WorkflowInstanceRecord.BpmnElementType.UNKNOWN_BPMN_ELEMENT_TYPE);
    }

    private static Schema.WorkflowInstanceSubscriptionRecord toWorkflowInstanceSubscriptionRecord(Record<WorkflowInstanceSubscriptionRecordValue> record) {
        WorkflowInstanceSubscriptionRecordValue value = (WorkflowInstanceSubscriptionRecordValue)record.getValue();
        return Schema.WorkflowInstanceSubscriptionRecord.newBuilder().setElementInstanceKey(value.getElementInstanceKey()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setMessageName(value.getMessageName()).setVariables(RecordTransformer.toStruct(value.getVariables())).setBpmnProcessId(value.getBpmnProcessId()).setMessageKey(value.getMessageKey()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.WorkflowInstanceCreationRecord toWorkflowInstanceCreationRecord(Record<WorkflowInstanceCreationRecordValue> record) {
        WorkflowInstanceCreationRecordValue value = (WorkflowInstanceCreationRecordValue)record.getValue();
        return Schema.WorkflowInstanceCreationRecord.newBuilder().setBpmnProcessId(value.getBpmnProcessId()).setVersion(value.getVersion()).setWorkflowKey(value.getWorkflowKey()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setVariables(RecordTransformer.toStruct(value.getVariables())).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.WorkflowInstanceResultRecord toWorkflowInstanceResultRecord(Record<WorkflowInstanceResultRecordValue> record) {
        WorkflowInstanceResultRecordValue value = (WorkflowInstanceResultRecordValue)record.getValue();
        return Schema.WorkflowInstanceResultRecord.newBuilder().setBpmnProcessId(value.getBpmnProcessId()).setVersion(value.getVersion()).setWorkflowKey(value.getWorkflowKey()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setVariables(RecordTransformer.toStruct(value.getVariables())).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.VariableDocumentRecord toVariableDocumentRecord(Record<VariableDocumentRecordValue> record) {
        VariableDocumentRecordValue value = (VariableDocumentRecordValue)record.getValue();
        return Schema.VariableDocumentRecord.newBuilder().setScopeKey(value.getScopeKey()).setUpdateSemantics(RecordTransformer.toUpdateSemantics(value.getUpdateSemantics())).setVariables(RecordTransformer.toStruct(value.getVariables())).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.VariableDocumentRecord.UpdateSemantics toUpdateSemantics(VariableDocumentUpdateSemantic updateSemantics) {
        return UPDATE_SEMANTICS_MAPPING.getOrDefault(updateSemantics, Schema.VariableDocumentRecord.UpdateSemantics.UNKNOWN_UPDATE_SEMANTICS);
    }

    private static Schema.ErrorRecord toErrorRecord(Record<ErrorRecordValue> record) {
        ErrorRecordValue value = (ErrorRecordValue)record.getValue();
        return Schema.ErrorRecord.newBuilder().setExceptionMessage(value.getExceptionMessage()).setStacktrace(value.getStacktrace()).setErrorEventPosition(value.getErrorEventPosition()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Struct toStruct(Map<?, ?> map) {
        Struct.Builder builder = Struct.newBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            builder.putFields(entry.getKey().toString(), RecordTransformer.toValue(entry.getValue()));
        }
        return builder.build();
    }

    private static Value toValue(Object object) {
        Value.Builder builder = Value.newBuilder();
        if (object == null) {
            builder.setNullValue(NullValue.NULL_VALUE);
        } else if (object instanceof Number) {
            builder.setNumberValue(((Number)object).doubleValue());
        } else if (object instanceof Boolean) {
            builder.setBoolValue(((Boolean)object).booleanValue());
        } else if (object instanceof List) {
            List list = (List)object;
            ListValue.Builder listBuilder = ListValue.newBuilder();
            for (Object item : list) {
                listBuilder.addValues(RecordTransformer.toValue(item));
            }
            builder.setListValue(listBuilder.build());
        } else if (object instanceof Map) {
            builder.setStructValue(RecordTransformer.toStruct((Map)object));
        } else if (object instanceof String) {
            builder.setStringValue((String)object);
        } else {
            throw new IllegalArgumentException(String.format("Unexpected struct value of type %s, should be one of: null, Number, Boolean, List, Map, String", object.getClass().getCanonicalName()));
        }
        return builder.build();
    }

    static {
        TRANSFORMERS.put(ValueType.DEPLOYMENT, RecordTransformer::toDeploymentRecord);
        TRANSFORMERS.put(ValueType.WORKFLOW_INSTANCE, RecordTransformer::toWorkflowInstanceRecord);
        TRANSFORMERS.put(ValueType.JOB_BATCH, RecordTransformer::toJobBatchRecord);
        TRANSFORMERS.put(ValueType.JOB, RecordTransformer::toJobRecord);
        TRANSFORMERS.put(ValueType.INCIDENT, RecordTransformer::toIncidentRecord);
        TRANSFORMERS.put(ValueType.MESSAGE, RecordTransformer::toMessageRecord);
        TRANSFORMERS.put(ValueType.MESSAGE_SUBSCRIPTION, RecordTransformer::toMessageSubscriptionRecord);
        TRANSFORMERS.put(ValueType.WORKFLOW_INSTANCE_SUBSCRIPTION, RecordTransformer::toWorkflowInstanceSubscriptionRecord);
        TRANSFORMERS.put(ValueType.TIMER, RecordTransformer::toTimerRecord);
        TRANSFORMERS.put(ValueType.VARIABLE, RecordTransformer::toVariableRecord);
        TRANSFORMERS.put(ValueType.MESSAGE_START_EVENT_SUBSCRIPTION, RecordTransformer::toMessageStartEventSubscriptionRecord);
        TRANSFORMERS.put(ValueType.WORKFLOW_INSTANCE_CREATION, RecordTransformer::toWorkflowInstanceCreationRecord);
        TRANSFORMERS.put(ValueType.VARIABLE_DOCUMENT, RecordTransformer::toVariableDocumentRecord);
        TRANSFORMERS.put(ValueType.ERROR, RecordTransformer::toErrorRecord);
        TRANSFORMERS.put(ValueType.WORKFLOW_INSTANCE_RESULT, RecordTransformer::toWorkflowInstanceResultRecord);
        VALUE_TYPE_MAPPING.put(ValueType.DEPLOYMENT, Schema.RecordMetadata.ValueType.DEPLOYMENT);
        VALUE_TYPE_MAPPING.put(ValueType.ERROR, Schema.RecordMetadata.ValueType.ERROR);
        VALUE_TYPE_MAPPING.put(ValueType.INCIDENT, Schema.RecordMetadata.ValueType.INCIDENT);
        VALUE_TYPE_MAPPING.put(ValueType.JOB, Schema.RecordMetadata.ValueType.JOB);
        VALUE_TYPE_MAPPING.put(ValueType.JOB_BATCH, Schema.RecordMetadata.ValueType.JOB_BATCH);
        VALUE_TYPE_MAPPING.put(ValueType.MESSAGE, Schema.RecordMetadata.ValueType.MESSAGE);
        VALUE_TYPE_MAPPING.put(ValueType.MESSAGE_START_EVENT_SUBSCRIPTION, Schema.RecordMetadata.ValueType.MESSAGE_START_EVENT_SUBSCRIPTION);
        VALUE_TYPE_MAPPING.put(ValueType.MESSAGE_SUBSCRIPTION, Schema.RecordMetadata.ValueType.MESSAGE_SUBSCRIPTION);
        VALUE_TYPE_MAPPING.put(ValueType.TIMER, Schema.RecordMetadata.ValueType.TIMER);
        VALUE_TYPE_MAPPING.put(ValueType.VARIABLE, Schema.RecordMetadata.ValueType.VARIABLE);
        VALUE_TYPE_MAPPING.put(ValueType.VARIABLE_DOCUMENT, Schema.RecordMetadata.ValueType.VARIABLE_DOCUMENT);
        VALUE_TYPE_MAPPING.put(ValueType.WORKFLOW_INSTANCE, Schema.RecordMetadata.ValueType.WORKFLOW_INSTANCE);
        VALUE_TYPE_MAPPING.put(ValueType.WORKFLOW_INSTANCE_CREATION, Schema.RecordMetadata.ValueType.WORKFLOW_INSTANCE_CREATION);
        VALUE_TYPE_MAPPING.put(ValueType.WORKFLOW_INSTANCE_RESULT, Schema.RecordMetadata.ValueType.WORKFLOW_INSTANCE_RESULT);
        VALUE_TYPE_MAPPING.put(ValueType.WORKFLOW_INSTANCE_SUBSCRIPTION, Schema.RecordMetadata.ValueType.WORKFLOW_INSTANCE_SUBSCRIPTION);
        BPMN_ELEMENT_TYPE_MAPPING.put(BpmnElementType.BOUNDARY_EVENT, Schema.WorkflowInstanceRecord.BpmnElementType.BOUNDARY_EVENT);
        BPMN_ELEMENT_TYPE_MAPPING.put(BpmnElementType.CALL_ACTIVITY, Schema.WorkflowInstanceRecord.BpmnElementType.CALL_ACTIVITY);
        BPMN_ELEMENT_TYPE_MAPPING.put(BpmnElementType.END_EVENT, Schema.WorkflowInstanceRecord.BpmnElementType.END_EVENT);
        BPMN_ELEMENT_TYPE_MAPPING.put(BpmnElementType.EVENT_BASED_GATEWAY, Schema.WorkflowInstanceRecord.BpmnElementType.EVENT_BASED_GATEWAY);
        BPMN_ELEMENT_TYPE_MAPPING.put(BpmnElementType.EXCLUSIVE_GATEWAY, Schema.WorkflowInstanceRecord.BpmnElementType.EXCLUSIVE_GATEWAY);
        BPMN_ELEMENT_TYPE_MAPPING.put(BpmnElementType.INTERMEDIATE_CATCH_EVENT, Schema.WorkflowInstanceRecord.BpmnElementType.INTERMEDIATE_CATCH_EVENT);
        BPMN_ELEMENT_TYPE_MAPPING.put(BpmnElementType.MULTI_INSTANCE_BODY, Schema.WorkflowInstanceRecord.BpmnElementType.MULTI_INSTANCE_BODY);
        BPMN_ELEMENT_TYPE_MAPPING.put(BpmnElementType.PARALLEL_GATEWAY, Schema.WorkflowInstanceRecord.BpmnElementType.PARALLEL_GATEWAY);
        BPMN_ELEMENT_TYPE_MAPPING.put(BpmnElementType.PROCESS, Schema.WorkflowInstanceRecord.BpmnElementType.PROCESS);
        BPMN_ELEMENT_TYPE_MAPPING.put(BpmnElementType.RECEIVE_TASK, Schema.WorkflowInstanceRecord.BpmnElementType.RECEIVE_TASK);
        BPMN_ELEMENT_TYPE_MAPPING.put(BpmnElementType.SEQUENCE_FLOW, Schema.WorkflowInstanceRecord.BpmnElementType.SEQUENCE_FLOW);
        BPMN_ELEMENT_TYPE_MAPPING.put(BpmnElementType.SERVICE_TASK, Schema.WorkflowInstanceRecord.BpmnElementType.SERVICE_TASK);
        BPMN_ELEMENT_TYPE_MAPPING.put(BpmnElementType.START_EVENT, Schema.WorkflowInstanceRecord.BpmnElementType.START_EVENT);
        BPMN_ELEMENT_TYPE_MAPPING.put(BpmnElementType.SUB_PROCESS, Schema.WorkflowInstanceRecord.BpmnElementType.SUB_PROCESS);
    }
}

