/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.immutables;

import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.value.DeploymentDistributionRecordValue;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ErrorRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageStartEventSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessEventRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceCreationRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceResultRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.record.value.deployment.Process;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.zeebe.protocol.immutables.record.value.ImmutableDeploymentDistributionRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableDeploymentRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableErrorRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableIncidentRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableJobBatchRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableJobRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableMessageRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableMessageStartEventSubscriptionRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableMessageSubscriptionRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableProcessEventRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableProcessInstanceCreationRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableProcessInstanceRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableProcessInstanceResultRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableProcessMessageSubscriptionRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableRecord;
import io.zeebe.protocol.immutables.record.value.ImmutableTimerRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableVariableDocumentRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableVariableRecordValue;
import io.zeebe.protocol.immutables.record.value.deployment.ImmutableDeploymentResource;
import io.zeebe.protocol.immutables.record.value.deployment.ImmutableProcess;
import io.zeebe.protocol.immutables.record.value.deployment.ImmutableProcessMetadata;
import java.util.ArrayList;

public final class ImmutableRecordCopier {
    private ImmutableRecordCopier() {
    }

    public static <T extends RecordValue, U extends T> ImmutableRecord<U> deepCopyOfRecord(Record<T> record) {
        ImmutableRecord.Builder<RecordValue> originalBuilder;
        RecordValue value = ImmutableRecordCopier.deepCopyOfRecordValue(record.getValueType(), record.getValue());
        ImmutableRecord.Builder<RecordValue> convertedBuilder = originalBuilder = ImmutableRecord.builder().from(record);
        return convertedBuilder.value(value).build();
    }

    public static <T extends RecordValue, U extends T> T deepCopyOfRecordValue(ValueType type, T value) {
        switch (type) {
            case JOB: {
                return (T)ImmutableJobRecordValue.builder().from((JobRecordValue)value).build();
            }
            case DEPLOYMENT: {
                return (T)ImmutableRecordCopier.deepCopyOfDeploymentRecordValue((DeploymentRecordValue)value);
            }
            case PROCESS_INSTANCE: {
                return (T)ImmutableProcessInstanceRecordValue.builder().from((ProcessInstanceRecordValue)value).build();
            }
            case INCIDENT: {
                return (T)ImmutableIncidentRecordValue.builder().from((IncidentRecordValue)value).build();
            }
            case MESSAGE: {
                return (T)ImmutableMessageRecordValue.builder().from((MessageRecordValue)value).build();
            }
            case MESSAGE_SUBSCRIPTION: {
                return (T)ImmutableMessageSubscriptionRecordValue.builder().from((MessageSubscriptionRecordValue)value).build();
            }
            case PROCESS_MESSAGE_SUBSCRIPTION: {
                return (T)ImmutableProcessMessageSubscriptionRecordValue.builder().from((ProcessMessageSubscriptionRecordValue)value).build();
            }
            case JOB_BATCH: {
                return (T)ImmutableRecordCopier.deepCopyOfJobBatchRecordValue((JobBatchRecordValue)value);
            }
            case TIMER: {
                return (T)ImmutableTimerRecordValue.builder().from((TimerRecordValue)value).build();
            }
            case MESSAGE_START_EVENT_SUBSCRIPTION: {
                return (T)ImmutableMessageStartEventSubscriptionRecordValue.builder().from((MessageStartEventSubscriptionRecordValue)value).build();
            }
            case VARIABLE: {
                return (T)ImmutableVariableRecordValue.builder().from((VariableRecordValue)value).build();
            }
            case VARIABLE_DOCUMENT: {
                return (T)ImmutableVariableDocumentRecordValue.builder().from((VariableDocumentRecordValue)value).build();
            }
            case PROCESS_INSTANCE_CREATION: {
                return (T)ImmutableProcessInstanceCreationRecordValue.builder().from((ProcessInstanceCreationRecordValue)value).build();
            }
            case ERROR: {
                return (T)ImmutableErrorRecordValue.builder().from((ErrorRecordValue)value).build();
            }
            case PROCESS_INSTANCE_RESULT: {
                return (T)ImmutableProcessInstanceResultRecordValue.builder().from((ProcessInstanceResultRecordValue)value).build();
            }
            case PROCESS: {
                return (T)ImmutableProcess.builder().from((Process)value).build();
            }
            case DEPLOYMENT_DISTRIBUTION: {
                return (T)ImmutableDeploymentDistributionRecordValue.builder().from((DeploymentDistributionRecordValue)value).build();
            }
            case PROCESS_EVENT: {
                return (T)ImmutableProcessEventRecordValue.builder().from((ProcessEventRecordValue)value).build();
            }
        }
        throw new IllegalArgumentException("Unknown value type " + type);
    }

    private static ImmutableDeploymentRecordValue deepCopyOfDeploymentRecordValue(DeploymentRecordValue value) {
        ArrayList<ImmutableProcessMetadata> processes = new ArrayList<ImmutableProcessMetadata>();
        ArrayList<ImmutableDeploymentResource> resources = new ArrayList<ImmutableDeploymentResource>();
        for (ProcessMetadataValue process : value.getProcessesMetadata()) {
            ImmutableProcessMetadata immutableProcess = process instanceof ImmutableProcessMetadata ? (ImmutableProcessMetadata)process : ImmutableProcessMetadata.builder().from(process).build();
            processes.add(immutableProcess);
        }
        for (DeploymentResource resource : value.getResources()) {
            ImmutableDeploymentResource immutableResource = resource instanceof ImmutableDeploymentResource ? (ImmutableDeploymentResource)resource : ImmutableDeploymentResource.builder().from(resource).build();
            resources.add(immutableResource);
        }
        return ImmutableDeploymentRecordValue.builder().from(value).resources(resources).processesMetadata(processes).build();
    }

    private static ImmutableJobBatchRecordValue deepCopyOfJobBatchRecordValue(JobBatchRecordValue value) {
        ArrayList<ImmutableJobRecordValue> jobs = new ArrayList<ImmutableJobRecordValue>();
        for (JobRecordValue job : value.getJobs()) {
            ImmutableJobRecordValue immutableJob = job instanceof ImmutableJobRecordValue ? (ImmutableJobRecordValue)job : ImmutableJobRecordValue.builder().from(job).build();
            jobs.add(immutableJob);
        }
        return ImmutableJobBatchRecordValue.builder().from(value).jobs(jobs).build();
    }
}

