/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.immutables.record.value;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.zeebe.protocol.immutables.record.value.AbstractDeploymentRecordValue;
import io.zeebe.protocol.immutables.record.value.deployment.ImmutableDeploymentResource;
import io.zeebe.protocol.immutables.record.value.deployment.ImmutableProcessMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractDeploymentRecordValue", generator="Immutables")
public final class ImmutableDeploymentRecordValue
extends AbstractDeploymentRecordValue {
    private final List<DeploymentResource> resources;
    private final List<ProcessMetadataValue> processesMetadata;
    private final transient int hashCode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDeploymentRecordValue(Builder builder) {
        if (builder.resourcesIsSet()) {
            this.initShim.resources(ImmutableDeploymentRecordValue.createUnmodifiableList(true, builder.resources));
        }
        if (builder.processesMetadataIsSet()) {
            this.initShim.processesMetadata(ImmutableDeploymentRecordValue.createUnmodifiableList(true, builder.processesMetadata));
        }
        this.resources = this.initShim.getResources();
        this.processesMetadata = this.initShim.getProcessesMetadata();
        this.hashCode = this.computeHashCode();
        this.initShim = null;
    }

    private ImmutableDeploymentRecordValue(List<DeploymentResource> resources, List<ProcessMetadataValue> processesMetadata) {
        this.resources = resources;
        this.processesMetadata = processesMetadata;
        this.hashCode = this.computeHashCode();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="resources")
    @JsonDeserialize(contentAs=ImmutableDeploymentResource.class)
    public List<DeploymentResource> getResources() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getResources() : this.resources;
    }

    @Override
    @JsonProperty(value="processesMetadata")
    @JsonDeserialize(contentAs=ImmutableProcessMetadata.class)
    public List<ProcessMetadataValue> getProcessesMetadata() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getProcessesMetadata() : this.processesMetadata;
    }

    public final ImmutableDeploymentRecordValue withResources(DeploymentResource ... elements) {
        List<DeploymentResource> newValue = ImmutableDeploymentRecordValue.createUnmodifiableList(false, ImmutableDeploymentRecordValue.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableDeploymentRecordValue(newValue, this.processesMetadata);
    }

    public final ImmutableDeploymentRecordValue withResources(Iterable<? extends DeploymentResource> elements) {
        if (this.resources == elements) {
            return this;
        }
        List<DeploymentResource> newValue = ImmutableDeploymentRecordValue.createUnmodifiableList(false, ImmutableDeploymentRecordValue.createSafeList(elements, false, false));
        return new ImmutableDeploymentRecordValue(newValue, this.processesMetadata);
    }

    public final ImmutableDeploymentRecordValue withProcessesMetadata(ProcessMetadataValue ... elements) {
        List<ProcessMetadataValue> newValue = ImmutableDeploymentRecordValue.createUnmodifiableList(false, ImmutableDeploymentRecordValue.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableDeploymentRecordValue(this.resources, newValue);
    }

    public final ImmutableDeploymentRecordValue withProcessesMetadata(Iterable<? extends ProcessMetadataValue> elements) {
        if (this.processesMetadata == elements) {
            return this;
        }
        List<ProcessMetadataValue> newValue = ImmutableDeploymentRecordValue.createUnmodifiableList(false, ImmutableDeploymentRecordValue.createSafeList(elements, false, false));
        return new ImmutableDeploymentRecordValue(this.resources, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeploymentRecordValue && this.equalTo(0, (ImmutableDeploymentRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeploymentRecordValue another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.resources.equals(another.resources) && this.processesMetadata.equals(another.processesMetadata);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.resources.hashCode();
        h += (h << 5) + this.processesMetadata.hashCode();
        return h;
    }

    public String toString() {
        return "DeploymentRecordValue{resources=" + this.resources + ", processesMetadata=" + this.processesMetadata + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDeploymentRecordValue fromJson(Json json) {
        Builder builder = ImmutableDeploymentRecordValue.builder();
        if (json.resourcesIsSet) {
            builder.addAllResources(json.resources);
        }
        if (json.processesMetadataIsSet) {
            builder.addAllProcessesMetadata(json.processesMetadata);
        }
        return builder.build();
    }

    public static ImmutableDeploymentRecordValue copyOf(AbstractDeploymentRecordValue instance) {
        if (instance instanceof ImmutableDeploymentRecordValue) {
            return (ImmutableDeploymentRecordValue)instance;
        }
        return ImmutableDeploymentRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AbstractDeploymentRecordValue", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_RESOURCES = 1L;
        private static final long OPT_BIT_PROCESSES_METADATA = 2L;
        private long optBits;
        private List<DeploymentResource> resources = new ArrayList<DeploymentResource>();
        private List<ProcessMetadataValue> processesMetadata = new ArrayList<ProcessMetadataValue>();

        private Builder() {
        }

        public final Builder from(AbstractDeploymentRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DeploymentRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractDeploymentRecordValue instance;
            long bits = 0L;
            if (object instanceof AbstractDeploymentRecordValue) {
                instance = (AbstractDeploymentRecordValue)object;
                if ((bits & 1L) == 0L) {
                    this.addAllProcessesMetadata(instance.getProcessesMetadata());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllResources(instance.getResources());
                    bits |= 2L;
                }
            }
            if (object instanceof DeploymentRecordValue) {
                instance = (DeploymentRecordValue)object;
                if ((bits & 1L) == 0L) {
                    this.addAllProcessesMetadata(instance.getProcessesMetadata());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllResources(instance.getResources());
                    bits |= 2L;
                }
            }
        }

        public final Builder addResources(DeploymentResource element) {
            this.resources.add(element);
            this.optBits |= 1L;
            return this;
        }

        public final Builder addResources(DeploymentResource ... elements) {
            for (DeploymentResource element : elements) {
                this.resources.add(element);
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder resources(Iterable<? extends DeploymentResource> elements) {
            this.resources.clear();
            return this.addAllResources(elements);
        }

        public final Builder addAllResources(Iterable<? extends DeploymentResource> elements) {
            for (DeploymentResource deploymentResource : elements) {
                this.resources.add(deploymentResource);
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder addProcessesMetadata(ProcessMetadataValue element) {
            this.processesMetadata.add(element);
            this.optBits |= 2L;
            return this;
        }

        public final Builder addProcessesMetadata(ProcessMetadataValue ... elements) {
            for (ProcessMetadataValue element : elements) {
                this.processesMetadata.add(element);
            }
            this.optBits |= 2L;
            return this;
        }

        public final Builder processesMetadata(Iterable<? extends ProcessMetadataValue> elements) {
            this.processesMetadata.clear();
            return this.addAllProcessesMetadata(elements);
        }

        public final Builder addAllProcessesMetadata(Iterable<? extends ProcessMetadataValue> elements) {
            for (ProcessMetadataValue processMetadataValue : elements) {
                this.processesMetadata.add(processMetadataValue);
            }
            this.optBits |= 2L;
            return this;
        }

        public Builder clear() {
            this.optBits = 0L;
            this.resources.clear();
            this.processesMetadata.clear();
            return this;
        }

        public ImmutableDeploymentRecordValue build() {
            return new ImmutableDeploymentRecordValue(this);
        }

        private boolean resourcesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean processesMetadataIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractDeploymentRecordValue", generator="Immutables")
    static final class Json
    extends AbstractDeploymentRecordValue {
        List<DeploymentResource> resources = Collections.emptyList();
        boolean resourcesIsSet;
        List<ProcessMetadataValue> processesMetadata = Collections.emptyList();
        boolean processesMetadataIsSet;

        Json() {
        }

        @JsonProperty(value="resources")
        @JsonDeserialize(contentAs=ImmutableDeploymentResource.class)
        public void setResources(List<DeploymentResource> resources) {
            this.resources = resources;
            this.resourcesIsSet = true;
        }

        @JsonProperty(value="processesMetadata")
        @JsonDeserialize(contentAs=ImmutableProcessMetadata.class)
        public void setProcessesMetadata(List<ProcessMetadataValue> processesMetadata) {
            this.processesMetadata = processesMetadata;
            this.processesMetadataIsSet = true;
        }

        @Override
        public List<DeploymentResource> getResources() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ProcessMetadataValue> getProcessesMetadata() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="AbstractDeploymentRecordValue", generator="Immutables")
    private final class InitShim {
        private byte resourcesBuildStage = 0;
        private List<DeploymentResource> resources;
        private byte processesMetadataBuildStage = 0;
        private List<ProcessMetadataValue> processesMetadata;

        private InitShim() {
        }

        List<DeploymentResource> getResources() {
            if (this.resourcesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.resourcesBuildStage == 0) {
                this.resourcesBuildStage = (byte)-1;
                this.resources = ImmutableDeploymentRecordValue.createUnmodifiableList(false, ImmutableDeploymentRecordValue.createSafeList(ImmutableDeploymentRecordValue.super.getResources(), false, false));
                this.resourcesBuildStage = 1;
            }
            return this.resources;
        }

        void resources(List<DeploymentResource> resources) {
            this.resources = resources;
            this.resourcesBuildStage = 1;
        }

        List<ProcessMetadataValue> getProcessesMetadata() {
            if (this.processesMetadataBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.processesMetadataBuildStage == 0) {
                this.processesMetadataBuildStage = (byte)-1;
                this.processesMetadata = ImmutableDeploymentRecordValue.createUnmodifiableList(false, ImmutableDeploymentRecordValue.createSafeList(ImmutableDeploymentRecordValue.super.getProcessesMetadata(), false, false));
                this.processesMetadataBuildStage = 1;
            }
            return this.processesMetadata;
        }

        void processesMetadata(List<ProcessMetadataValue> processesMetadata) {
            this.processesMetadata = processesMetadata;
            this.processesMetadataBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.resourcesBuildStage == -1) {
                attributes.add("resources");
            }
            if (this.processesMetadataBuildStage == -1) {
                attributes.add("processesMetadata");
            }
            return "Cannot build DeploymentRecordValue, attribute initializers form cycle " + attributes;
        }
    }
}

