/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.immutables.record.value;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.protocol.record.value.ErrorRecordValue;
import io.zeebe.protocol.immutables.record.value.AbstractErrorRecordValue;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractErrorRecordValue", generator="Immutables")
public final class ImmutableErrorRecordValue
extends AbstractErrorRecordValue {
    private final String exceptionMessage;
    private final String stacktrace;
    private final long errorEventPosition;
    private final long processInstanceKey;
    private final transient int hashCode;

    private ImmutableErrorRecordValue(String exceptionMessage, String stacktrace, long errorEventPosition, long processInstanceKey) {
        this.exceptionMessage = exceptionMessage;
        this.stacktrace = stacktrace;
        this.errorEventPosition = errorEventPosition;
        this.processInstanceKey = processInstanceKey;
        this.hashCode = this.computeHashCode();
    }

    @JsonProperty(value="exceptionMessage")
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @JsonProperty(value="stacktrace")
    public String getStacktrace() {
        return this.stacktrace;
    }

    @JsonProperty(value="errorEventPosition")
    public long getErrorEventPosition() {
        return this.errorEventPosition;
    }

    @JsonProperty(value="processInstanceKey")
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public final ImmutableErrorRecordValue withExceptionMessage(String value) {
        if (Objects.equals(this.exceptionMessage, value)) {
            return this;
        }
        return new ImmutableErrorRecordValue(value, this.stacktrace, this.errorEventPosition, this.processInstanceKey);
    }

    public final ImmutableErrorRecordValue withStacktrace(String value) {
        if (Objects.equals(this.stacktrace, value)) {
            return this;
        }
        return new ImmutableErrorRecordValue(this.exceptionMessage, value, this.errorEventPosition, this.processInstanceKey);
    }

    public final ImmutableErrorRecordValue withErrorEventPosition(long value) {
        if (this.errorEventPosition == value) {
            return this;
        }
        return new ImmutableErrorRecordValue(this.exceptionMessage, this.stacktrace, value, this.processInstanceKey);
    }

    public final ImmutableErrorRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableErrorRecordValue(this.exceptionMessage, this.stacktrace, this.errorEventPosition, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableErrorRecordValue && this.equalTo(0, (ImmutableErrorRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableErrorRecordValue another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.exceptionMessage, another.exceptionMessage) && Objects.equals(this.stacktrace, another.stacktrace) && this.errorEventPosition == another.errorEventPosition && this.processInstanceKey == another.processInstanceKey;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.exceptionMessage);
        h += (h << 5) + Objects.hashCode(this.stacktrace);
        h += (h << 5) + Long.hashCode(this.errorEventPosition);
        h += (h << 5) + Long.hashCode(this.processInstanceKey);
        return h;
    }

    public String toString() {
        return "ErrorRecordValue{exceptionMessage=" + this.exceptionMessage + ", stacktrace=" + this.stacktrace + ", errorEventPosition=" + this.errorEventPosition + ", processInstanceKey=" + this.processInstanceKey + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableErrorRecordValue fromJson(Json json) {
        Builder builder = ImmutableErrorRecordValue.builder();
        if (json.exceptionMessage != null) {
            builder.exceptionMessage(json.exceptionMessage);
        }
        if (json.stacktrace != null) {
            builder.stacktrace(json.stacktrace);
        }
        if (json.errorEventPositionIsSet) {
            builder.errorEventPosition(json.errorEventPosition);
        }
        if (json.processInstanceKeyIsSet) {
            builder.processInstanceKey(json.processInstanceKey);
        }
        return builder.build();
    }

    public static ImmutableErrorRecordValue copyOf(AbstractErrorRecordValue instance) {
        if (instance instanceof ImmutableErrorRecordValue) {
            return (ImmutableErrorRecordValue)instance;
        }
        return ImmutableErrorRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AbstractErrorRecordValue", generator="Immutables")
    public static final class Builder {
        private String exceptionMessage;
        private String stacktrace;
        private long errorEventPosition;
        private long processInstanceKey;

        private Builder() {
        }

        public final Builder from(ErrorRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractErrorRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof ErrorRecordValue) {
                String exceptionMessageValue;
                ErrorRecordValue instance = (ErrorRecordValue)object;
                this.errorEventPosition(instance.getErrorEventPosition());
                this.processInstanceKey(instance.getProcessInstanceKey());
                String stacktraceValue = instance.getStacktrace();
                if (stacktraceValue != null) {
                    this.stacktrace(stacktraceValue);
                }
                if ((exceptionMessageValue = instance.getExceptionMessage()) != null) {
                    this.exceptionMessage(exceptionMessageValue);
                }
            }
        }

        public final Builder exceptionMessage(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
            return this;
        }

        public final Builder stacktrace(String stacktrace) {
            this.stacktrace = stacktrace;
            return this;
        }

        public final Builder errorEventPosition(long errorEventPosition) {
            this.errorEventPosition = errorEventPosition;
            return this;
        }

        public final Builder processInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public Builder clear() {
            this.exceptionMessage = null;
            this.stacktrace = null;
            this.errorEventPosition = 0L;
            this.processInstanceKey = 0L;
            return this;
        }

        public ImmutableErrorRecordValue build() {
            return new ImmutableErrorRecordValue(this.exceptionMessage, this.stacktrace, this.errorEventPosition, this.processInstanceKey);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractErrorRecordValue", generator="Immutables")
    static final class Json
    extends AbstractErrorRecordValue {
        String exceptionMessage;
        String stacktrace;
        long errorEventPosition;
        boolean errorEventPositionIsSet;
        long processInstanceKey;
        boolean processInstanceKeyIsSet;

        Json() {
        }

        @JsonProperty(value="exceptionMessage")
        public void setExceptionMessage(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
        }

        @JsonProperty(value="stacktrace")
        public void setStacktrace(String stacktrace) {
            this.stacktrace = stacktrace;
        }

        @JsonProperty(value="errorEventPosition")
        public void setErrorEventPosition(long errorEventPosition) {
            this.errorEventPosition = errorEventPosition;
            this.errorEventPositionIsSet = true;
        }

        @JsonProperty(value="processInstanceKey")
        public void setProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            this.processInstanceKeyIsSet = true;
        }

        public String getExceptionMessage() {
            throw new UnsupportedOperationException();
        }

        public String getStacktrace() {
            throw new UnsupportedOperationException();
        }

        public long getErrorEventPosition() {
            throw new UnsupportedOperationException();
        }

        public long getProcessInstanceKey() {
            throw new UnsupportedOperationException();
        }
    }
}

