/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.immutables.record.value;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.zeebe.protocol.immutables.record.value.AbstractIncidentRecordValue;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractIncidentRecordValue", generator="Immutables")
public final class ImmutableIncidentRecordValue
extends AbstractIncidentRecordValue {
    private final String errorMessage;
    private final String bpmnProcessId;
    private final long processDefinitionKey;
    private final long processInstanceKey;
    private final String elementId;
    private final long elementInstanceKey;
    private final long jobKey;
    private final long variableScopeKey;
    private final ErrorType errorType;
    private final transient int hashCode;

    private ImmutableIncidentRecordValue(Builder builder) {
        this.errorMessage = builder.errorMessage;
        this.bpmnProcessId = builder.bpmnProcessId;
        this.processDefinitionKey = builder.processDefinitionKey;
        this.processInstanceKey = builder.processInstanceKey;
        this.elementId = builder.elementId;
        this.elementInstanceKey = builder.elementInstanceKey;
        this.jobKey = builder.jobKey;
        this.variableScopeKey = builder.variableScopeKey;
        this.errorType = builder.errorType != null ? builder.errorType : Objects.requireNonNull(super.getErrorType(), "errorType");
        this.hashCode = this.computeHashCode();
    }

    private ImmutableIncidentRecordValue(String errorMessage, String bpmnProcessId, long processDefinitionKey, long processInstanceKey, String elementId, long elementInstanceKey, long jobKey, long variableScopeKey, ErrorType errorType) {
        this.errorMessage = errorMessage;
        this.bpmnProcessId = bpmnProcessId;
        this.processDefinitionKey = processDefinitionKey;
        this.processInstanceKey = processInstanceKey;
        this.elementId = elementId;
        this.elementInstanceKey = elementInstanceKey;
        this.jobKey = jobKey;
        this.variableScopeKey = variableScopeKey;
        this.errorType = errorType;
        this.hashCode = this.computeHashCode();
    }

    @JsonProperty(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @JsonProperty(value="bpmnProcessId")
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @JsonProperty(value="processDefinitionKey")
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @JsonProperty(value="processInstanceKey")
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @JsonProperty(value="elementId")
    public String getElementId() {
        return this.elementId;
    }

    @JsonProperty(value="elementInstanceKey")
    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    @JsonProperty(value="jobKey")
    public long getJobKey() {
        return this.jobKey;
    }

    @JsonProperty(value="variableScopeKey")
    public long getVariableScopeKey() {
        return this.variableScopeKey;
    }

    @Override
    @JsonProperty(value="errorType")
    public ErrorType getErrorType() {
        return this.errorType;
    }

    public final ImmutableIncidentRecordValue withErrorMessage(String value) {
        if (Objects.equals(this.errorMessage, value)) {
            return this;
        }
        return new ImmutableIncidentRecordValue(value, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey, this.errorType);
    }

    public final ImmutableIncidentRecordValue withBpmnProcessId(String value) {
        if (Objects.equals(this.bpmnProcessId, value)) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.errorMessage, value, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey, this.errorType);
    }

    public final ImmutableIncidentRecordValue withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.errorMessage, this.bpmnProcessId, value, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey, this.errorType);
    }

    public final ImmutableIncidentRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, value, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey, this.errorType);
    }

    public final ImmutableIncidentRecordValue withElementId(String value) {
        if (Objects.equals(this.elementId, value)) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, value, this.elementInstanceKey, this.jobKey, this.variableScopeKey, this.errorType);
    }

    public final ImmutableIncidentRecordValue withElementInstanceKey(long value) {
        if (this.elementInstanceKey == value) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, value, this.jobKey, this.variableScopeKey, this.errorType);
    }

    public final ImmutableIncidentRecordValue withJobKey(long value) {
        if (this.jobKey == value) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, value, this.variableScopeKey, this.errorType);
    }

    public final ImmutableIncidentRecordValue withVariableScopeKey(long value) {
        if (this.variableScopeKey == value) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, value, this.errorType);
    }

    public final ImmutableIncidentRecordValue withErrorType(ErrorType value) {
        ErrorType newValue = Objects.requireNonNull(value, "errorType");
        if (this.errorType == newValue) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIncidentRecordValue && this.equalTo(0, (ImmutableIncidentRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableIncidentRecordValue another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.errorMessage, another.errorMessage) && Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.processDefinitionKey == another.processDefinitionKey && this.processInstanceKey == another.processInstanceKey && Objects.equals(this.elementId, another.elementId) && this.elementInstanceKey == another.elementInstanceKey && this.jobKey == another.jobKey && this.variableScopeKey == another.variableScopeKey && this.errorType.equals((Object)another.errorType);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.errorMessage);
        h += (h << 5) + Objects.hashCode(this.bpmnProcessId);
        h += (h << 5) + Long.hashCode(this.processDefinitionKey);
        h += (h << 5) + Long.hashCode(this.processInstanceKey);
        h += (h << 5) + Objects.hashCode(this.elementId);
        h += (h << 5) + Long.hashCode(this.elementInstanceKey);
        h += (h << 5) + Long.hashCode(this.jobKey);
        h += (h << 5) + Long.hashCode(this.variableScopeKey);
        h += (h << 5) + this.errorType.hashCode();
        return h;
    }

    public String toString() {
        return "IncidentRecordValue{errorMessage=" + this.errorMessage + ", bpmnProcessId=" + this.bpmnProcessId + ", processDefinitionKey=" + this.processDefinitionKey + ", processInstanceKey=" + this.processInstanceKey + ", elementId=" + this.elementId + ", elementInstanceKey=" + this.elementInstanceKey + ", jobKey=" + this.jobKey + ", variableScopeKey=" + this.variableScopeKey + ", errorType=" + this.errorType + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIncidentRecordValue fromJson(Json json) {
        Builder builder = ImmutableIncidentRecordValue.builder();
        if (json.errorMessage != null) {
            builder.errorMessage(json.errorMessage);
        }
        if (json.bpmnProcessId != null) {
            builder.bpmnProcessId(json.bpmnProcessId);
        }
        if (json.processDefinitionKeyIsSet) {
            builder.processDefinitionKey(json.processDefinitionKey);
        }
        if (json.processInstanceKeyIsSet) {
            builder.processInstanceKey(json.processInstanceKey);
        }
        if (json.elementId != null) {
            builder.elementId(json.elementId);
        }
        if (json.elementInstanceKeyIsSet) {
            builder.elementInstanceKey(json.elementInstanceKey);
        }
        if (json.jobKeyIsSet) {
            builder.jobKey(json.jobKey);
        }
        if (json.variableScopeKeyIsSet) {
            builder.variableScopeKey(json.variableScopeKey);
        }
        if (json.errorType != null) {
            builder.errorType(json.errorType);
        }
        return builder.build();
    }

    public static ImmutableIncidentRecordValue copyOf(AbstractIncidentRecordValue instance) {
        if (instance instanceof ImmutableIncidentRecordValue) {
            return (ImmutableIncidentRecordValue)instance;
        }
        return ImmutableIncidentRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AbstractIncidentRecordValue", generator="Immutables")
    public static final class Builder {
        private String errorMessage;
        private String bpmnProcessId;
        private long processDefinitionKey;
        private long processInstanceKey;
        private String elementId;
        private long elementInstanceKey;
        private long jobKey;
        private long variableScopeKey;
        private ErrorType errorType;

        private Builder() {
        }

        public final Builder from(ProcessInstanceRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractIncidentRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IncidentRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof ProcessInstanceRelated) {
                instance = (ProcessInstanceRelated)object;
                if ((bits & 1L) == 0L) {
                    this.processInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
            }
            if (object instanceof AbstractIncidentRecordValue) {
                instance = (AbstractIncidentRecordValue)object;
                if ((bits & 2L) == 0L) {
                    this.errorType(((AbstractIncidentRecordValue)instance).getErrorType());
                    bits |= 2L;
                }
            }
            if (object instanceof IncidentRecordValue) {
                String errorMessageValue;
                instance = (IncidentRecordValue)object;
                String elementIdValue = instance.getElementId();
                if (elementIdValue != null) {
                    this.elementId(elementIdValue);
                }
                if ((bits & 1L) == 0L) {
                    this.processInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
                this.variableScopeKey(instance.getVariableScopeKey());
                this.elementInstanceKey(instance.getElementInstanceKey());
                if ((bits & 2L) == 0L) {
                    this.errorType(instance.getErrorType());
                    bits |= 2L;
                }
                if ((errorMessageValue = instance.getErrorMessage()) != null) {
                    this.errorMessage(errorMessageValue);
                }
                this.jobKey(instance.getJobKey());
                String bpmnProcessIdValue = instance.getBpmnProcessId();
                if (bpmnProcessIdValue != null) {
                    this.bpmnProcessId(bpmnProcessIdValue);
                }
                this.processDefinitionKey(instance.getProcessDefinitionKey());
            }
        }

        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Builder bpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
            return this;
        }

        public final Builder processDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public final Builder processInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public final Builder elementId(String elementId) {
            this.elementId = elementId;
            return this;
        }

        public final Builder elementInstanceKey(long elementInstanceKey) {
            this.elementInstanceKey = elementInstanceKey;
            return this;
        }

        public final Builder jobKey(long jobKey) {
            this.jobKey = jobKey;
            return this;
        }

        public final Builder variableScopeKey(long variableScopeKey) {
            this.variableScopeKey = variableScopeKey;
            return this;
        }

        public final Builder errorType(ErrorType errorType) {
            this.errorType = Objects.requireNonNull(errorType, "errorType");
            return this;
        }

        public Builder clear() {
            this.errorMessage = null;
            this.bpmnProcessId = null;
            this.processDefinitionKey = 0L;
            this.processInstanceKey = 0L;
            this.elementId = null;
            this.elementInstanceKey = 0L;
            this.jobKey = 0L;
            this.variableScopeKey = 0L;
            this.errorType = null;
            return this;
        }

        public ImmutableIncidentRecordValue build() {
            return new ImmutableIncidentRecordValue(this);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractIncidentRecordValue", generator="Immutables")
    static final class Json
    extends AbstractIncidentRecordValue {
        String errorMessage;
        String bpmnProcessId;
        long processDefinitionKey;
        boolean processDefinitionKeyIsSet;
        long processInstanceKey;
        boolean processInstanceKeyIsSet;
        String elementId;
        long elementInstanceKey;
        boolean elementInstanceKeyIsSet;
        long jobKey;
        boolean jobKeyIsSet;
        long variableScopeKey;
        boolean variableScopeKeyIsSet;
        ErrorType errorType;

        Json() {
        }

        @JsonProperty(value="errorMessage")
        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @JsonProperty(value="bpmnProcessId")
        public void setBpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
        }

        @JsonProperty(value="processDefinitionKey")
        public void setProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            this.processDefinitionKeyIsSet = true;
        }

        @JsonProperty(value="processInstanceKey")
        public void setProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            this.processInstanceKeyIsSet = true;
        }

        @JsonProperty(value="elementId")
        public void setElementId(String elementId) {
            this.elementId = elementId;
        }

        @JsonProperty(value="elementInstanceKey")
        public void setElementInstanceKey(long elementInstanceKey) {
            this.elementInstanceKey = elementInstanceKey;
            this.elementInstanceKeyIsSet = true;
        }

        @JsonProperty(value="jobKey")
        public void setJobKey(long jobKey) {
            this.jobKey = jobKey;
            this.jobKeyIsSet = true;
        }

        @JsonProperty(value="variableScopeKey")
        public void setVariableScopeKey(long variableScopeKey) {
            this.variableScopeKey = variableScopeKey;
            this.variableScopeKeyIsSet = true;
        }

        @JsonProperty(value="errorType")
        public void setErrorType(ErrorType errorType) {
            this.errorType = errorType;
        }

        public String getErrorMessage() {
            throw new UnsupportedOperationException();
        }

        public String getBpmnProcessId() {
            throw new UnsupportedOperationException();
        }

        public long getProcessDefinitionKey() {
            throw new UnsupportedOperationException();
        }

        public long getProcessInstanceKey() {
            throw new UnsupportedOperationException();
        }

        public String getElementId() {
            throw new UnsupportedOperationException();
        }

        public long getElementInstanceKey() {
            throw new UnsupportedOperationException();
        }

        public long getJobKey() {
            throw new UnsupportedOperationException();
        }

        public long getVariableScopeKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ErrorType getErrorType() {
            throw new UnsupportedOperationException();
        }
    }
}

