/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.immutables.record.value;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.zeebe.protocol.immutables.record.value.AbstractJobBatchRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableJobRecordValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractJobBatchRecordValue", generator="Immutables")
public final class ImmutableJobBatchRecordValue
extends AbstractJobBatchRecordValue {
    private final String type;
    private final String worker;
    private final long timeout;
    private final int maxJobsToActivate;
    private final boolean truncated;
    private final List<Long> jobKeys;
    private final List<JobRecordValue> jobs;
    private final transient int hashCode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableJobBatchRecordValue(Builder builder) {
        this.type = builder.type;
        this.worker = builder.worker;
        this.timeout = builder.timeout;
        this.maxJobsToActivate = builder.maxJobsToActivate;
        this.truncated = builder.truncated;
        if (builder.jobKeysIsSet()) {
            this.initShim.jobKeys(ImmutableJobBatchRecordValue.createUnmodifiableList(true, builder.jobKeys));
        }
        if (builder.jobsIsSet()) {
            this.initShim.jobs(ImmutableJobBatchRecordValue.createUnmodifiableList(true, builder.jobs));
        }
        this.jobKeys = this.initShim.getJobKeys();
        this.jobs = this.initShim.getJobs();
        this.hashCode = this.computeHashCode();
        this.initShim = null;
    }

    private ImmutableJobBatchRecordValue(String type, String worker, long timeout, int maxJobsToActivate, boolean truncated, List<Long> jobKeys, List<JobRecordValue> jobs) {
        this.type = type;
        this.worker = worker;
        this.timeout = timeout;
        this.maxJobsToActivate = maxJobsToActivate;
        this.truncated = truncated;
        this.jobKeys = jobKeys;
        this.jobs = jobs;
        this.hashCode = this.computeHashCode();
        this.initShim = null;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="worker")
    public String getWorker() {
        return this.worker;
    }

    @JsonProperty(value="timeout")
    public long getTimeout() {
        return this.timeout;
    }

    @JsonProperty(value="maxJobsToActivate")
    public int getMaxJobsToActivate() {
        return this.maxJobsToActivate;
    }

    @JsonProperty(value="truncated")
    public boolean isTruncated() {
        return this.truncated;
    }

    @Override
    @JsonProperty(value="jobKeys")
    public List<Long> getJobKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getJobKeys() : this.jobKeys;
    }

    @Override
    @JsonProperty(value="jobs")
    @JsonDeserialize(contentAs=ImmutableJobRecordValue.class)
    public List<JobRecordValue> getJobs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getJobs() : this.jobs;
    }

    public final ImmutableJobBatchRecordValue withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return new ImmutableJobBatchRecordValue(value, this.worker, this.timeout, this.maxJobsToActivate, this.truncated, this.jobKeys, this.jobs);
    }

    public final ImmutableJobBatchRecordValue withWorker(String value) {
        if (Objects.equals(this.worker, value)) {
            return this;
        }
        return new ImmutableJobBatchRecordValue(this.type, value, this.timeout, this.maxJobsToActivate, this.truncated, this.jobKeys, this.jobs);
    }

    public final ImmutableJobBatchRecordValue withTimeout(long value) {
        if (this.timeout == value) {
            return this;
        }
        return new ImmutableJobBatchRecordValue(this.type, this.worker, value, this.maxJobsToActivate, this.truncated, this.jobKeys, this.jobs);
    }

    public final ImmutableJobBatchRecordValue withMaxJobsToActivate(int value) {
        if (this.maxJobsToActivate == value) {
            return this;
        }
        return new ImmutableJobBatchRecordValue(this.type, this.worker, this.timeout, value, this.truncated, this.jobKeys, this.jobs);
    }

    public final ImmutableJobBatchRecordValue withTruncated(boolean value) {
        if (this.truncated == value) {
            return this;
        }
        return new ImmutableJobBatchRecordValue(this.type, this.worker, this.timeout, this.maxJobsToActivate, value, this.jobKeys, this.jobs);
    }

    public final ImmutableJobBatchRecordValue withJobKeys(Long ... elements) {
        List<Long> newValue = ImmutableJobBatchRecordValue.createUnmodifiableList(false, ImmutableJobBatchRecordValue.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableJobBatchRecordValue(this.type, this.worker, this.timeout, this.maxJobsToActivate, this.truncated, newValue, this.jobs);
    }

    public final ImmutableJobBatchRecordValue withJobKeys(Iterable<? extends Long> elements) {
        if (this.jobKeys == elements) {
            return this;
        }
        List<Long> newValue = ImmutableJobBatchRecordValue.createUnmodifiableList(false, ImmutableJobBatchRecordValue.createSafeList(elements, false, false));
        return new ImmutableJobBatchRecordValue(this.type, this.worker, this.timeout, this.maxJobsToActivate, this.truncated, newValue, this.jobs);
    }

    public final ImmutableJobBatchRecordValue withJobs(JobRecordValue ... elements) {
        List<JobRecordValue> newValue = ImmutableJobBatchRecordValue.createUnmodifiableList(false, ImmutableJobBatchRecordValue.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableJobBatchRecordValue(this.type, this.worker, this.timeout, this.maxJobsToActivate, this.truncated, this.jobKeys, newValue);
    }

    public final ImmutableJobBatchRecordValue withJobs(Iterable<? extends JobRecordValue> elements) {
        if (this.jobs == elements) {
            return this;
        }
        List<JobRecordValue> newValue = ImmutableJobBatchRecordValue.createUnmodifiableList(false, ImmutableJobBatchRecordValue.createSafeList(elements, false, false));
        return new ImmutableJobBatchRecordValue(this.type, this.worker, this.timeout, this.maxJobsToActivate, this.truncated, this.jobKeys, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJobBatchRecordValue && this.equalTo(0, (ImmutableJobBatchRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableJobBatchRecordValue another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.type, another.type) && Objects.equals(this.worker, another.worker) && this.timeout == another.timeout && this.maxJobsToActivate == another.maxJobsToActivate && this.truncated == another.truncated && this.jobKeys.equals(another.jobKeys) && this.jobs.equals(another.jobs);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.worker);
        h += (h << 5) + Long.hashCode(this.timeout);
        h += (h << 5) + this.maxJobsToActivate;
        h += (h << 5) + Boolean.hashCode(this.truncated);
        h += (h << 5) + this.jobKeys.hashCode();
        h += (h << 5) + this.jobs.hashCode();
        return h;
    }

    public String toString() {
        return "JobBatchRecordValue{type=" + this.type + ", worker=" + this.worker + ", timeout=" + this.timeout + ", maxJobsToActivate=" + this.maxJobsToActivate + ", truncated=" + this.truncated + ", jobKeys=" + this.jobKeys + ", jobs=" + this.jobs + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJobBatchRecordValue fromJson(Json json) {
        Builder builder = ImmutableJobBatchRecordValue.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.worker != null) {
            builder.worker(json.worker);
        }
        if (json.timeoutIsSet) {
            builder.timeout(json.timeout);
        }
        if (json.maxJobsToActivateIsSet) {
            builder.maxJobsToActivate(json.maxJobsToActivate);
        }
        if (json.truncatedIsSet) {
            builder.truncated(json.truncated);
        }
        if (json.jobKeysIsSet) {
            builder.addAllJobKeys(json.jobKeys);
        }
        if (json.jobsIsSet) {
            builder.addAllJobs(json.jobs);
        }
        return builder.build();
    }

    public static ImmutableJobBatchRecordValue copyOf(AbstractJobBatchRecordValue instance) {
        if (instance instanceof ImmutableJobBatchRecordValue) {
            return (ImmutableJobBatchRecordValue)instance;
        }
        return ImmutableJobBatchRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AbstractJobBatchRecordValue", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_JOB_KEYS = 1L;
        private static final long OPT_BIT_JOBS = 2L;
        private long optBits;
        private String type;
        private String worker;
        private long timeout;
        private int maxJobsToActivate;
        private boolean truncated;
        private List<Long> jobKeys = new ArrayList<Long>();
        private List<JobRecordValue> jobs = new ArrayList<JobRecordValue>();

        private Builder() {
        }

        public final Builder from(AbstractJobBatchRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobBatchRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractJobBatchRecordValue instance;
            long bits = 0L;
            if (object instanceof AbstractJobBatchRecordValue) {
                instance = (AbstractJobBatchRecordValue)object;
                if ((bits & 1L) == 0L) {
                    this.addAllJobKeys(instance.getJobKeys());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllJobs(instance.getJobs());
                    bits |= 2L;
                }
            }
            if (object instanceof JobBatchRecordValue) {
                String workerValue;
                instance = (JobBatchRecordValue)object;
                if ((bits & 1L) == 0L) {
                    this.addAllJobKeys(instance.getJobKeys());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllJobs(instance.getJobs());
                    bits |= 2L;
                }
                this.truncated(instance.isTruncated());
                String typeValue = instance.getType();
                if (typeValue != null) {
                    this.type(typeValue);
                }
                if ((workerValue = instance.getWorker()) != null) {
                    this.worker(workerValue);
                }
                this.timeout(instance.getTimeout());
                this.maxJobsToActivate(instance.getMaxJobsToActivate());
            }
        }

        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Builder worker(String worker) {
            this.worker = worker;
            return this;
        }

        public final Builder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public final Builder maxJobsToActivate(int maxJobsToActivate) {
            this.maxJobsToActivate = maxJobsToActivate;
            return this;
        }

        public final Builder truncated(boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public final Builder addJobKeys(Long element) {
            this.jobKeys.add(element);
            this.optBits |= 1L;
            return this;
        }

        public final Builder addJobKeys(Long ... elements) {
            for (Long element : elements) {
                this.jobKeys.add(element);
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder jobKeys(Iterable<? extends Long> elements) {
            this.jobKeys.clear();
            return this.addAllJobKeys(elements);
        }

        public final Builder addAllJobKeys(Iterable<? extends Long> elements) {
            for (Long l : elements) {
                this.jobKeys.add(l);
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder addJobs(JobRecordValue element) {
            this.jobs.add(element);
            this.optBits |= 2L;
            return this;
        }

        public final Builder addJobs(JobRecordValue ... elements) {
            for (JobRecordValue element : elements) {
                this.jobs.add(element);
            }
            this.optBits |= 2L;
            return this;
        }

        public final Builder jobs(Iterable<? extends JobRecordValue> elements) {
            this.jobs.clear();
            return this.addAllJobs(elements);
        }

        public final Builder addAllJobs(Iterable<? extends JobRecordValue> elements) {
            for (JobRecordValue jobRecordValue : elements) {
                this.jobs.add(jobRecordValue);
            }
            this.optBits |= 2L;
            return this;
        }

        public Builder clear() {
            this.optBits = 0L;
            this.type = null;
            this.worker = null;
            this.timeout = 0L;
            this.maxJobsToActivate = 0;
            this.truncated = false;
            this.jobKeys.clear();
            this.jobs.clear();
            return this;
        }

        public ImmutableJobBatchRecordValue build() {
            return new ImmutableJobBatchRecordValue(this);
        }

        private boolean jobKeysIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean jobsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractJobBatchRecordValue", generator="Immutables")
    static final class Json
    extends AbstractJobBatchRecordValue {
        String type;
        String worker;
        long timeout;
        boolean timeoutIsSet;
        int maxJobsToActivate;
        boolean maxJobsToActivateIsSet;
        boolean truncated;
        boolean truncatedIsSet;
        List<Long> jobKeys = Collections.emptyList();
        boolean jobKeysIsSet;
        List<JobRecordValue> jobs = Collections.emptyList();
        boolean jobsIsSet;

        Json() {
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="worker")
        public void setWorker(String worker) {
            this.worker = worker;
        }

        @JsonProperty(value="timeout")
        public void setTimeout(long timeout) {
            this.timeout = timeout;
            this.timeoutIsSet = true;
        }

        @JsonProperty(value="maxJobsToActivate")
        public void setMaxJobsToActivate(int maxJobsToActivate) {
            this.maxJobsToActivate = maxJobsToActivate;
            this.maxJobsToActivateIsSet = true;
        }

        @JsonProperty(value="truncated")
        public void setTruncated(boolean truncated) {
            this.truncated = truncated;
            this.truncatedIsSet = true;
        }

        @JsonProperty(value="jobKeys")
        public void setJobKeys(List<Long> jobKeys) {
            this.jobKeys = jobKeys;
            this.jobKeysIsSet = true;
        }

        @JsonProperty(value="jobs")
        @JsonDeserialize(contentAs=ImmutableJobRecordValue.class)
        public void setJobs(List<JobRecordValue> jobs) {
            this.jobs = jobs;
            this.jobsIsSet = true;
        }

        public String getType() {
            throw new UnsupportedOperationException();
        }

        public String getWorker() {
            throw new UnsupportedOperationException();
        }

        public long getTimeout() {
            throw new UnsupportedOperationException();
        }

        public int getMaxJobsToActivate() {
            throw new UnsupportedOperationException();
        }

        public boolean isTruncated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Long> getJobKeys() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<JobRecordValue> getJobs() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="AbstractJobBatchRecordValue", generator="Immutables")
    private final class InitShim {
        private byte jobKeysBuildStage = 0;
        private List<Long> jobKeys;
        private byte jobsBuildStage = 0;
        private List<JobRecordValue> jobs;

        private InitShim() {
        }

        List<Long> getJobKeys() {
            if (this.jobKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobKeysBuildStage == 0) {
                this.jobKeysBuildStage = (byte)-1;
                this.jobKeys = ImmutableJobBatchRecordValue.createUnmodifiableList(false, ImmutableJobBatchRecordValue.createSafeList(ImmutableJobBatchRecordValue.super.getJobKeys(), false, false));
                this.jobKeysBuildStage = 1;
            }
            return this.jobKeys;
        }

        void jobKeys(List<Long> jobKeys) {
            this.jobKeys = jobKeys;
            this.jobKeysBuildStage = 1;
        }

        List<JobRecordValue> getJobs() {
            if (this.jobsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobsBuildStage == 0) {
                this.jobsBuildStage = (byte)-1;
                this.jobs = ImmutableJobBatchRecordValue.createUnmodifiableList(false, ImmutableJobBatchRecordValue.createSafeList(ImmutableJobBatchRecordValue.super.getJobs(), false, false));
                this.jobsBuildStage = 1;
            }
            return this.jobs;
        }

        void jobs(List<JobRecordValue> jobs) {
            this.jobs = jobs;
            this.jobsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.jobKeysBuildStage == -1) {
                attributes.add("jobKeys");
            }
            if (this.jobsBuildStage == -1) {
                attributes.add("jobs");
            }
            return "Cannot build JobBatchRecordValue, attribute initializers form cycle " + attributes;
        }
    }
}

