/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.immutables.record.value;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.zeebe.protocol.immutables.record.value.AbstractJobRecordValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractJobRecordValue", generator="Immutables")
public final class ImmutableJobRecordValue
extends AbstractJobRecordValue {
    private final long processInstanceKey;
    private final String type;
    private final String worker;
    private final int retries;
    private final long deadline;
    private final String errorMessage;
    private final String elementId;
    private final long elementInstanceKey;
    private final String bpmnProcessId;
    private final int processDefinitionVersion;
    private final long processDefinitionKey;
    private final Map<String, String> customHeaders;
    private final String errorCode;
    private final Map<String, Object> variables;
    private final transient int hashCode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableJobRecordValue(Builder builder) {
        this.processInstanceKey = builder.processInstanceKey;
        this.type = builder.type;
        this.worker = builder.worker;
        this.retries = builder.retries;
        this.deadline = builder.deadline;
        this.errorMessage = builder.errorMessage;
        this.elementId = builder.elementId;
        this.elementInstanceKey = builder.elementInstanceKey;
        this.bpmnProcessId = builder.bpmnProcessId;
        this.processDefinitionVersion = builder.processDefinitionVersion;
        this.processDefinitionKey = builder.processDefinitionKey;
        if (builder.customHeadersIsSet()) {
            this.initShim.customHeaders(Map.copyOf(builder.customHeaders));
        }
        if (builder.errorCode != null) {
            this.initShim.errorCode(builder.errorCode);
        }
        if (builder.variablesIsSet()) {
            this.initShim.variables(Map.copyOf(builder.variables));
        }
        this.customHeaders = this.initShim.getCustomHeaders();
        this.errorCode = this.initShim.getErrorCode();
        this.variables = this.initShim.getVariables();
        this.hashCode = this.computeHashCode();
        this.initShim = null;
    }

    private ImmutableJobRecordValue(long processInstanceKey, String type, String worker, int retries, long deadline, String errorMessage, String elementId, long elementInstanceKey, String bpmnProcessId, int processDefinitionVersion, long processDefinitionKey, Map<String, String> customHeaders, String errorCode, Map<String, Object> variables) {
        this.processInstanceKey = processInstanceKey;
        this.type = type;
        this.worker = worker;
        this.retries = retries;
        this.deadline = deadline;
        this.errorMessage = errorMessage;
        this.elementId = elementId;
        this.elementInstanceKey = elementInstanceKey;
        this.bpmnProcessId = bpmnProcessId;
        this.processDefinitionVersion = processDefinitionVersion;
        this.processDefinitionKey = processDefinitionKey;
        this.customHeaders = customHeaders;
        this.errorCode = errorCode;
        this.variables = variables;
        this.hashCode = this.computeHashCode();
        this.initShim = null;
    }

    @JsonProperty(value="processInstanceKey")
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="worker")
    public String getWorker() {
        return this.worker;
    }

    @JsonProperty(value="retries")
    public int getRetries() {
        return this.retries;
    }

    @JsonProperty(value="deadline")
    public long getDeadline() {
        return this.deadline;
    }

    @JsonProperty(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @JsonProperty(value="elementId")
    public String getElementId() {
        return this.elementId;
    }

    @JsonProperty(value="elementInstanceKey")
    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    @JsonProperty(value="bpmnProcessId")
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @JsonProperty(value="processDefinitionVersion")
    public int getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    @JsonProperty(value="processDefinitionKey")
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    @JsonProperty(value="customHeaders")
    public Map<String, String> getCustomHeaders() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCustomHeaders() : this.customHeaders;
    }

    @Override
    @JsonProperty(value="errorCode")
    public String getErrorCode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getErrorCode() : this.errorCode;
    }

    @Override
    @JsonProperty(value="variables")
    public Map<String, Object> getVariables() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getVariables() : this.variables;
    }

    public final ImmutableJobRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableJobRecordValue(value, this.type, this.worker, this.retries, this.deadline, this.errorMessage, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey, this.customHeaders, this.errorCode, this.variables);
    }

    public final ImmutableJobRecordValue withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return new ImmutableJobRecordValue(this.processInstanceKey, value, this.worker, this.retries, this.deadline, this.errorMessage, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey, this.customHeaders, this.errorCode, this.variables);
    }

    public final ImmutableJobRecordValue withWorker(String value) {
        if (Objects.equals(this.worker, value)) {
            return this;
        }
        return new ImmutableJobRecordValue(this.processInstanceKey, this.type, value, this.retries, this.deadline, this.errorMessage, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey, this.customHeaders, this.errorCode, this.variables);
    }

    public final ImmutableJobRecordValue withRetries(int value) {
        if (this.retries == value) {
            return this;
        }
        return new ImmutableJobRecordValue(this.processInstanceKey, this.type, this.worker, value, this.deadline, this.errorMessage, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey, this.customHeaders, this.errorCode, this.variables);
    }

    public final ImmutableJobRecordValue withDeadline(long value) {
        if (this.deadline == value) {
            return this;
        }
        return new ImmutableJobRecordValue(this.processInstanceKey, this.type, this.worker, this.retries, value, this.errorMessage, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey, this.customHeaders, this.errorCode, this.variables);
    }

    public final ImmutableJobRecordValue withErrorMessage(String value) {
        if (Objects.equals(this.errorMessage, value)) {
            return this;
        }
        return new ImmutableJobRecordValue(this.processInstanceKey, this.type, this.worker, this.retries, this.deadline, value, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey, this.customHeaders, this.errorCode, this.variables);
    }

    public final ImmutableJobRecordValue withElementId(String value) {
        if (Objects.equals(this.elementId, value)) {
            return this;
        }
        return new ImmutableJobRecordValue(this.processInstanceKey, this.type, this.worker, this.retries, this.deadline, this.errorMessage, value, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey, this.customHeaders, this.errorCode, this.variables);
    }

    public final ImmutableJobRecordValue withElementInstanceKey(long value) {
        if (this.elementInstanceKey == value) {
            return this;
        }
        return new ImmutableJobRecordValue(this.processInstanceKey, this.type, this.worker, this.retries, this.deadline, this.errorMessage, this.elementId, value, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey, this.customHeaders, this.errorCode, this.variables);
    }

    public final ImmutableJobRecordValue withBpmnProcessId(String value) {
        if (Objects.equals(this.bpmnProcessId, value)) {
            return this;
        }
        return new ImmutableJobRecordValue(this.processInstanceKey, this.type, this.worker, this.retries, this.deadline, this.errorMessage, this.elementId, this.elementInstanceKey, value, this.processDefinitionVersion, this.processDefinitionKey, this.customHeaders, this.errorCode, this.variables);
    }

    public final ImmutableJobRecordValue withProcessDefinitionVersion(int value) {
        if (this.processDefinitionVersion == value) {
            return this;
        }
        return new ImmutableJobRecordValue(this.processInstanceKey, this.type, this.worker, this.retries, this.deadline, this.errorMessage, this.elementId, this.elementInstanceKey, this.bpmnProcessId, value, this.processDefinitionKey, this.customHeaders, this.errorCode, this.variables);
    }

    public final ImmutableJobRecordValue withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableJobRecordValue(this.processInstanceKey, this.type, this.worker, this.retries, this.deadline, this.errorMessage, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, value, this.customHeaders, this.errorCode, this.variables);
    }

    public final ImmutableJobRecordValue withCustomHeaders(Map<String, ? extends String> entries) {
        if (this.customHeaders == entries) {
            return this;
        }
        Map<String, String> newValue = Map.copyOf(entries);
        return new ImmutableJobRecordValue(this.processInstanceKey, this.type, this.worker, this.retries, this.deadline, this.errorMessage, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey, newValue, this.errorCode, this.variables);
    }

    public final ImmutableJobRecordValue withErrorCode(String value) {
        String newValue = Objects.requireNonNull(value, "errorCode");
        if (this.errorCode.equals(newValue)) {
            return this;
        }
        return new ImmutableJobRecordValue(this.processInstanceKey, this.type, this.worker, this.retries, this.deadline, this.errorMessage, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey, this.customHeaders, newValue, this.variables);
    }

    public final ImmutableJobRecordValue withVariables(Map<String, ? extends Object> entries) {
        if (this.variables == entries) {
            return this;
        }
        Map<String, Object> newValue = Map.copyOf(entries);
        return new ImmutableJobRecordValue(this.processInstanceKey, this.type, this.worker, this.retries, this.deadline, this.errorMessage, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey, this.customHeaders, this.errorCode, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJobRecordValue && this.equalTo(0, (ImmutableJobRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableJobRecordValue another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.processInstanceKey == another.processInstanceKey && Objects.equals(this.type, another.type) && Objects.equals(this.worker, another.worker) && this.retries == another.retries && this.deadline == another.deadline && Objects.equals(this.errorMessage, another.errorMessage) && Objects.equals(this.elementId, another.elementId) && this.elementInstanceKey == another.elementInstanceKey && Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.processDefinitionVersion == another.processDefinitionVersion && this.processDefinitionKey == another.processDefinitionKey && this.customHeaders.equals(another.customHeaders) && this.errorCode.equals(another.errorCode) && this.variables.equals(another.variables);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.processInstanceKey);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.worker);
        h += (h << 5) + this.retries;
        h += (h << 5) + Long.hashCode(this.deadline);
        h += (h << 5) + Objects.hashCode(this.errorMessage);
        h += (h << 5) + Objects.hashCode(this.elementId);
        h += (h << 5) + Long.hashCode(this.elementInstanceKey);
        h += (h << 5) + Objects.hashCode(this.bpmnProcessId);
        h += (h << 5) + this.processDefinitionVersion;
        h += (h << 5) + Long.hashCode(this.processDefinitionKey);
        h += (h << 5) + this.customHeaders.hashCode();
        h += (h << 5) + this.errorCode.hashCode();
        h += (h << 5) + this.variables.hashCode();
        return h;
    }

    public String toString() {
        return "JobRecordValue{processInstanceKey=" + this.processInstanceKey + ", type=" + this.type + ", worker=" + this.worker + ", retries=" + this.retries + ", deadline=" + this.deadline + ", errorMessage=" + this.errorMessage + ", elementId=" + this.elementId + ", elementInstanceKey=" + this.elementInstanceKey + ", bpmnProcessId=" + this.bpmnProcessId + ", processDefinitionVersion=" + this.processDefinitionVersion + ", processDefinitionKey=" + this.processDefinitionKey + ", customHeaders=" + this.customHeaders + ", errorCode=" + this.errorCode + ", variables=" + this.variables + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJobRecordValue fromJson(Json json) {
        Builder builder = ImmutableJobRecordValue.builder();
        if (json.processInstanceKeyIsSet) {
            builder.processInstanceKey(json.processInstanceKey);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.worker != null) {
            builder.worker(json.worker);
        }
        if (json.retriesIsSet) {
            builder.retries(json.retries);
        }
        if (json.deadlineIsSet) {
            builder.deadline(json.deadline);
        }
        if (json.errorMessage != null) {
            builder.errorMessage(json.errorMessage);
        }
        if (json.elementId != null) {
            builder.elementId(json.elementId);
        }
        if (json.elementInstanceKeyIsSet) {
            builder.elementInstanceKey(json.elementInstanceKey);
        }
        if (json.bpmnProcessId != null) {
            builder.bpmnProcessId(json.bpmnProcessId);
        }
        if (json.processDefinitionVersionIsSet) {
            builder.processDefinitionVersion(json.processDefinitionVersion);
        }
        if (json.processDefinitionKeyIsSet) {
            builder.processDefinitionKey(json.processDefinitionKey);
        }
        if (json.customHeadersIsSet) {
            builder.putAllCustomHeaders(json.customHeaders);
        }
        if (json.errorCode != null) {
            builder.errorCode(json.errorCode);
        }
        if (json.variablesIsSet) {
            builder.putAllVariables(json.variables);
        }
        return builder.build();
    }

    public static ImmutableJobRecordValue copyOf(AbstractJobRecordValue instance) {
        if (instance instanceof ImmutableJobRecordValue) {
            return (ImmutableJobRecordValue)instance;
        }
        return ImmutableJobRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AbstractJobRecordValue", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_CUSTOM_HEADERS = 1L;
        private static final long OPT_BIT_VARIABLES = 2L;
        private long optBits;
        private long processInstanceKey;
        private String type;
        private String worker;
        private int retries;
        private long deadline;
        private String errorMessage;
        private String elementId;
        private long elementInstanceKey;
        private String bpmnProcessId;
        private int processDefinitionVersion;
        private long processDefinitionKey;
        private Map<String, String> customHeaders = new LinkedHashMap<String, String>();
        private String errorCode;
        private Map<String, Object> variables = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        public final Builder from(ProcessInstanceRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractJobRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RecordValueWithVariables instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof ProcessInstanceRelated) {
                instance = (ProcessInstanceRelated)object;
                this.processInstanceKey(instance.getProcessInstanceKey());
            }
            if (object instanceof JobRecordValue) {
                String workerValue;
                String typeValue;
                String bpmnProcessIdValue;
                instance = (JobRecordValue)object;
                String elementIdValue = instance.getElementId();
                if (elementIdValue != null) {
                    this.elementId(elementIdValue);
                }
                this.retries(instance.getRetries());
                this.elementInstanceKey(instance.getElementInstanceKey());
                String errorMessageValue = instance.getErrorMessage();
                if (errorMessageValue != null) {
                    this.errorMessage(errorMessageValue);
                }
                if ((bits & 2L) == 0L) {
                    this.errorCode(instance.getErrorCode());
                    bits |= 2L;
                }
                if ((bpmnProcessIdValue = instance.getBpmnProcessId()) != null) {
                    this.bpmnProcessId(bpmnProcessIdValue);
                }
                if ((typeValue = instance.getType()) != null) {
                    this.type(typeValue);
                }
                if ((workerValue = instance.getWorker()) != null) {
                    this.worker(workerValue);
                }
                this.deadline(instance.getDeadline());
                this.processDefinitionVersion(instance.getProcessDefinitionVersion());
                if ((bits & 4L) == 0L) {
                    this.putAllCustomHeaders(instance.getCustomHeaders());
                    bits |= 4L;
                }
                this.processDefinitionKey(instance.getProcessDefinitionKey());
            }
            if (object instanceof AbstractJobRecordValue) {
                instance = (AbstractJobRecordValue)object;
                if ((bits & 2L) == 0L) {
                    this.errorCode(((AbstractJobRecordValue)instance).getErrorCode());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.putAllVariables(((AbstractJobRecordValue)instance).getVariables());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.putAllCustomHeaders(((AbstractJobRecordValue)instance).getCustomHeaders());
                    bits |= 4L;
                }
            }
            if (object instanceof RecordValueWithVariables) {
                instance = (RecordValueWithVariables)object;
                if ((bits & 1L) == 0L) {
                    this.putAllVariables(instance.getVariables());
                    bits |= 1L;
                }
            }
        }

        public final Builder processInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Builder worker(String worker) {
            this.worker = worker;
            return this;
        }

        public final Builder retries(int retries) {
            this.retries = retries;
            return this;
        }

        public final Builder deadline(long deadline) {
            this.deadline = deadline;
            return this;
        }

        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Builder elementId(String elementId) {
            this.elementId = elementId;
            return this;
        }

        public final Builder elementInstanceKey(long elementInstanceKey) {
            this.elementInstanceKey = elementInstanceKey;
            return this;
        }

        public final Builder bpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
            return this;
        }

        public final Builder processDefinitionVersion(int processDefinitionVersion) {
            this.processDefinitionVersion = processDefinitionVersion;
            return this;
        }

        public final Builder processDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public final Builder putCustomHeaders(String key, String value) {
            this.customHeaders.put(Objects.requireNonNull(key, "customHeaders key"), Objects.requireNonNull(value, "customHeaders value"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder putCustomHeaders(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.customHeaders.put(Objects.requireNonNull(k, "customHeaders key"), Objects.requireNonNull(v, "customHeaders value"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder customHeaders(Map<String, ? extends String> entries) {
            this.customHeaders.clear();
            this.optBits |= 1L;
            return this.putAllCustomHeaders(entries);
        }

        public final Builder putAllCustomHeaders(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.customHeaders.put(Objects.requireNonNull(k, "customHeaders key"), Objects.requireNonNull(v, "customHeaders value"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder errorCode(String errorCode) {
            this.errorCode = Objects.requireNonNull(errorCode, "errorCode");
            return this;
        }

        public final Builder putVariables(String key, Object value) {
            this.variables.put(Objects.requireNonNull(key, "variables key"), Objects.requireNonNull(value, "variables value"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder putVariables(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, "variables value"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder variables(Map<String, ? extends Object> entries) {
            this.variables.clear();
            this.optBits |= 2L;
            return this.putAllVariables(entries);
        }

        public final Builder putAllVariables(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, "variables value"));
            }
            this.optBits |= 2L;
            return this;
        }

        public Builder clear() {
            this.optBits = 0L;
            this.processInstanceKey = 0L;
            this.type = null;
            this.worker = null;
            this.retries = 0;
            this.deadline = 0L;
            this.errorMessage = null;
            this.elementId = null;
            this.elementInstanceKey = 0L;
            this.bpmnProcessId = null;
            this.processDefinitionVersion = 0;
            this.processDefinitionKey = 0L;
            this.customHeaders.clear();
            this.errorCode = null;
            this.variables.clear();
            return this;
        }

        public ImmutableJobRecordValue build() {
            return new ImmutableJobRecordValue(this);
        }

        private boolean customHeadersIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean variablesIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractJobRecordValue", generator="Immutables")
    static final class Json
    extends AbstractJobRecordValue {
        long processInstanceKey;
        boolean processInstanceKeyIsSet;
        String type;
        String worker;
        int retries;
        boolean retriesIsSet;
        long deadline;
        boolean deadlineIsSet;
        String errorMessage;
        String elementId;
        long elementInstanceKey;
        boolean elementInstanceKeyIsSet;
        String bpmnProcessId;
        int processDefinitionVersion;
        boolean processDefinitionVersionIsSet;
        long processDefinitionKey;
        boolean processDefinitionKeyIsSet;
        Map<String, String> customHeaders = Map.of();
        boolean customHeadersIsSet;
        String errorCode;
        Map<String, Object> variables = Map.of();
        boolean variablesIsSet;

        Json() {
        }

        @JsonProperty(value="processInstanceKey")
        public void setProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            this.processInstanceKeyIsSet = true;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="worker")
        public void setWorker(String worker) {
            this.worker = worker;
        }

        @JsonProperty(value="retries")
        public void setRetries(int retries) {
            this.retries = retries;
            this.retriesIsSet = true;
        }

        @JsonProperty(value="deadline")
        public void setDeadline(long deadline) {
            this.deadline = deadline;
            this.deadlineIsSet = true;
        }

        @JsonProperty(value="errorMessage")
        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @JsonProperty(value="elementId")
        public void setElementId(String elementId) {
            this.elementId = elementId;
        }

        @JsonProperty(value="elementInstanceKey")
        public void setElementInstanceKey(long elementInstanceKey) {
            this.elementInstanceKey = elementInstanceKey;
            this.elementInstanceKeyIsSet = true;
        }

        @JsonProperty(value="bpmnProcessId")
        public void setBpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
        }

        @JsonProperty(value="processDefinitionVersion")
        public void setProcessDefinitionVersion(int processDefinitionVersion) {
            this.processDefinitionVersion = processDefinitionVersion;
            this.processDefinitionVersionIsSet = true;
        }

        @JsonProperty(value="processDefinitionKey")
        public void setProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            this.processDefinitionKeyIsSet = true;
        }

        @JsonProperty(value="customHeaders")
        public void setCustomHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            this.customHeadersIsSet = true;
        }

        @JsonProperty(value="errorCode")
        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @JsonProperty(value="variables")
        public void setVariables(Map<String, Object> variables) {
            this.variables = variables;
            this.variablesIsSet = true;
        }

        public long getProcessInstanceKey() {
            throw new UnsupportedOperationException();
        }

        public String getType() {
            throw new UnsupportedOperationException();
        }

        public String getWorker() {
            throw new UnsupportedOperationException();
        }

        public int getRetries() {
            throw new UnsupportedOperationException();
        }

        public long getDeadline() {
            throw new UnsupportedOperationException();
        }

        public String getErrorMessage() {
            throw new UnsupportedOperationException();
        }

        public String getElementId() {
            throw new UnsupportedOperationException();
        }

        public long getElementInstanceKey() {
            throw new UnsupportedOperationException();
        }

        public String getBpmnProcessId() {
            throw new UnsupportedOperationException();
        }

        public int getProcessDefinitionVersion() {
            throw new UnsupportedOperationException();
        }

        public long getProcessDefinitionKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getCustomHeaders() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getErrorCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getVariables() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="AbstractJobRecordValue", generator="Immutables")
    private final class InitShim {
        private byte customHeadersBuildStage = 0;
        private Map<String, String> customHeaders;
        private byte errorCodeBuildStage = 0;
        private String errorCode;
        private byte variablesBuildStage = 0;
        private Map<String, Object> variables;

        private InitShim() {
        }

        Map<String, String> getCustomHeaders() {
            if (this.customHeadersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.customHeadersBuildStage == 0) {
                this.customHeadersBuildStage = (byte)-1;
                this.customHeaders = Map.copyOf(ImmutableJobRecordValue.super.getCustomHeaders());
                this.customHeadersBuildStage = 1;
            }
            return this.customHeaders;
        }

        void customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            this.customHeadersBuildStage = 1;
        }

        String getErrorCode() {
            if (this.errorCodeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.errorCodeBuildStage == 0) {
                this.errorCodeBuildStage = (byte)-1;
                this.errorCode = Objects.requireNonNull(ImmutableJobRecordValue.super.getErrorCode(), "errorCode");
                this.errorCodeBuildStage = 1;
            }
            return this.errorCode;
        }

        void errorCode(String errorCode) {
            this.errorCode = errorCode;
            this.errorCodeBuildStage = 1;
        }

        Map<String, Object> getVariables() {
            if (this.variablesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.variablesBuildStage == 0) {
                this.variablesBuildStage = (byte)-1;
                this.variables = Map.copyOf(ImmutableJobRecordValue.super.getVariables());
                this.variablesBuildStage = 1;
            }
            return this.variables;
        }

        void variables(Map<String, Object> variables) {
            this.variables = variables;
            this.variablesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.customHeadersBuildStage == -1) {
                attributes.add("customHeaders");
            }
            if (this.errorCodeBuildStage == -1) {
                attributes.add("errorCode");
            }
            if (this.variablesBuildStage == -1) {
                attributes.add("variables");
            }
            return "Cannot build JobRecordValue, attribute initializers form cycle " + attributes;
        }
    }
}

