/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.immutables.record.value;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import io.camunda.zeebe.protocol.record.value.ProcessEventRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.zeebe.protocol.immutables.record.value.AbstractProcessEventRecordValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractProcessEventRecordValue", generator="Immutables")
public final class ImmutableProcessEventRecordValue
extends AbstractProcessEventRecordValue {
    private final Map<String, Object> variables;
    private final long processInstanceKey;
    private final long scopeKey;
    private final String targetElementId;
    private final long processDefinitionKey;
    private final transient int hashCode;

    private ImmutableProcessEventRecordValue(Map<String, Object> variables, long processInstanceKey, long scopeKey, String targetElementId, long processDefinitionKey) {
        this.variables = variables;
        this.processInstanceKey = processInstanceKey;
        this.scopeKey = scopeKey;
        this.targetElementId = targetElementId;
        this.processDefinitionKey = processDefinitionKey;
        this.hashCode = this.computeHashCode();
    }

    @JsonProperty(value="variables")
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @JsonProperty(value="processInstanceKey")
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @JsonProperty(value="scopeKey")
    public long getScopeKey() {
        return this.scopeKey;
    }

    @JsonProperty(value="targetElementId")
    public String getTargetElementId() {
        return this.targetElementId;
    }

    @JsonProperty(value="processDefinitionKey")
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public final ImmutableProcessEventRecordValue withVariables(Map<String, ? extends Object> entries) {
        if (this.variables == entries) {
            return this;
        }
        Map<String, Object> newValue = Map.copyOf(entries);
        return new ImmutableProcessEventRecordValue(newValue, this.processInstanceKey, this.scopeKey, this.targetElementId, this.processDefinitionKey);
    }

    public final ImmutableProcessEventRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableProcessEventRecordValue(this.variables, value, this.scopeKey, this.targetElementId, this.processDefinitionKey);
    }

    public final ImmutableProcessEventRecordValue withScopeKey(long value) {
        if (this.scopeKey == value) {
            return this;
        }
        return new ImmutableProcessEventRecordValue(this.variables, this.processInstanceKey, value, this.targetElementId, this.processDefinitionKey);
    }

    public final ImmutableProcessEventRecordValue withTargetElementId(String value) {
        if (Objects.equals(this.targetElementId, value)) {
            return this;
        }
        return new ImmutableProcessEventRecordValue(this.variables, this.processInstanceKey, this.scopeKey, value, this.processDefinitionKey);
    }

    public final ImmutableProcessEventRecordValue withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableProcessEventRecordValue(this.variables, this.processInstanceKey, this.scopeKey, this.targetElementId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessEventRecordValue && this.equalTo(0, (ImmutableProcessEventRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableProcessEventRecordValue another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.variables.equals(another.variables) && this.processInstanceKey == another.processInstanceKey && this.scopeKey == another.scopeKey && Objects.equals(this.targetElementId, another.targetElementId) && this.processDefinitionKey == another.processDefinitionKey;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.variables.hashCode();
        h += (h << 5) + Long.hashCode(this.processInstanceKey);
        h += (h << 5) + Long.hashCode(this.scopeKey);
        h += (h << 5) + Objects.hashCode(this.targetElementId);
        h += (h << 5) + Long.hashCode(this.processDefinitionKey);
        return h;
    }

    public String toString() {
        return "ProcessEventRecordValue{variables=" + this.variables + ", processInstanceKey=" + this.processInstanceKey + ", scopeKey=" + this.scopeKey + ", targetElementId=" + this.targetElementId + ", processDefinitionKey=" + this.processDefinitionKey + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableProcessEventRecordValue fromJson(Json json) {
        Builder builder = ImmutableProcessEventRecordValue.builder();
        if (json.variables != null) {
            builder.putAllVariables(json.variables);
        }
        if (json.processInstanceKeyIsSet) {
            builder.processInstanceKey(json.processInstanceKey);
        }
        if (json.scopeKeyIsSet) {
            builder.scopeKey(json.scopeKey);
        }
        if (json.targetElementId != null) {
            builder.targetElementId(json.targetElementId);
        }
        if (json.processDefinitionKeyIsSet) {
            builder.processDefinitionKey(json.processDefinitionKey);
        }
        return builder.build();
    }

    public static ImmutableProcessEventRecordValue copyOf(AbstractProcessEventRecordValue instance) {
        if (instance instanceof ImmutableProcessEventRecordValue) {
            return (ImmutableProcessEventRecordValue)instance;
        }
        return ImmutableProcessEventRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AbstractProcessEventRecordValue", generator="Immutables")
    public static final class Builder {
        private Map<String, Object> variables = new LinkedHashMap<String, Object>();
        private long processInstanceKey;
        private long scopeKey;
        private String targetElementId;
        private long processDefinitionKey;

        private Builder() {
        }

        public final Builder from(ProcessInstanceRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ProcessEventRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RecordValueWithVariables instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractProcessEventRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ProcessInstanceRelated instance;
            if (object instanceof ProcessInstanceRelated) {
                instance = (ProcessInstanceRelated)object;
                this.processInstanceKey(instance.getProcessInstanceKey());
            }
            if (object instanceof ProcessEventRecordValue) {
                instance = (ProcessEventRecordValue)object;
                this.scopeKey(instance.getScopeKey());
                String targetElementIdValue = instance.getTargetElementId();
                if (targetElementIdValue != null) {
                    this.targetElementId(targetElementIdValue);
                }
                this.processDefinitionKey(instance.getProcessDefinitionKey());
            }
            if (object instanceof RecordValueWithVariables) {
                instance = (RecordValueWithVariables)object;
                this.putAllVariables(instance.getVariables());
            }
        }

        public final Builder putVariables(String key, Object value) {
            this.variables.put(Objects.requireNonNull(key, "variables key"), Objects.requireNonNull(value, "variables value"));
            return this;
        }

        public final Builder putVariables(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, "variables value"));
            return this;
        }

        public final Builder variables(Map<String, ? extends Object> entries) {
            this.variables.clear();
            return this.putAllVariables(entries);
        }

        public final Builder putAllVariables(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, "variables value"));
            }
            return this;
        }

        public final Builder processInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public final Builder scopeKey(long scopeKey) {
            this.scopeKey = scopeKey;
            return this;
        }

        public final Builder targetElementId(String targetElementId) {
            this.targetElementId = targetElementId;
            return this;
        }

        public final Builder processDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public Builder clear() {
            this.variables.clear();
            this.processInstanceKey = 0L;
            this.scopeKey = 0L;
            this.targetElementId = null;
            this.processDefinitionKey = 0L;
            return this;
        }

        public ImmutableProcessEventRecordValue build() {
            return new ImmutableProcessEventRecordValue(Map.copyOf(this.variables), this.processInstanceKey, this.scopeKey, this.targetElementId, this.processDefinitionKey);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractProcessEventRecordValue", generator="Immutables")
    static final class Json
    extends AbstractProcessEventRecordValue {
        Map<String, Object> variables = Map.of();
        long processInstanceKey;
        boolean processInstanceKeyIsSet;
        long scopeKey;
        boolean scopeKeyIsSet;
        String targetElementId;
        long processDefinitionKey;
        boolean processDefinitionKeyIsSet;

        Json() {
        }

        @JsonProperty(value="variables")
        public void setVariables(Map<String, Object> variables) {
            this.variables = variables;
        }

        @JsonProperty(value="processInstanceKey")
        public void setProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            this.processInstanceKeyIsSet = true;
        }

        @JsonProperty(value="scopeKey")
        public void setScopeKey(long scopeKey) {
            this.scopeKey = scopeKey;
            this.scopeKeyIsSet = true;
        }

        @JsonProperty(value="targetElementId")
        public void setTargetElementId(String targetElementId) {
            this.targetElementId = targetElementId;
        }

        @JsonProperty(value="processDefinitionKey")
        public void setProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            this.processDefinitionKeyIsSet = true;
        }

        public Map<String, Object> getVariables() {
            throw new UnsupportedOperationException();
        }

        public long getProcessInstanceKey() {
            throw new UnsupportedOperationException();
        }

        public long getScopeKey() {
            throw new UnsupportedOperationException();
        }

        public String getTargetElementId() {
            throw new UnsupportedOperationException();
        }

        public long getProcessDefinitionKey() {
            throw new UnsupportedOperationException();
        }
    }
}

