/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.immutables.record.value;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.zeebe.protocol.immutables.record.value.AbstractProcessInstanceRecordValue;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractProcessInstanceRecordValue", generator="Immutables")
public final class ImmutableProcessInstanceRecordValue
extends AbstractProcessInstanceRecordValue {
    private final String bpmnProcessId;
    private final int version;
    private final long processDefinitionKey;
    private final long processInstanceKey;
    private final String elementId;
    private final long flowScopeKey;
    private final long parentProcessInstanceKey;
    private final long parentElementInstanceKey;
    private final BpmnElementType bpmnElementType;
    private final transient int hashCode;

    private ImmutableProcessInstanceRecordValue(Builder builder) {
        this.bpmnProcessId = builder.bpmnProcessId;
        this.version = builder.version;
        this.processDefinitionKey = builder.processDefinitionKey;
        this.processInstanceKey = builder.processInstanceKey;
        this.elementId = builder.elementId;
        this.flowScopeKey = builder.flowScopeKey;
        this.parentProcessInstanceKey = builder.parentProcessInstanceKey;
        this.parentElementInstanceKey = builder.parentElementInstanceKey;
        this.bpmnElementType = builder.bpmnElementType != null ? builder.bpmnElementType : Objects.requireNonNull(super.getBpmnElementType(), "bpmnElementType");
        this.hashCode = this.computeHashCode();
    }

    private ImmutableProcessInstanceRecordValue(String bpmnProcessId, int version, long processDefinitionKey, long processInstanceKey, String elementId, long flowScopeKey, long parentProcessInstanceKey, long parentElementInstanceKey, BpmnElementType bpmnElementType) {
        this.bpmnProcessId = bpmnProcessId;
        this.version = version;
        this.processDefinitionKey = processDefinitionKey;
        this.processInstanceKey = processInstanceKey;
        this.elementId = elementId;
        this.flowScopeKey = flowScopeKey;
        this.parentProcessInstanceKey = parentProcessInstanceKey;
        this.parentElementInstanceKey = parentElementInstanceKey;
        this.bpmnElementType = bpmnElementType;
        this.hashCode = this.computeHashCode();
    }

    @JsonProperty(value="bpmnProcessId")
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @JsonProperty(value="version")
    public int getVersion() {
        return this.version;
    }

    @JsonProperty(value="processDefinitionKey")
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @JsonProperty(value="processInstanceKey")
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @JsonProperty(value="elementId")
    public String getElementId() {
        return this.elementId;
    }

    @JsonProperty(value="flowScopeKey")
    public long getFlowScopeKey() {
        return this.flowScopeKey;
    }

    @JsonProperty(value="parentProcessInstanceKey")
    public long getParentProcessInstanceKey() {
        return this.parentProcessInstanceKey;
    }

    @JsonProperty(value="parentElementInstanceKey")
    public long getParentElementInstanceKey() {
        return this.parentElementInstanceKey;
    }

    @Override
    @JsonProperty(value="bpmnElementType")
    public BpmnElementType getBpmnElementType() {
        return this.bpmnElementType;
    }

    public final ImmutableProcessInstanceRecordValue withBpmnProcessId(String value) {
        if (Objects.equals(this.bpmnProcessId, value)) {
            return this;
        }
        return new ImmutableProcessInstanceRecordValue(value, this.version, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.flowScopeKey, this.parentProcessInstanceKey, this.parentElementInstanceKey, this.bpmnElementType);
    }

    public final ImmutableProcessInstanceRecordValue withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableProcessInstanceRecordValue(this.bpmnProcessId, value, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.flowScopeKey, this.parentProcessInstanceKey, this.parentElementInstanceKey, this.bpmnElementType);
    }

    public final ImmutableProcessInstanceRecordValue withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableProcessInstanceRecordValue(this.bpmnProcessId, this.version, value, this.processInstanceKey, this.elementId, this.flowScopeKey, this.parentProcessInstanceKey, this.parentElementInstanceKey, this.bpmnElementType);
    }

    public final ImmutableProcessInstanceRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableProcessInstanceRecordValue(this.bpmnProcessId, this.version, this.processDefinitionKey, value, this.elementId, this.flowScopeKey, this.parentProcessInstanceKey, this.parentElementInstanceKey, this.bpmnElementType);
    }

    public final ImmutableProcessInstanceRecordValue withElementId(String value) {
        if (Objects.equals(this.elementId, value)) {
            return this;
        }
        return new ImmutableProcessInstanceRecordValue(this.bpmnProcessId, this.version, this.processDefinitionKey, this.processInstanceKey, value, this.flowScopeKey, this.parentProcessInstanceKey, this.parentElementInstanceKey, this.bpmnElementType);
    }

    public final ImmutableProcessInstanceRecordValue withFlowScopeKey(long value) {
        if (this.flowScopeKey == value) {
            return this;
        }
        return new ImmutableProcessInstanceRecordValue(this.bpmnProcessId, this.version, this.processDefinitionKey, this.processInstanceKey, this.elementId, value, this.parentProcessInstanceKey, this.parentElementInstanceKey, this.bpmnElementType);
    }

    public final ImmutableProcessInstanceRecordValue withParentProcessInstanceKey(long value) {
        if (this.parentProcessInstanceKey == value) {
            return this;
        }
        return new ImmutableProcessInstanceRecordValue(this.bpmnProcessId, this.version, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.flowScopeKey, value, this.parentElementInstanceKey, this.bpmnElementType);
    }

    public final ImmutableProcessInstanceRecordValue withParentElementInstanceKey(long value) {
        if (this.parentElementInstanceKey == value) {
            return this;
        }
        return new ImmutableProcessInstanceRecordValue(this.bpmnProcessId, this.version, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.flowScopeKey, this.parentProcessInstanceKey, value, this.bpmnElementType);
    }

    public final ImmutableProcessInstanceRecordValue withBpmnElementType(BpmnElementType value) {
        BpmnElementType newValue = Objects.requireNonNull(value, "bpmnElementType");
        if (this.bpmnElementType == newValue) {
            return this;
        }
        return new ImmutableProcessInstanceRecordValue(this.bpmnProcessId, this.version, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.flowScopeKey, this.parentProcessInstanceKey, this.parentElementInstanceKey, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessInstanceRecordValue && this.equalTo(0, (ImmutableProcessInstanceRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableProcessInstanceRecordValue another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.version == another.version && this.processDefinitionKey == another.processDefinitionKey && this.processInstanceKey == another.processInstanceKey && Objects.equals(this.elementId, another.elementId) && this.flowScopeKey == another.flowScopeKey && this.parentProcessInstanceKey == another.parentProcessInstanceKey && this.parentElementInstanceKey == another.parentElementInstanceKey && this.bpmnElementType.equals((Object)another.bpmnElementType);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.bpmnProcessId);
        h += (h << 5) + this.version;
        h += (h << 5) + Long.hashCode(this.processDefinitionKey);
        h += (h << 5) + Long.hashCode(this.processInstanceKey);
        h += (h << 5) + Objects.hashCode(this.elementId);
        h += (h << 5) + Long.hashCode(this.flowScopeKey);
        h += (h << 5) + Long.hashCode(this.parentProcessInstanceKey);
        h += (h << 5) + Long.hashCode(this.parentElementInstanceKey);
        h += (h << 5) + this.bpmnElementType.hashCode();
        return h;
    }

    public String toString() {
        return "ProcessInstanceRecordValue{bpmnProcessId=" + this.bpmnProcessId + ", version=" + this.version + ", processDefinitionKey=" + this.processDefinitionKey + ", processInstanceKey=" + this.processInstanceKey + ", elementId=" + this.elementId + ", flowScopeKey=" + this.flowScopeKey + ", parentProcessInstanceKey=" + this.parentProcessInstanceKey + ", parentElementInstanceKey=" + this.parentElementInstanceKey + ", bpmnElementType=" + this.bpmnElementType + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableProcessInstanceRecordValue fromJson(Json json) {
        Builder builder = ImmutableProcessInstanceRecordValue.builder();
        if (json.bpmnProcessId != null) {
            builder.bpmnProcessId(json.bpmnProcessId);
        }
        if (json.versionIsSet) {
            builder.version(json.version);
        }
        if (json.processDefinitionKeyIsSet) {
            builder.processDefinitionKey(json.processDefinitionKey);
        }
        if (json.processInstanceKeyIsSet) {
            builder.processInstanceKey(json.processInstanceKey);
        }
        if (json.elementId != null) {
            builder.elementId(json.elementId);
        }
        if (json.flowScopeKeyIsSet) {
            builder.flowScopeKey(json.flowScopeKey);
        }
        if (json.parentProcessInstanceKeyIsSet) {
            builder.parentProcessInstanceKey(json.parentProcessInstanceKey);
        }
        if (json.parentElementInstanceKeyIsSet) {
            builder.parentElementInstanceKey(json.parentElementInstanceKey);
        }
        if (json.bpmnElementType != null) {
            builder.bpmnElementType(json.bpmnElementType);
        }
        return builder.build();
    }

    public static ImmutableProcessInstanceRecordValue copyOf(AbstractProcessInstanceRecordValue instance) {
        if (instance instanceof ImmutableProcessInstanceRecordValue) {
            return (ImmutableProcessInstanceRecordValue)instance;
        }
        return ImmutableProcessInstanceRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AbstractProcessInstanceRecordValue", generator="Immutables")
    public static final class Builder {
        private String bpmnProcessId;
        private int version;
        private long processDefinitionKey;
        private long processInstanceKey;
        private String elementId;
        private long flowScopeKey;
        private long parentProcessInstanceKey;
        private long parentElementInstanceKey;
        private BpmnElementType bpmnElementType;

        private Builder() {
        }

        public final Builder from(ProcessInstanceRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ProcessInstanceRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractProcessInstanceRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof ProcessInstanceRelated) {
                instance = (ProcessInstanceRelated)object;
                if ((bits & 1L) == 0L) {
                    this.processInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
            }
            if (object instanceof ProcessInstanceRecordValue) {
                instance = (ProcessInstanceRecordValue)object;
                String elementIdValue = instance.getElementId();
                if (elementIdValue != null) {
                    this.elementId(elementIdValue);
                }
                if ((bits & 1L) == 0L) {
                    this.processInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
                this.flowScopeKey(instance.getFlowScopeKey());
                this.parentElementInstanceKey(instance.getParentElementInstanceKey());
                String bpmnProcessIdValue = instance.getBpmnProcessId();
                if (bpmnProcessIdValue != null) {
                    this.bpmnProcessId(bpmnProcessIdValue);
                }
                this.version(instance.getVersion());
                if ((bits & 2L) == 0L) {
                    this.bpmnElementType(instance.getBpmnElementType());
                    bits |= 2L;
                }
                this.parentProcessInstanceKey(instance.getParentProcessInstanceKey());
                this.processDefinitionKey(instance.getProcessDefinitionKey());
            }
            if (object instanceof AbstractProcessInstanceRecordValue) {
                instance = (AbstractProcessInstanceRecordValue)object;
                if ((bits & 2L) == 0L) {
                    this.bpmnElementType(((AbstractProcessInstanceRecordValue)instance).getBpmnElementType());
                    bits |= 2L;
                }
            }
        }

        public final Builder bpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
            return this;
        }

        public final Builder version(int version) {
            this.version = version;
            return this;
        }

        public final Builder processDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public final Builder processInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public final Builder elementId(String elementId) {
            this.elementId = elementId;
            return this;
        }

        public final Builder flowScopeKey(long flowScopeKey) {
            this.flowScopeKey = flowScopeKey;
            return this;
        }

        public final Builder parentProcessInstanceKey(long parentProcessInstanceKey) {
            this.parentProcessInstanceKey = parentProcessInstanceKey;
            return this;
        }

        public final Builder parentElementInstanceKey(long parentElementInstanceKey) {
            this.parentElementInstanceKey = parentElementInstanceKey;
            return this;
        }

        public final Builder bpmnElementType(BpmnElementType bpmnElementType) {
            this.bpmnElementType = Objects.requireNonNull(bpmnElementType, "bpmnElementType");
            return this;
        }

        public Builder clear() {
            this.bpmnProcessId = null;
            this.version = 0;
            this.processDefinitionKey = 0L;
            this.processInstanceKey = 0L;
            this.elementId = null;
            this.flowScopeKey = 0L;
            this.parentProcessInstanceKey = 0L;
            this.parentElementInstanceKey = 0L;
            this.bpmnElementType = null;
            return this;
        }

        public ImmutableProcessInstanceRecordValue build() {
            return new ImmutableProcessInstanceRecordValue(this);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractProcessInstanceRecordValue", generator="Immutables")
    static final class Json
    extends AbstractProcessInstanceRecordValue {
        String bpmnProcessId;
        int version;
        boolean versionIsSet;
        long processDefinitionKey;
        boolean processDefinitionKeyIsSet;
        long processInstanceKey;
        boolean processInstanceKeyIsSet;
        String elementId;
        long flowScopeKey;
        boolean flowScopeKeyIsSet;
        long parentProcessInstanceKey;
        boolean parentProcessInstanceKeyIsSet;
        long parentElementInstanceKey;
        boolean parentElementInstanceKeyIsSet;
        BpmnElementType bpmnElementType;

        Json() {
        }

        @JsonProperty(value="bpmnProcessId")
        public void setBpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
        }

        @JsonProperty(value="version")
        public void setVersion(int version) {
            this.version = version;
            this.versionIsSet = true;
        }

        @JsonProperty(value="processDefinitionKey")
        public void setProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            this.processDefinitionKeyIsSet = true;
        }

        @JsonProperty(value="processInstanceKey")
        public void setProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            this.processInstanceKeyIsSet = true;
        }

        @JsonProperty(value="elementId")
        public void setElementId(String elementId) {
            this.elementId = elementId;
        }

        @JsonProperty(value="flowScopeKey")
        public void setFlowScopeKey(long flowScopeKey) {
            this.flowScopeKey = flowScopeKey;
            this.flowScopeKeyIsSet = true;
        }

        @JsonProperty(value="parentProcessInstanceKey")
        public void setParentProcessInstanceKey(long parentProcessInstanceKey) {
            this.parentProcessInstanceKey = parentProcessInstanceKey;
            this.parentProcessInstanceKeyIsSet = true;
        }

        @JsonProperty(value="parentElementInstanceKey")
        public void setParentElementInstanceKey(long parentElementInstanceKey) {
            this.parentElementInstanceKey = parentElementInstanceKey;
            this.parentElementInstanceKeyIsSet = true;
        }

        @JsonProperty(value="bpmnElementType")
        public void setBpmnElementType(BpmnElementType bpmnElementType) {
            this.bpmnElementType = bpmnElementType;
        }

        public String getBpmnProcessId() {
            throw new UnsupportedOperationException();
        }

        public int getVersion() {
            throw new UnsupportedOperationException();
        }

        public long getProcessDefinitionKey() {
            throw new UnsupportedOperationException();
        }

        public long getProcessInstanceKey() {
            throw new UnsupportedOperationException();
        }

        public String getElementId() {
            throw new UnsupportedOperationException();
        }

        public long getFlowScopeKey() {
            throw new UnsupportedOperationException();
        }

        public long getParentProcessInstanceKey() {
            throw new UnsupportedOperationException();
        }

        public long getParentElementInstanceKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BpmnElementType getBpmnElementType() {
            throw new UnsupportedOperationException();
        }
    }
}

