/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.immutables.record.value;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceResultRecordValue;
import io.zeebe.protocol.immutables.record.value.AbstractProcessInstanceResultRecordValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractProcessInstanceResultRecordValue", generator="Immutables")
public final class ImmutableProcessInstanceResultRecordValue
extends AbstractProcessInstanceResultRecordValue {
    private final Map<String, Object> variables;
    private final String bpmnProcessId;
    private final int version;
    private final long processDefinitionKey;
    private final long processInstanceKey;
    private final transient int hashCode;

    private ImmutableProcessInstanceResultRecordValue(Map<String, Object> variables, String bpmnProcessId, int version, long processDefinitionKey, long processInstanceKey) {
        this.variables = variables;
        this.bpmnProcessId = bpmnProcessId;
        this.version = version;
        this.processDefinitionKey = processDefinitionKey;
        this.processInstanceKey = processInstanceKey;
        this.hashCode = this.computeHashCode();
    }

    @JsonProperty(value="variables")
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @JsonProperty(value="bpmnProcessId")
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @JsonProperty(value="version")
    public int getVersion() {
        return this.version;
    }

    @JsonProperty(value="processDefinitionKey")
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @JsonProperty(value="processInstanceKey")
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public final ImmutableProcessInstanceResultRecordValue withVariables(Map<String, ? extends Object> entries) {
        if (this.variables == entries) {
            return this;
        }
        Map<String, Object> newValue = Map.copyOf(entries);
        return new ImmutableProcessInstanceResultRecordValue(newValue, this.bpmnProcessId, this.version, this.processDefinitionKey, this.processInstanceKey);
    }

    public final ImmutableProcessInstanceResultRecordValue withBpmnProcessId(String value) {
        if (Objects.equals(this.bpmnProcessId, value)) {
            return this;
        }
        return new ImmutableProcessInstanceResultRecordValue(this.variables, value, this.version, this.processDefinitionKey, this.processInstanceKey);
    }

    public final ImmutableProcessInstanceResultRecordValue withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableProcessInstanceResultRecordValue(this.variables, this.bpmnProcessId, value, this.processDefinitionKey, this.processInstanceKey);
    }

    public final ImmutableProcessInstanceResultRecordValue withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableProcessInstanceResultRecordValue(this.variables, this.bpmnProcessId, this.version, value, this.processInstanceKey);
    }

    public final ImmutableProcessInstanceResultRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableProcessInstanceResultRecordValue(this.variables, this.bpmnProcessId, this.version, this.processDefinitionKey, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessInstanceResultRecordValue && this.equalTo(0, (ImmutableProcessInstanceResultRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableProcessInstanceResultRecordValue another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.variables.equals(another.variables) && Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.version == another.version && this.processDefinitionKey == another.processDefinitionKey && this.processInstanceKey == another.processInstanceKey;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.variables.hashCode();
        h += (h << 5) + Objects.hashCode(this.bpmnProcessId);
        h += (h << 5) + this.version;
        h += (h << 5) + Long.hashCode(this.processDefinitionKey);
        h += (h << 5) + Long.hashCode(this.processInstanceKey);
        return h;
    }

    public String toString() {
        return "ProcessInstanceResultRecordValue{variables=" + this.variables + ", bpmnProcessId=" + this.bpmnProcessId + ", version=" + this.version + ", processDefinitionKey=" + this.processDefinitionKey + ", processInstanceKey=" + this.processInstanceKey + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableProcessInstanceResultRecordValue fromJson(Json json) {
        Builder builder = ImmutableProcessInstanceResultRecordValue.builder();
        if (json.variables != null) {
            builder.putAllVariables(json.variables);
        }
        if (json.bpmnProcessId != null) {
            builder.bpmnProcessId(json.bpmnProcessId);
        }
        if (json.versionIsSet) {
            builder.version(json.version);
        }
        if (json.processDefinitionKeyIsSet) {
            builder.processDefinitionKey(json.processDefinitionKey);
        }
        if (json.processInstanceKeyIsSet) {
            builder.processInstanceKey(json.processInstanceKey);
        }
        return builder.build();
    }

    public static ImmutableProcessInstanceResultRecordValue copyOf(AbstractProcessInstanceResultRecordValue instance) {
        if (instance instanceof ImmutableProcessInstanceResultRecordValue) {
            return (ImmutableProcessInstanceResultRecordValue)instance;
        }
        return ImmutableProcessInstanceResultRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AbstractProcessInstanceResultRecordValue", generator="Immutables")
    public static final class Builder {
        private Map<String, Object> variables = new LinkedHashMap<String, Object>();
        private String bpmnProcessId;
        private int version;
        private long processDefinitionKey;
        private long processInstanceKey;

        private Builder() {
        }

        public final Builder from(ProcessInstanceRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ProcessInstanceResultRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RecordValueWithVariables instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractProcessInstanceResultRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ProcessInstanceRelated instance;
            long bits = 0L;
            if (object instanceof ProcessInstanceRelated) {
                instance = (ProcessInstanceRelated)object;
                if ((bits & 1L) == 0L) {
                    this.processInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
            }
            if (object instanceof ProcessInstanceResultRecordValue) {
                String bpmnProcessIdValue;
                instance = (ProcessInstanceResultRecordValue)object;
                if ((bits & 1L) == 0L) {
                    this.processInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
                if ((bpmnProcessIdValue = instance.getBpmnProcessId()) != null) {
                    this.bpmnProcessId(bpmnProcessIdValue);
                }
                this.version(instance.getVersion());
                this.processDefinitionKey(instance.getProcessDefinitionKey());
            }
            if (object instanceof RecordValueWithVariables) {
                instance = (RecordValueWithVariables)object;
                this.putAllVariables(instance.getVariables());
            }
        }

        public final Builder putVariables(String key, Object value) {
            this.variables.put(Objects.requireNonNull(key, "variables key"), Objects.requireNonNull(value, "variables value"));
            return this;
        }

        public final Builder putVariables(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, "variables value"));
            return this;
        }

        public final Builder variables(Map<String, ? extends Object> entries) {
            this.variables.clear();
            return this.putAllVariables(entries);
        }

        public final Builder putAllVariables(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, "variables value"));
            }
            return this;
        }

        public final Builder bpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
            return this;
        }

        public final Builder version(int version) {
            this.version = version;
            return this;
        }

        public final Builder processDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public final Builder processInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public Builder clear() {
            this.variables.clear();
            this.bpmnProcessId = null;
            this.version = 0;
            this.processDefinitionKey = 0L;
            this.processInstanceKey = 0L;
            return this;
        }

        public ImmutableProcessInstanceResultRecordValue build() {
            return new ImmutableProcessInstanceResultRecordValue(Map.copyOf(this.variables), this.bpmnProcessId, this.version, this.processDefinitionKey, this.processInstanceKey);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractProcessInstanceResultRecordValue", generator="Immutables")
    static final class Json
    extends AbstractProcessInstanceResultRecordValue {
        Map<String, Object> variables = Map.of();
        String bpmnProcessId;
        int version;
        boolean versionIsSet;
        long processDefinitionKey;
        boolean processDefinitionKeyIsSet;
        long processInstanceKey;
        boolean processInstanceKeyIsSet;

        Json() {
        }

        @JsonProperty(value="variables")
        public void setVariables(Map<String, Object> variables) {
            this.variables = variables;
        }

        @JsonProperty(value="bpmnProcessId")
        public void setBpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
        }

        @JsonProperty(value="version")
        public void setVersion(int version) {
            this.version = version;
            this.versionIsSet = true;
        }

        @JsonProperty(value="processDefinitionKey")
        public void setProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            this.processDefinitionKeyIsSet = true;
        }

        @JsonProperty(value="processInstanceKey")
        public void setProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            this.processInstanceKeyIsSet = true;
        }

        public Map<String, Object> getVariables() {
            throw new UnsupportedOperationException();
        }

        public String getBpmnProcessId() {
            throw new UnsupportedOperationException();
        }

        public int getVersion() {
            throw new UnsupportedOperationException();
        }

        public long getProcessDefinitionKey() {
            throw new UnsupportedOperationException();
        }

        public long getProcessInstanceKey() {
            throw new UnsupportedOperationException();
        }
    }
}

