/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.immutables.record.value;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.immutables.record.value.AbstractRecord;
import io.zeebe.protocol.immutables.record.value.IntentTypeIdResolver;
import io.zeebe.protocol.immutables.record.value.ValueTypeIdResolver;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractRecord", generator="Immutables")
public final class ImmutableRecord<T extends RecordValue>
extends AbstractRecord<T> {
    private final long position;
    private final long sourceRecordPosition;
    private final long key;
    private final long timestamp;
    private final int partitionId;
    private final String rejectionReason;
    private final String brokerVersion;
    private final ValueType valueType;
    private final Intent intent;
    private final RecordType recordType;
    private final RejectionType rejectionType;
    private final T value;
    private final transient int hashCode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRecord(Builder<T> builder) {
        this.position = builder.position;
        this.sourceRecordPosition = builder.sourceRecordPosition;
        this.key = builder.key;
        this.timestamp = builder.timestamp;
        this.partitionId = builder.partitionId;
        this.rejectionReason = builder.rejectionReason;
        this.brokerVersion = builder.brokerVersion;
        this.valueType = builder.valueType;
        this.value = builder.value;
        if (builder.intent != null) {
            this.initShim.intent(builder.intent);
        }
        if (builder.recordType != null) {
            this.initShim.recordType(builder.recordType);
        }
        if (builder.rejectionType != null) {
            this.initShim.rejectionType(builder.rejectionType);
        }
        this.intent = this.initShim.getIntent();
        this.recordType = this.initShim.getRecordType();
        this.rejectionType = this.initShim.getRejectionType();
        this.hashCode = this.computeHashCode();
        this.initShim = null;
    }

    private ImmutableRecord(long position, long sourceRecordPosition, long key, long timestamp, int partitionId, String rejectionReason, String brokerVersion, ValueType valueType, Intent intent, RecordType recordType, RejectionType rejectionType, T value) {
        this.position = position;
        this.sourceRecordPosition = sourceRecordPosition;
        this.key = key;
        this.timestamp = timestamp;
        this.partitionId = partitionId;
        this.rejectionReason = rejectionReason;
        this.brokerVersion = brokerVersion;
        this.valueType = valueType;
        this.intent = intent;
        this.recordType = recordType;
        this.rejectionType = rejectionType;
        this.value = value;
        this.hashCode = this.computeHashCode();
        this.initShim = null;
    }

    @JsonProperty(value="position")
    public long getPosition() {
        return this.position;
    }

    @JsonProperty(value="sourceRecordPosition")
    public long getSourceRecordPosition() {
        return this.sourceRecordPosition;
    }

    @JsonProperty(value="key")
    public long getKey() {
        return this.key;
    }

    @JsonProperty(value="timestamp")
    public long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="partitionId")
    public int getPartitionId() {
        return this.partitionId;
    }

    @JsonProperty(value="rejectionReason")
    public String getRejectionReason() {
        return this.rejectionReason;
    }

    @JsonProperty(value="brokerVersion")
    public String getBrokerVersion() {
        return this.brokerVersion;
    }

    @JsonProperty(value="valueType")
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    @JsonProperty(value="intent")
    @JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="valueType")
    @JsonTypeIdResolver(value=IntentTypeIdResolver.class)
    public Intent getIntent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getIntent() : this.intent;
    }

    @Override
    @JsonProperty(value="recordType")
    public RecordType getRecordType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRecordType() : this.recordType;
    }

    @Override
    @JsonProperty(value="rejectionType")
    public RejectionType getRejectionType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRejectionType() : this.rejectionType;
    }

    @Override
    @JsonProperty(value="value")
    @JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="valueType")
    @JsonTypeIdResolver(value=ValueTypeIdResolver.class)
    public T getValue() {
        return this.value;
    }

    public final ImmutableRecord<T> withPosition(long value) {
        if (this.position == value) {
            return this;
        }
        return new ImmutableRecord<T>(value, this.sourceRecordPosition, this.key, this.timestamp, this.partitionId, this.rejectionReason, this.brokerVersion, this.valueType, this.intent, this.recordType, this.rejectionType, this.value);
    }

    public final ImmutableRecord<T> withSourceRecordPosition(long value) {
        if (this.sourceRecordPosition == value) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, value, this.key, this.timestamp, this.partitionId, this.rejectionReason, this.brokerVersion, this.valueType, this.intent, this.recordType, this.rejectionType, this.value);
    }

    public final ImmutableRecord<T> withKey(long value) {
        if (this.key == value) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, value, this.timestamp, this.partitionId, this.rejectionReason, this.brokerVersion, this.valueType, this.intent, this.recordType, this.rejectionType, this.value);
    }

    public final ImmutableRecord<T> withTimestamp(long value) {
        if (this.timestamp == value) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, value, this.partitionId, this.rejectionReason, this.brokerVersion, this.valueType, this.intent, this.recordType, this.rejectionType, this.value);
    }

    public final ImmutableRecord<T> withPartitionId(int value) {
        if (this.partitionId == value) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, this.timestamp, value, this.rejectionReason, this.brokerVersion, this.valueType, this.intent, this.recordType, this.rejectionType, this.value);
    }

    public final ImmutableRecord<T> withRejectionReason(String value) {
        if (Objects.equals(this.rejectionReason, value)) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, this.timestamp, this.partitionId, value, this.brokerVersion, this.valueType, this.intent, this.recordType, this.rejectionType, this.value);
    }

    public final ImmutableRecord<T> withBrokerVersion(String value) {
        if (Objects.equals(this.brokerVersion, value)) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, this.timestamp, this.partitionId, this.rejectionReason, value, this.valueType, this.intent, this.recordType, this.rejectionType, this.value);
    }

    public final ImmutableRecord<T> withValueType(ValueType value) {
        if (this.valueType == value) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, this.timestamp, this.partitionId, this.rejectionReason, this.brokerVersion, value, this.intent, this.recordType, this.rejectionType, this.value);
    }

    public final ImmutableRecord<T> withIntent(Intent value) {
        if (this.intent == value) {
            return this;
        }
        Intent newValue = Objects.requireNonNull(value, "intent");
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, this.timestamp, this.partitionId, this.rejectionReason, this.brokerVersion, this.valueType, newValue, this.recordType, this.rejectionType, this.value);
    }

    public final ImmutableRecord<T> withRecordType(RecordType value) {
        RecordType newValue = Objects.requireNonNull(value, "recordType");
        if (this.recordType == newValue) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, this.timestamp, this.partitionId, this.rejectionReason, this.brokerVersion, this.valueType, this.intent, newValue, this.rejectionType, this.value);
    }

    public final ImmutableRecord<T> withRejectionType(RejectionType value) {
        RejectionType newValue = Objects.requireNonNull(value, "rejectionType");
        if (this.rejectionType == newValue) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, this.timestamp, this.partitionId, this.rejectionReason, this.brokerVersion, this.valueType, this.intent, this.recordType, newValue, this.value);
    }

    public final ImmutableRecord<T> withValue(T value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableRecord<T>(this.position, this.sourceRecordPosition, this.key, this.timestamp, this.partitionId, this.rejectionReason, this.brokerVersion, this.valueType, this.intent, this.recordType, this.rejectionType, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRecord && this.equalTo(0, (ImmutableRecord)another);
    }

    private boolean equalTo(int synthetic, ImmutableRecord<?> another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.position == another.position && this.sourceRecordPosition == another.sourceRecordPosition && this.key == another.key && this.timestamp == another.timestamp && this.partitionId == another.partitionId && Objects.equals(this.rejectionReason, another.rejectionReason) && Objects.equals(this.brokerVersion, another.brokerVersion) && Objects.equals(this.valueType, another.valueType) && this.intent.equals(another.intent) && this.recordType.equals((Object)another.recordType) && this.rejectionType.equals((Object)another.rejectionType) && Objects.equals(this.value, another.value);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.position);
        h += (h << 5) + Long.hashCode(this.sourceRecordPosition);
        h += (h << 5) + Long.hashCode(this.key);
        h += (h << 5) + Long.hashCode(this.timestamp);
        h += (h << 5) + this.partitionId;
        h += (h << 5) + Objects.hashCode(this.rejectionReason);
        h += (h << 5) + Objects.hashCode(this.brokerVersion);
        h += (h << 5) + Objects.hashCode(this.valueType);
        h += (h << 5) + this.intent.hashCode();
        h += (h << 5) + this.recordType.hashCode();
        h += (h << 5) + this.rejectionType.hashCode();
        h += (h << 5) + Objects.hashCode(this.value);
        return h;
    }

    public String toString() {
        return "Record{position=" + this.position + ", sourceRecordPosition=" + this.sourceRecordPosition + ", key=" + this.key + ", timestamp=" + this.timestamp + ", partitionId=" + this.partitionId + ", rejectionReason=" + this.rejectionReason + ", brokerVersion=" + this.brokerVersion + ", valueType=" + this.valueType + ", intent=" + this.intent + ", recordType=" + this.recordType + ", rejectionType=" + this.rejectionType + ", value=" + this.value + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <T extends RecordValue> ImmutableRecord<T> fromJson(Json<T> json) {
        Builder builder = ImmutableRecord.builder();
        if (json.positionIsSet) {
            builder.position(json.position);
        }
        if (json.sourceRecordPositionIsSet) {
            builder.sourceRecordPosition(json.sourceRecordPosition);
        }
        if (json.keyIsSet) {
            builder.key(json.key);
        }
        if (json.timestampIsSet) {
            builder.timestamp(json.timestamp);
        }
        if (json.partitionIdIsSet) {
            builder.partitionId(json.partitionId);
        }
        if (json.rejectionReason != null) {
            builder.rejectionReason(json.rejectionReason);
        }
        if (json.brokerVersion != null) {
            builder.brokerVersion(json.brokerVersion);
        }
        if (json.valueType != null) {
            builder.valueType(json.valueType);
        }
        if (json.intent != null) {
            builder.intent(json.intent);
        }
        if (json.recordType != null) {
            builder.recordType(json.recordType);
        }
        if (json.rejectionType != null) {
            builder.rejectionType(json.rejectionType);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        return builder.build();
    }

    public static <T extends RecordValue> ImmutableRecord<T> copyOf(AbstractRecord<T> instance) {
        if (instance instanceof ImmutableRecord) {
            return (ImmutableRecord)instance;
        }
        return ImmutableRecord.builder().from(instance).build();
    }

    public static <T extends RecordValue> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="AbstractRecord", generator="Immutables")
    public static final class Builder<T extends RecordValue> {
        private long position;
        private long sourceRecordPosition;
        private long key;
        private long timestamp;
        private int partitionId;
        private String rejectionReason;
        private String brokerVersion;
        private ValueType valueType;
        private Intent intent;
        private RecordType recordType;
        private RejectionType rejectionType;
        private T value;

        private Builder() {
        }

        public final Builder<T> from(AbstractRecord<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder<T> from(Record<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractRecord instance;
            long bits = 0L;
            if (object instanceof AbstractRecord) {
                instance = (AbstractRecord)object;
                if ((bits & 2L) == 0L) {
                    this.rejectionType(instance.getRejectionType());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.intent(instance.getIntent());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    Object valueValue = instance.getValue();
                    if (valueValue != null) {
                        this.value(valueValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 1L) == 0L) {
                    this.recordType(instance.getRecordType());
                    bits |= 1L;
                }
            }
            if (object instanceof Record) {
                String brokerVersionValue;
                String rejectionReasonValue;
                ValueType valueTypeValue;
                instance = (Record)object;
                this.partitionId(instance.getPartitionId());
                this.sourceRecordPosition(instance.getSourceRecordPosition());
                if ((bits & 1L) == 0L) {
                    this.recordType(instance.getRecordType());
                    bits |= 1L;
                }
                if ((valueTypeValue = instance.getValueType()) != null) {
                    this.valueType(valueTypeValue);
                }
                this.position(instance.getPosition());
                if ((bits & 2L) == 0L) {
                    this.rejectionType(instance.getRejectionType());
                    bits |= 2L;
                }
                if ((rejectionReasonValue = instance.getRejectionReason()) != null) {
                    this.rejectionReason(rejectionReasonValue);
                }
                if ((brokerVersionValue = instance.getBrokerVersion()) != null) {
                    this.brokerVersion(brokerVersionValue);
                }
                if ((bits & 4L) == 0L) {
                    this.intent(instance.getIntent());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    RecordValue valueValue = instance.getValue();
                    if (valueValue != null) {
                        this.value(valueValue);
                    }
                    bits |= 8L;
                }
                this.key(instance.getKey());
                this.timestamp(instance.getTimestamp());
            }
        }

        public final Builder<T> position(long position) {
            this.position = position;
            return this;
        }

        public final Builder<T> sourceRecordPosition(long sourceRecordPosition) {
            this.sourceRecordPosition = sourceRecordPosition;
            return this;
        }

        public final Builder<T> key(long key) {
            this.key = key;
            return this;
        }

        public final Builder<T> timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Builder<T> partitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        public final Builder<T> rejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
            return this;
        }

        public final Builder<T> brokerVersion(String brokerVersion) {
            this.brokerVersion = brokerVersion;
            return this;
        }

        public final Builder<T> valueType(ValueType valueType) {
            this.valueType = valueType;
            return this;
        }

        public final Builder<T> intent(Intent intent) {
            this.intent = Objects.requireNonNull(intent, "intent");
            return this;
        }

        public final Builder<T> recordType(RecordType recordType) {
            this.recordType = Objects.requireNonNull(recordType, "recordType");
            return this;
        }

        public final Builder<T> rejectionType(RejectionType rejectionType) {
            this.rejectionType = Objects.requireNonNull(rejectionType, "rejectionType");
            return this;
        }

        public final Builder<T> value(T value) {
            this.value = value;
            return this;
        }

        public Builder<T> clear() {
            this.position = 0L;
            this.sourceRecordPosition = 0L;
            this.key = 0L;
            this.timestamp = 0L;
            this.partitionId = 0;
            this.rejectionReason = null;
            this.brokerVersion = null;
            this.valueType = null;
            this.intent = null;
            this.recordType = null;
            this.rejectionType = null;
            this.value = null;
            return this;
        }

        public ImmutableRecord<T> build() {
            return new ImmutableRecord(this);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractRecord", generator="Immutables")
    static final class Json<T extends RecordValue>
    extends AbstractRecord<T> {
        long position;
        boolean positionIsSet;
        long sourceRecordPosition;
        boolean sourceRecordPositionIsSet;
        long key;
        boolean keyIsSet;
        long timestamp;
        boolean timestampIsSet;
        int partitionId;
        boolean partitionIdIsSet;
        String rejectionReason;
        String brokerVersion;
        ValueType valueType;
        Intent intent;
        RecordType recordType;
        RejectionType rejectionType;
        T value;

        Json() {
        }

        @JsonProperty(value="position")
        public void setPosition(long position) {
            this.position = position;
            this.positionIsSet = true;
        }

        @JsonProperty(value="sourceRecordPosition")
        public void setSourceRecordPosition(long sourceRecordPosition) {
            this.sourceRecordPosition = sourceRecordPosition;
            this.sourceRecordPositionIsSet = true;
        }

        @JsonProperty(value="key")
        public void setKey(long key) {
            this.key = key;
            this.keyIsSet = true;
        }

        @JsonProperty(value="timestamp")
        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            this.timestampIsSet = true;
        }

        @JsonProperty(value="partitionId")
        public void setPartitionId(int partitionId) {
            this.partitionId = partitionId;
            this.partitionIdIsSet = true;
        }

        @JsonProperty(value="rejectionReason")
        public void setRejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
        }

        @JsonProperty(value="brokerVersion")
        public void setBrokerVersion(String brokerVersion) {
            this.brokerVersion = brokerVersion;
        }

        @JsonProperty(value="valueType")
        public void setValueType(ValueType valueType) {
            this.valueType = valueType;
        }

        @JsonProperty(value="intent")
        @JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="valueType")
        @JsonTypeIdResolver(value=IntentTypeIdResolver.class)
        public void setIntent(Intent intent) {
            this.intent = intent;
        }

        @JsonProperty(value="recordType")
        public void setRecordType(RecordType recordType) {
            this.recordType = recordType;
        }

        @JsonProperty(value="rejectionType")
        public void setRejectionType(RejectionType rejectionType) {
            this.rejectionType = rejectionType;
        }

        @JsonProperty(value="value")
        @JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="valueType")
        @JsonTypeIdResolver(value=ValueTypeIdResolver.class)
        public void setValue(T value) {
            this.value = value;
        }

        public long getPosition() {
            throw new UnsupportedOperationException();
        }

        public long getSourceRecordPosition() {
            throw new UnsupportedOperationException();
        }

        public long getKey() {
            throw new UnsupportedOperationException();
        }

        public long getTimestamp() {
            throw new UnsupportedOperationException();
        }

        public int getPartitionId() {
            throw new UnsupportedOperationException();
        }

        public String getRejectionReason() {
            throw new UnsupportedOperationException();
        }

        public String getBrokerVersion() {
            throw new UnsupportedOperationException();
        }

        public ValueType getValueType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Intent getIntent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RecordType getRecordType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RejectionType getRejectionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T getValue() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="AbstractRecord", generator="Immutables")
    private final class InitShim {
        private byte intentBuildStage = 0;
        private Intent intent;
        private byte recordTypeBuildStage = 0;
        private RecordType recordType;
        private byte rejectionTypeBuildStage = 0;
        private RejectionType rejectionType;

        private InitShim() {
        }

        Intent getIntent() {
            if (this.intentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.intentBuildStage == 0) {
                this.intentBuildStage = (byte)-1;
                this.intent = Objects.requireNonNull(ImmutableRecord.super.getIntent(), "intent");
                this.intentBuildStage = 1;
            }
            return this.intent;
        }

        void intent(Intent intent) {
            this.intent = intent;
            this.intentBuildStage = 1;
        }

        RecordType getRecordType() {
            if (this.recordTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.recordTypeBuildStage == 0) {
                this.recordTypeBuildStage = (byte)-1;
                this.recordType = Objects.requireNonNull(ImmutableRecord.super.getRecordType(), "recordType");
                this.recordTypeBuildStage = 1;
            }
            return this.recordType;
        }

        void recordType(RecordType recordType) {
            this.recordType = recordType;
            this.recordTypeBuildStage = 1;
        }

        RejectionType getRejectionType() {
            if (this.rejectionTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rejectionTypeBuildStage == 0) {
                this.rejectionTypeBuildStage = (byte)-1;
                this.rejectionType = Objects.requireNonNull(ImmutableRecord.super.getRejectionType(), "rejectionType");
                this.rejectionTypeBuildStage = 1;
            }
            return this.rejectionType;
        }

        void rejectionType(RejectionType rejectionType) {
            this.rejectionType = rejectionType;
            this.rejectionTypeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.intentBuildStage == -1) {
                attributes.add("intent");
            }
            if (this.recordTypeBuildStage == -1) {
                attributes.add("recordType");
            }
            if (this.rejectionTypeBuildStage == -1) {
                attributes.add("rejectionType");
            }
            return "Cannot build Record, attribute initializers form cycle " + attributes;
        }
    }
}

