/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.immutables.record.value;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.zeebe.protocol.immutables.record.value.AbstractVariableRecordValue;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractVariableRecordValue", generator="Immutables")
public final class ImmutableVariableRecordValue
extends AbstractVariableRecordValue {
    private final String name;
    private final String value;
    private final long scopeKey;
    private final long processInstanceKey;
    private final long processDefinitionKey;
    private final transient int hashCode;

    private ImmutableVariableRecordValue(String name, String value, long scopeKey, long processInstanceKey, long processDefinitionKey) {
        this.name = name;
        this.value = value;
        this.scopeKey = scopeKey;
        this.processInstanceKey = processInstanceKey;
        this.processDefinitionKey = processDefinitionKey;
        this.hashCode = this.computeHashCode();
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="scopeKey")
    public long getScopeKey() {
        return this.scopeKey;
    }

    @JsonProperty(value="processInstanceKey")
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @JsonProperty(value="processDefinitionKey")
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public final ImmutableVariableRecordValue withName(String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableVariableRecordValue(value, this.value, this.scopeKey, this.processInstanceKey, this.processDefinitionKey);
    }

    public final ImmutableVariableRecordValue withValue(String value) {
        if (Objects.equals(this.value, value)) {
            return this;
        }
        return new ImmutableVariableRecordValue(this.name, value, this.scopeKey, this.processInstanceKey, this.processDefinitionKey);
    }

    public final ImmutableVariableRecordValue withScopeKey(long value) {
        if (this.scopeKey == value) {
            return this;
        }
        return new ImmutableVariableRecordValue(this.name, this.value, value, this.processInstanceKey, this.processDefinitionKey);
    }

    public final ImmutableVariableRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableVariableRecordValue(this.name, this.value, this.scopeKey, value, this.processDefinitionKey);
    }

    public final ImmutableVariableRecordValue withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableVariableRecordValue(this.name, this.value, this.scopeKey, this.processInstanceKey, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVariableRecordValue && this.equalTo(0, (ImmutableVariableRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableVariableRecordValue another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.name, another.name) && Objects.equals(this.value, another.value) && this.scopeKey == another.scopeKey && this.processInstanceKey == another.processInstanceKey && this.processDefinitionKey == another.processDefinitionKey;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + Long.hashCode(this.scopeKey);
        h += (h << 5) + Long.hashCode(this.processInstanceKey);
        h += (h << 5) + Long.hashCode(this.processDefinitionKey);
        return h;
    }

    public String toString() {
        return "VariableRecordValue{name=" + this.name + ", value=" + this.value + ", scopeKey=" + this.scopeKey + ", processInstanceKey=" + this.processInstanceKey + ", processDefinitionKey=" + this.processDefinitionKey + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableVariableRecordValue fromJson(Json json) {
        Builder builder = ImmutableVariableRecordValue.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.scopeKeyIsSet) {
            builder.scopeKey(json.scopeKey);
        }
        if (json.processInstanceKeyIsSet) {
            builder.processInstanceKey(json.processInstanceKey);
        }
        if (json.processDefinitionKeyIsSet) {
            builder.processDefinitionKey(json.processDefinitionKey);
        }
        return builder.build();
    }

    public static ImmutableVariableRecordValue copyOf(AbstractVariableRecordValue instance) {
        if (instance instanceof ImmutableVariableRecordValue) {
            return (ImmutableVariableRecordValue)instance;
        }
        return ImmutableVariableRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AbstractVariableRecordValue", generator="Immutables")
    public static final class Builder {
        private String name;
        private String value;
        private long scopeKey;
        private long processInstanceKey;
        private long processDefinitionKey;

        private Builder() {
        }

        public final Builder from(ProcessInstanceRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(VariableRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractVariableRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ProcessInstanceRelated instance;
            long bits = 0L;
            if (object instanceof ProcessInstanceRelated) {
                instance = (ProcessInstanceRelated)object;
                if ((bits & 1L) == 0L) {
                    this.processInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
            }
            if (object instanceof VariableRecordValue) {
                String valueValue;
                instance = (VariableRecordValue)object;
                String nameValue = instance.getName();
                if (nameValue != null) {
                    this.name(nameValue);
                }
                this.scopeKey(instance.getScopeKey());
                if ((bits & 1L) == 0L) {
                    this.processInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
                if ((valueValue = instance.getValue()) != null) {
                    this.value(valueValue);
                }
                this.processDefinitionKey(instance.getProcessDefinitionKey());
            }
        }

        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Builder scopeKey(long scopeKey) {
            this.scopeKey = scopeKey;
            return this;
        }

        public final Builder processInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public final Builder processDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public Builder clear() {
            this.name = null;
            this.value = null;
            this.scopeKey = 0L;
            this.processInstanceKey = 0L;
            this.processDefinitionKey = 0L;
            return this;
        }

        public ImmutableVariableRecordValue build() {
            return new ImmutableVariableRecordValue(this.name, this.value, this.scopeKey, this.processInstanceKey, this.processDefinitionKey);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractVariableRecordValue", generator="Immutables")
    static final class Json
    extends AbstractVariableRecordValue {
        String name;
        String value;
        long scopeKey;
        boolean scopeKeyIsSet;
        long processInstanceKey;
        boolean processInstanceKeyIsSet;
        long processDefinitionKey;
        boolean processDefinitionKeyIsSet;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="scopeKey")
        public void setScopeKey(long scopeKey) {
            this.scopeKey = scopeKey;
            this.scopeKeyIsSet = true;
        }

        @JsonProperty(value="processInstanceKey")
        public void setProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            this.processInstanceKeyIsSet = true;
        }

        @JsonProperty(value="processDefinitionKey")
        public void setProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            this.processDefinitionKeyIsSet = true;
        }

        public String getName() {
            throw new UnsupportedOperationException();
        }

        public String getValue() {
            throw new UnsupportedOperationException();
        }

        public long getScopeKey() {
            throw new UnsupportedOperationException();
        }

        public long getProcessInstanceKey() {
            throw new UnsupportedOperationException();
        }

        public long getProcessDefinitionKey() {
            throw new UnsupportedOperationException();
        }
    }
}

