/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.immutables.record.value;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.ErrorIntent;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessEventIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceResultIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;

final class IntentTypeIdResolver
extends TypeIdResolverBase {
    IntentTypeIdResolver() {
    }

    public String idFromValue(Object value) {
        return ((ValueType)value).name();
    }

    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return this.idFromValue(value);
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public JavaType typeFromId(DatabindContext context, String id) {
        ValueType valueType = ValueType.valueOf((String)id);
        TypeFactory typeFactory = context.getTypeFactory();
        return typeFactory.constructType(this.mapValueTypeToIntentClass(valueType));
    }

    private Class<? extends Enum<? extends Intent>> mapValueTypeToIntentClass(ValueType valueType) {
        switch (valueType) {
            case JOB: {
                return JobIntent.class;
            }
            case DEPLOYMENT: {
                return DeploymentIntent.class;
            }
            case PROCESS_INSTANCE: {
                return ProcessInstanceIntent.class;
            }
            case INCIDENT: {
                return IncidentIntent.class;
            }
            case MESSAGE: {
                return MessageIntent.class;
            }
            case MESSAGE_SUBSCRIPTION: {
                return MessageSubscriptionIntent.class;
            }
            case PROCESS_MESSAGE_SUBSCRIPTION: {
                return ProcessMessageSubscriptionIntent.class;
            }
            case JOB_BATCH: {
                return JobBatchIntent.class;
            }
            case TIMER: {
                return TimerIntent.class;
            }
            case MESSAGE_START_EVENT_SUBSCRIPTION: {
                return MessageStartEventSubscriptionIntent.class;
            }
            case VARIABLE: {
                return VariableIntent.class;
            }
            case VARIABLE_DOCUMENT: {
                return VariableDocumentIntent.class;
            }
            case PROCESS_INSTANCE_CREATION: {
                return ProcessInstanceCreationIntent.class;
            }
            case ERROR: {
                return ErrorIntent.class;
            }
            case PROCESS_INSTANCE_RESULT: {
                return ProcessInstanceResultIntent.class;
            }
            case PROCESS: {
                return ProcessIntent.class;
            }
            case PROCESS_EVENT: {
                return ProcessEventIntent.class;
            }
            case DEPLOYMENT_DISTRIBUTION: {
                return DeploymentDistributionIntent.class;
            }
        }
        return UnknownIntent.class;
    }

    private static enum UnknownIntent implements Intent
    {
        UNKNOWN;


        public short value() {
            return Intent.UNKNOWN.value();
        }
    }
}

