/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.immutables.record.value;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.immutables.record.value.ImmutableDeploymentDistributionRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableDeploymentRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableErrorRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableIncidentRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableJobBatchRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableJobRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableMessageRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableMessageStartEventSubscriptionRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableMessageSubscriptionRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableProcessEventRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableProcessInstanceCreationRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableProcessInstanceRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableProcessInstanceResultRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableProcessMessageSubscriptionRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableTimerRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableVariableDocumentRecordValue;
import io.zeebe.protocol.immutables.record.value.ImmutableVariableRecordValue;
import io.zeebe.protocol.immutables.record.value.deployment.ImmutableProcess;

final class ValueTypeIdResolver
extends TypeIdResolverBase {
    ValueTypeIdResolver() {
    }

    public String idFromValue(Object value) {
        return ((ValueType)value).name();
    }

    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return this.idFromValue(value);
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public JavaType typeFromId(DatabindContext context, String id) {
        ValueType valueType = ValueType.valueOf((String)id);
        TypeFactory typeFactory = context.getTypeFactory();
        return typeFactory.constructType(this.mapValueTypeToRecordValue(valueType));
    }

    private Class<? extends RecordValue> mapValueTypeToRecordValue(ValueType valueType) {
        switch (valueType) {
            case JOB: {
                return ImmutableJobRecordValue.class;
            }
            case DEPLOYMENT: {
                return ImmutableDeploymentRecordValue.class;
            }
            case PROCESS_INSTANCE: {
                return ImmutableProcessInstanceRecordValue.class;
            }
            case INCIDENT: {
                return ImmutableIncidentRecordValue.class;
            }
            case MESSAGE: {
                return ImmutableMessageRecordValue.class;
            }
            case MESSAGE_SUBSCRIPTION: {
                return ImmutableMessageSubscriptionRecordValue.class;
            }
            case PROCESS_MESSAGE_SUBSCRIPTION: {
                return ImmutableProcessMessageSubscriptionRecordValue.class;
            }
            case JOB_BATCH: {
                return ImmutableJobBatchRecordValue.class;
            }
            case TIMER: {
                return ImmutableTimerRecordValue.class;
            }
            case MESSAGE_START_EVENT_SUBSCRIPTION: {
                return ImmutableMessageStartEventSubscriptionRecordValue.class;
            }
            case VARIABLE: {
                return ImmutableVariableRecordValue.class;
            }
            case VARIABLE_DOCUMENT: {
                return ImmutableVariableDocumentRecordValue.class;
            }
            case PROCESS_INSTANCE_CREATION: {
                return ImmutableProcessInstanceCreationRecordValue.class;
            }
            case ERROR: {
                return ImmutableErrorRecordValue.class;
            }
            case PROCESS_INSTANCE_RESULT: {
                return ImmutableProcessInstanceResultRecordValue.class;
            }
            case PROCESS_EVENT: {
                return ImmutableProcessEventRecordValue.class;
            }
            case PROCESS: {
                return ImmutableProcess.class;
            }
            case DEPLOYMENT_DISTRIBUTION: {
                return ImmutableDeploymentDistributionRecordValue.class;
            }
        }
        throw new IllegalArgumentException("Unknown value type " + valueType);
    }
}

