/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.immutables.record.value.deployment;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource;
import io.zeebe.protocol.immutables.record.value.deployment.AbstractDeploymentResource;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractDeploymentResource", generator="Immutables")
public final class ImmutableDeploymentResource
extends AbstractDeploymentResource {
    private final byte[] resource;
    private final String resourceName;
    private final transient int hashCode;

    private ImmutableDeploymentResource(byte[] resource, String resourceName) {
        this.resource = resource;
        this.resourceName = resourceName;
        this.hashCode = this.computeHashCode();
    }

    @JsonProperty(value="resource")
    public byte[] getResource() {
        return this.resource;
    }

    @JsonProperty(value="resourceName")
    public String getResourceName() {
        return this.resourceName;
    }

    public final ImmutableDeploymentResource withResource(byte ... elements) {
        byte[] newValue = elements == null ? null : (byte[])elements.clone();
        return new ImmutableDeploymentResource(newValue, this.resourceName);
    }

    public final ImmutableDeploymentResource withResourceName(String value) {
        if (Objects.equals(this.resourceName, value)) {
            return this;
        }
        return new ImmutableDeploymentResource(this.resource, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeploymentResource && this.equalTo(0, (ImmutableDeploymentResource)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeploymentResource another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return Arrays.equals(this.resource, another.resource) && Objects.equals(this.resourceName, another.resourceName);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.resource);
        h += (h << 5) + Objects.hashCode(this.resourceName);
        return h;
    }

    public String toString() {
        return "DeploymentResource{resource=" + Arrays.toString(this.resource) + ", resourceName=" + this.resourceName + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDeploymentResource fromJson(Json json) {
        Builder builder = ImmutableDeploymentResource.builder();
        if (json.resource != null) {
            builder.resource(json.resource);
        }
        if (json.resourceName != null) {
            builder.resourceName(json.resourceName);
        }
        return builder.build();
    }

    public static ImmutableDeploymentResource copyOf(AbstractDeploymentResource instance) {
        if (instance instanceof ImmutableDeploymentResource) {
            return (ImmutableDeploymentResource)instance;
        }
        return ImmutableDeploymentResource.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AbstractDeploymentResource", generator="Immutables")
    public static final class Builder {
        private byte[] resource;
        private String resourceName;

        private Builder() {
        }

        public final Builder from(DeploymentResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractDeploymentResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof DeploymentResource) {
                String resourceNameValue;
                DeploymentResource instance = (DeploymentResource)object;
                byte[] resourceValue = instance.getResource();
                if (resourceValue != null) {
                    this.resource(resourceValue);
                }
                if ((resourceNameValue = instance.getResourceName()) != null) {
                    this.resourceName(resourceNameValue);
                }
            }
        }

        public final Builder resource(byte ... resource) {
            this.resource = resource;
            return this;
        }

        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public Builder clear() {
            this.resource = null;
            this.resourceName = null;
            return this;
        }

        public ImmutableDeploymentResource build() {
            return new ImmutableDeploymentResource(this.resource, this.resourceName);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractDeploymentResource", generator="Immutables")
    static final class Json
    extends AbstractDeploymentResource {
        byte[] resource;
        String resourceName;

        Json() {
        }

        @JsonProperty(value="resource")
        public void setResource(byte[] resource) {
            this.resource = resource;
        }

        @JsonProperty(value="resourceName")
        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public byte[] getResource() {
            throw new UnsupportedOperationException();
        }

        public String getResourceName() {
            throw new UnsupportedOperationException();
        }
    }
}

