/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.immutables.record.value.deployment;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.zeebe.protocol.immutables.record.value.deployment.AbstractProcessMetadata;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AbstractProcessMetadata", generator="Immutables")
public final class ImmutableProcessMetadata
extends AbstractProcessMetadata {
    private final String bpmnProcessId;
    private final int version;
    private final long processDefinitionKey;
    private final String resourceName;
    private final byte[] checksum;
    private final transient int hashCode;

    private ImmutableProcessMetadata(String bpmnProcessId, int version, long processDefinitionKey, String resourceName, byte[] checksum) {
        this.bpmnProcessId = bpmnProcessId;
        this.version = version;
        this.processDefinitionKey = processDefinitionKey;
        this.resourceName = resourceName;
        this.checksum = checksum;
        this.hashCode = this.computeHashCode();
    }

    @JsonProperty(value="bpmnProcessId")
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @JsonProperty(value="version")
    public int getVersion() {
        return this.version;
    }

    @JsonProperty(value="processDefinitionKey")
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @JsonProperty(value="resourceName")
    public String getResourceName() {
        return this.resourceName;
    }

    @JsonProperty(value="checksum")
    public byte[] getChecksum() {
        return this.checksum;
    }

    public final ImmutableProcessMetadata withBpmnProcessId(String value) {
        if (Objects.equals(this.bpmnProcessId, value)) {
            return this;
        }
        return new ImmutableProcessMetadata(value, this.version, this.processDefinitionKey, this.resourceName, this.checksum);
    }

    public final ImmutableProcessMetadata withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableProcessMetadata(this.bpmnProcessId, value, this.processDefinitionKey, this.resourceName, this.checksum);
    }

    public final ImmutableProcessMetadata withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableProcessMetadata(this.bpmnProcessId, this.version, value, this.resourceName, this.checksum);
    }

    public final ImmutableProcessMetadata withResourceName(String value) {
        if (Objects.equals(this.resourceName, value)) {
            return this;
        }
        return new ImmutableProcessMetadata(this.bpmnProcessId, this.version, this.processDefinitionKey, value, this.checksum);
    }

    public final ImmutableProcessMetadata withChecksum(byte ... elements) {
        byte[] newValue = elements == null ? null : (byte[])elements.clone();
        return new ImmutableProcessMetadata(this.bpmnProcessId, this.version, this.processDefinitionKey, this.resourceName, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessMetadata && this.equalTo(0, (ImmutableProcessMetadata)another);
    }

    private boolean equalTo(int synthetic, ImmutableProcessMetadata another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.version == another.version && this.processDefinitionKey == another.processDefinitionKey && Objects.equals(this.resourceName, another.resourceName) && Arrays.equals(this.checksum, another.checksum);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.bpmnProcessId);
        h += (h << 5) + this.version;
        h += (h << 5) + Long.hashCode(this.processDefinitionKey);
        h += (h << 5) + Objects.hashCode(this.resourceName);
        h += (h << 5) + Arrays.hashCode(this.checksum);
        return h;
    }

    public String toString() {
        return "ProcessMetadata{bpmnProcessId=" + this.bpmnProcessId + ", version=" + this.version + ", processDefinitionKey=" + this.processDefinitionKey + ", resourceName=" + this.resourceName + ", checksum=" + Arrays.toString(this.checksum) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableProcessMetadata fromJson(Json json) {
        Builder builder = ImmutableProcessMetadata.builder();
        if (json.bpmnProcessId != null) {
            builder.bpmnProcessId(json.bpmnProcessId);
        }
        if (json.versionIsSet) {
            builder.version(json.version);
        }
        if (json.processDefinitionKeyIsSet) {
            builder.processDefinitionKey(json.processDefinitionKey);
        }
        if (json.resourceName != null) {
            builder.resourceName(json.resourceName);
        }
        if (json.checksum != null) {
            builder.checksum(json.checksum);
        }
        return builder.build();
    }

    public static ImmutableProcessMetadata copyOf(AbstractProcessMetadata instance) {
        if (instance instanceof ImmutableProcessMetadata) {
            return (ImmutableProcessMetadata)instance;
        }
        return ImmutableProcessMetadata.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AbstractProcessMetadata", generator="Immutables")
    public static final class Builder {
        private String bpmnProcessId;
        private int version;
        private long processDefinitionKey;
        private String resourceName;
        private byte[] checksum;

        private Builder() {
        }

        public final Builder from(ProcessMetadataValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractProcessMetadata instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof ProcessMetadataValue) {
                String bpmnProcessIdValue;
                String resourceNameValue;
                ProcessMetadataValue instance = (ProcessMetadataValue)object;
                byte[] checksumValue = instance.getChecksum();
                if (checksumValue != null) {
                    this.checksum(checksumValue);
                }
                if ((resourceNameValue = instance.getResourceName()) != null) {
                    this.resourceName(resourceNameValue);
                }
                if ((bpmnProcessIdValue = instance.getBpmnProcessId()) != null) {
                    this.bpmnProcessId(bpmnProcessIdValue);
                }
                this.version(instance.getVersion());
                this.processDefinitionKey(instance.getProcessDefinitionKey());
            }
        }

        public final Builder bpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
            return this;
        }

        public final Builder version(int version) {
            this.version = version;
            return this;
        }

        public final Builder processDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final Builder checksum(byte ... checksum) {
            this.checksum = checksum;
            return this;
        }

        public Builder clear() {
            this.bpmnProcessId = null;
            this.version = 0;
            this.processDefinitionKey = 0L;
            this.resourceName = null;
            this.checksum = null;
            return this;
        }

        public ImmutableProcessMetadata build() {
            return new ImmutableProcessMetadata(this.bpmnProcessId, this.version, this.processDefinitionKey, this.resourceName, this.checksum);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractProcessMetadata", generator="Immutables")
    static final class Json
    extends AbstractProcessMetadata {
        String bpmnProcessId;
        int version;
        boolean versionIsSet;
        long processDefinitionKey;
        boolean processDefinitionKeyIsSet;
        String resourceName;
        byte[] checksum;

        Json() {
        }

        @JsonProperty(value="bpmnProcessId")
        public void setBpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
        }

        @JsonProperty(value="version")
        public void setVersion(int version) {
            this.version = version;
            this.versionIsSet = true;
        }

        @JsonProperty(value="processDefinitionKey")
        public void setProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            this.processDefinitionKeyIsSet = true;
        }

        @JsonProperty(value="resourceName")
        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @JsonProperty(value="checksum")
        public void setChecksum(byte[] checksum) {
            this.checksum = checksum;
        }

        public String getBpmnProcessId() {
            throw new UnsupportedOperationException();
        }

        public int getVersion() {
            throw new UnsupportedOperationException();
        }

        public long getProcessDefinitionKey() {
            throw new UnsupportedOperationException();
        }

        public String getResourceName() {
            throw new UnsupportedOperationException();
        }

        public byte[] getChecksum() {
            throw new UnsupportedOperationException();
        }
    }
}

