/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.okhttp3;

import java.io.IOException;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import zipkin2.Call;
import zipkin2.Callback;

final class HttpCall
extends Call<Void> {
    final okhttp3.Call call;

    HttpCall(okhttp3.Call call) {
        this.call = call;
    }

    public Void execute() throws IOException {
        HttpCall.parseResponse(this.call.execute());
        return null;
    }

    public void enqueue(Callback<Void> delegate) {
        this.call.enqueue(new V2CallbackAdapter<Void>(delegate));
    }

    public void cancel() {
        this.call.cancel();
    }

    public boolean isCanceled() {
        return this.call.isCanceled();
    }

    public HttpCall clone() {
        return new HttpCall(this.call.clone());
    }

    static void parseResponse(Response response) throws IOException {
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            if (response.isSuccessful()) {
                return;
            }
            throw new RuntimeException("response failed: " + response);
        }
        try {
            BufferedSource content = responseBody.source();
            if ("gzip".equalsIgnoreCase(response.header("Content-Encoding"))) {
                content = Okio.buffer((Source)new GzipSource((Source)responseBody.source()));
            }
            if (!response.isSuccessful()) {
                throw new RuntimeException("response for " + response.request().tag() + " failed: " + content.readUtf8());
            }
        }
        finally {
            responseBody.close();
        }
    }

    static class V2CallbackAdapter<V>
    implements okhttp3.Callback {
        final Callback<V> delegate;

        V2CallbackAdapter(Callback<V> delegate) {
            this.delegate = delegate;
        }

        public void onFailure(okhttp3.Call call, IOException e) {
            this.delegate.onError((Throwable)e);
        }

        public void onResponse(okhttp3.Call call, Response response) {
            try {
                HttpCall.parseResponse(response);
                this.delegate.onSuccess(null);
            }
            catch (Throwable e) {
                Call.propagateIfFatal((Throwable)e);
                this.delegate.onError(e);
            }
        }
    }
}

