/*
 * Decompiled with CFR 0.152.
 */
package app.mysql.explain.component;

import app.mysql.explain.config.DbToolConfig;
import app.mysql.explain.config.DynamicDataSourceContextHolder;
import app.mysql.explain.config.DynamicRoutingDataSource;
import app.mysql.explain.controller.SessionContext;
import app.mysql.explain.model.DataSourceModel;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.product.annotation.VerificationImpl;
import com.product.component.JDBCCompomentServiceImpl;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.DbConnection;
import com.product.util.ServiceComUtil;
import com.product.util.UniqueID;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class DataSourceServieImpl
extends JDBCCompomentServiceImpl<DataSourceModel> {
    private static final Logger log = LoggerFactory.getLogger(DataSourceServieImpl.class);
    protected static final Logger logger = LoggerFactory.getLogger(DataSourceServieImpl.class);
    @Autowired
    SessionContext sessionContext;
    @Autowired
    RedisConnectionFactory connectionFactory;
    @Autowired
    @Qualifier(value="dynamicDataSource")
    private DynamicRoutingDataSource dynamicDataSource;
    @Autowired
    @Qualifier(value="jdbcMainTemplate")
    private JdbcTemplate jdbcTemplate;
    @Autowired
    @Qualifier(value="dynamicTemplate")
    private JdbcTemplate dynamicJdbcTemplate;
    @Autowired
    @Qualifier(value="jdbcMainTemplate")
    JdbcTemplate jdbcTemplateMain;

    public DataSourceServieImpl(FMybatisTemplate mybatisTemplate, String collectionName, String keyfieldName) {
        super(mybatisTemplate, collectionName, keyfieldName);
    }

    public ServiceResponse onQuery(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse sr = super.onQuery(session, paramsObject);
        return sr;
    }

    public ServiceResponse onQueryDbMenu(ServiceSession session, JSONObject paramsObject) {
        String sql = "select code,name from datasource";
        List list = this.jdbcTemplate.queryForList(sql);
        return ServiceResponse.buildSuccess((Object)list);
    }

    public ServiceResponse onQueryTables(ServiceSession session, JSONObject paramsObject) {
        String code = paramsObject.getString("code");
        try {
            VerificationImpl.onExistValidator((JSONObject)paramsObject, (String)"code:\u5e93\u540d");
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50000", (String)e.getMessage());
        }
        DynamicDataSourceContextHolder.setDataSourceKey((String)code);
        this.setUseEntID(false);
        DataSourceModel dataSourceModel = (DataSourceModel)ServiceComUtil.getT((JDBCCompomentServiceImpl)this, (ServiceSession)session, (JSONObject)paramsObject);
        if (dataSourceModel != null) {
            String db = dataSourceModel.getDb();
            String sql = "select table_name TABLE_NAME, table_comment COMMENTS from information_schema.tables where table_schema='" + db + "' and table_type='base table'".toUpperCase();
            List list = this.dynamicJdbcTemplate.queryForList(sql);
            return ServiceResponse.buildSuccess((Object)list);
        }
        return ServiceResponse.buildFailure((ServiceSession)session, (String)"50005");
    }

    public ServiceResponse onQueryTableInfo(ServiceSession session, JSONObject paramsObject) {
        String code = paramsObject.getString("code");
        String tableName = paramsObject.getString("tableName");
        try {
            VerificationImpl.onExistValidator((JSONObject)paramsObject, (String)"code:\u5e93\u540d;tableName:\u8868\u540d");
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50000", (String)e.getMessage());
        }
        this.sessionContext.setDatabaseCode(code);
        DynamicDataSourceContextHolder.setDataSourceKey((String)code);
        this.setUseEntID(false);
        String sql = "show create table " + tableName;
        List list = this.dynamicJdbcTemplate.queryForList(sql);
        return ServiceResponse.buildSuccess((Object)list);
    }

    public ServiceResponse onNew(ServiceSession session, JSONObject paramsObject) {
        try {
            VerificationImpl.onExistValidator((JSONObject)paramsObject, (String)"ip:ip\u5730\u5740;port:\u7aef\u53e3;username:\u7528\u6237\u540d;password:\u5bc6\u7801;db:\u5e93\u540d;dbType:\u6570\u636e\u5e93\u7c7b\u578b");
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50000", (String)e.getMessage());
        }
        JSONObject jsonCode = new JSONObject();
        String code = paramsObject.getString("code");
        jsonCode.put("code", paramsObject.get((Object)"code"));
        this.setUseEntID(false);
        List list = ServiceComUtil.listT((JDBCCompomentServiceImpl)this, (ServiceSession)session, (JSONObject)jsonCode);
        if (list.size() > 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50000", (String)String.format("\u6570\u636e\u5e93\u7f16\u7801[%s]\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d", code));
        }
        long sid = UniqueID.getUniqueID();
        paramsObject.put(this.getKeyfieldName(), (Object)sid);
        String currentDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        paramsObject.put("creator", (Object)session.getUser_name());
        paramsObject.put("createDate", (Object)currentDate);
        paramsObject.put("modifier", (Object)session.getUser_name());
        paramsObject.put("updateDate", (Object)currentDate);
        this.reloadDataSource(paramsObject);
        return this.onInsert(session, paramsObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceResponse onTestCon(ServiceSession session, JSONObject paramsObject) throws Exception {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block9: {
            ServiceResponse serviceResponse;
            block8: {
                connection = null;
                statement = null;
                resultSet = null;
                try {
                    VerificationImpl.onExistValidator((JSONObject)paramsObject, (String)"code:\u6570\u636e\u5e93\u7f16\u53f7;ip:ip\u5730\u5740;port:\u7aef\u53e3;username:\u7528\u6237\u540d;password:\u5bc6\u7801;db:\u5e93\u540d;dbType:\u6570\u636e\u5e93\u7c7b\u578b");
                }
                catch (Exception e) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"50000", (String)e.getMessage());
                }
                try {
                    DataSourceModel sourceModel = (DataSourceModel)JSON.toJavaObject((JSON)paramsObject, DataSourceModel.class);
                    String jdbcUrl = "jdbc:mysql://" + sourceModel.getIp() + ":" + sourceModel.getPort() + "/" + sourceModel.getDb();
                    connection = DbConnection.getConn((String)jdbcUrl, (String)sourceModel.getUsername(), (String)sourceModel.getPassword(), (String)"com.mysql.jdbc.Driver");
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery("select 1");
                    if (resultSet.next()) {
                        serviceResponse = ServiceResponse.buildSuccess((Object)"\u94fe\u63a5\u6210\u529f");
                        DbConnection.closeRs((ResultSet)resultSet);
                        break block8;
                    }
                    DbConnection.closeRs((ResultSet)resultSet);
                    break block9;
                }
                catch (Exception e) {
                    logger.error("\u53d1\u751f\u9519\u8bef = {}", (Throwable)e);
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"50005", (String)"\u6570\u636e\u5e93\u94fe\u63a5\u5931\u8d25");
                }
            }
            DbConnection.closeStat((Statement)statement);
            DbConnection.closeConn((Connection)connection);
            return serviceResponse;
        }
        DbConnection.closeStat((Statement)statement);
        DbConnection.closeConn((Connection)connection);
        return ServiceResponse.buildFailure((ServiceSession)session, (String)"50005", (String)"\u6570\u636e\u5e93\u94fe\u63a5\u5931\u8d25");
        finally {
            DbConnection.closeRs(resultSet);
            DbConnection.closeStat(statement);
            DbConnection.closeConn(connection);
        }
    }

    public void reloadDataSource(JSONObject paramsObject) {
        DataSourceModel sourceModel = (DataSourceModel)JSON.toJavaObject((JSON)paramsObject, DataSourceModel.class);
        DbToolConfig toolConfig = new DbToolConfig();
        ServiceSession session = new ServiceSession();
        this.setUseEntID(false);
        List list = ServiceComUtil.listT((JDBCCompomentServiceImpl)this, (ServiceSession)session, (JSONObject)new JSONObject());
        list.add(sourceModel);
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
        for (DataSourceModel dataSourceModel : list) {
            DataSource dataSource = toolConfig.createDateSource(dataSourceModel);
            if (dataSource == null) continue;
            dataSourceMap.put(dataSourceModel.getCode(), dataSource);
            logger.info("\u52a0\u8f7d\u6570\u636e\u6e90[{}]", (Object)dataSourceModel.toString());
        }
        DynamicDataSourceContextHolder.dataSourceKeys.clear();
        DynamicDataSourceContextHolder.dataSourceKeys.addAll(dataSourceMap.keySet());
        this.dynamicDataSource.setTargetDataSources(dataSourceMap);
        this.dynamicDataSource.afterPropertiesSet();
    }

    public ServiceResponse onDelete(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse response = super.onDelete(session, paramsObject);
        return response;
    }

    public ServiceResponse onSave(ServiceSession session, JSONObject paramsObject) {
        String currentDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        paramsObject.put("updateDate", (Object)currentDate);
        paramsObject.put("modifier", (Object)session.getUser_name());
        return this.onUpdate(session, paramsObject);
    }

    protected Document onBeforeRowInsert(Query query, Update update) {
        return null;
    }

    public ServiceResponse generateMycatSchemal(ServiceSession session, JSONObject paramsObject) {
        List list = this.jdbcTemplateMain.queryForList("select * from datasource");
        StringBuffer headBuffer = new StringBuffer();
        StringBuffer bodyBuffer = new StringBuffer();
        StringBuffer dataNodeBuffer = new StringBuffer();
        headBuffer.append("<?xml version=\"1.0\"?>\r\n");
        headBuffer.append("<!DOCTYPE mycat:schema SYSTEM \"schema.dtd\">\r\n");
        headBuffer.append("<mycat:schema xmlns:mycat=\"http://io.mycat/\">\r\n");
        for (Map model : list) {
            String code = model.get("code").toString();
            DynamicDataSourceContextHolder.setDataSourceKey((String)code);
            String db = model.get("db").toString();
            String sql = "show tables";
            List tableList = this.dynamicJdbcTemplate.queryForList(sql);
            bodyBuffer.append("  <schema name=\"" + db + "\" checkSQLschema=\"true\" sqlMaxLimit=\"100000\" dataNode=\"" + db + "-10000000000006y\">");
            bodyBuffer.append("\r\n");
            for (Map map : tableList) {
                String tableName = (String)map.entrySet().iterator().next().getValue();
                bodyBuffer.append("    <table name=\"" + tableName + "\" dataNode=\"" + db + "-10000000000005y\" />");
                bodyBuffer.append("\r\n");
            }
            bodyBuffer.append("  </schema>");
            bodyBuffer.append("\r\n");
            dataNodeBuffer.append("  <dataNode name=\"" + db + "-10000000000005y\" dataHost=\"FP-10000000000005\" database=\"" + db + "\" />");
            dataNodeBuffer.append("\r\n");
            dataNodeBuffer.append("  <dataNode name=\"" + db + "-10000000000006y\" dataHost=\"FP-10000000000006\" database=\"" + db + "\" />");
            dataNodeBuffer.append("\r\n");
        }
        logger.info(headBuffer.toString() + "\r\n" + bodyBuffer.toString() + "\r\n" + dataNodeBuffer.toString() + "\r\n</mycat:schema>");
        return ServiceResponse.buildSuccess((Object)"OK");
    }
}

