/*
 * Decompiled with CFR 0.152.
 */
package app.mysql.explain.component;

import app.mysql.explain.enums.MicroBaseVersion;
import app.mysql.explain.file.FileComponent;
import app.mysql.explain.model.NacosConfigModel;
import app.mysql.explain.utils.CMDUtils;
import app.mysql.explain.utils.FreemarkerUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.product.util.RestUtils;
import com.product.util.TypeUtils;
import com.shiji.core.util.ParserUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class MavenProjectServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(MavenProjectServiceImpl.class);
    String uiConfig = null;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private FileComponent fileComponent;
    @Autowired
    protected ResourceLoader resourceLoader = new DefaultResourceLoader();

    public JSONArray initMavenProjectConfig() throws Exception {
        JSONObject item;
        JSONArray props;
        List verList;
        String uiConfig = this.getUIConfig();
        JSONArray array = JSONArray.parseArray((String)uiConfig);
        List baseList = array.stream().filter(e -> TypeUtils.toJSONObj((Object)e, (boolean)false, (SerializerFeature[])new SerializerFeature[0]).get((Object)"group").equals("base")).collect(Collectors.toList());
        MicroBaseVersion microBaseVer = null;
        if (!baseList.isEmpty() && !(verList = (props = (item = TypeUtils.toJSONObj(baseList.get(0), (boolean)false, (SerializerFeature[])new SerializerFeature[0])).getJSONArray("items")).stream().filter(e -> TypeUtils.toJSONObj((Object)e, (boolean)false, (SerializerFeature[])new SerializerFeature[0]).get((Object)"field").equals("microBaseVersion")).collect(Collectors.toList())).isEmpty() && TypeUtils.toJSONObj(verList.get(0), (boolean)false, (SerializerFeature[])new SerializerFeature[0]).containsKey((Object)"defaultValue")) {
            JSONObject json = TypeUtils.toJSONObj(verList.get(0), (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
            String defaultValue = json.get((Object)"defaultValue").toString();
            microBaseVer = MicroBaseVersion.getByVersionMemo((String)defaultValue);
        }
        if (StringUtils.isEmpty(microBaseVer)) {
            MicroBaseVersion[] microBaseVersionList = MicroBaseVersion.values();
            microBaseVer = microBaseVersionList[microBaseVersionList.length - 1];
        }
        JSONArray commArray = this.filterByType(array, "common");
        JSONArray verArray = this.filterByType(array, microBaseVer.getType());
        return commArray.fluentAdd((Object)verArray);
    }

    public String getUIConfig() throws Exception {
        this.uiConfig = null;
        if (this.uiConfig == null) {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("baseVersiontTemplate.json");
            this.uiConfig = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining(System.lineSeparator()));
        }
        return this.uiConfig;
    }

    public JSONArray filterByType(JSONArray array, String type) {
        JSONArray returnarray = new JSONArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject json = array.getJSONObject(i);
            if (!type.equals(json.get((Object)"type")) && !type.equals(json.get((Object)"type"))) continue;
            returnarray.add((Object)json);
        }
        return returnarray;
    }

    public JSONArray changeBaseVer(String microBaseVersionMemo) throws Exception {
        MicroBaseVersion version = MicroBaseVersion.getByVersionMemo((String)microBaseVersionMemo);
        String uiConfig = this.getUIConfig();
        JSONArray array = JSONArray.parseArray((String)uiConfig);
        JSONArray returnarray = this.filterByType(array, version.getType());
        return returnarray;
    }

    public JSONArray get(String microBaseVersion, String type) throws Exception {
        MicroBaseVersion version = MicroBaseVersion.getByVersionId((String)microBaseVersion, (String)type);
        String uiConfig = this.getUIConfig();
        JSONArray array = JSONArray.parseArray((String)uiConfig);
        JSONArray returnarray = new JSONArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject json = array.getJSONObject(i);
            if (!type.equals(json.get((Object)"type")) && !"common".equals(json.get((Object)"type"))) continue;
            returnarray.add((Object)json);
        }
        return returnarray;
    }

    public String generateEmptyProject(JSONObject paramsObject) throws Exception {
        String groupId = paramsObject.get((Object)"groupId").toString();
        String artifactId = paramsObject.get((Object)"artifactId").toString();
        String versionId = paramsObject.get((Object)"versionId").toString();
        String downloadUrl = this.getEmptyProjectByFreeMarkerTemplate(paramsObject);
        return downloadUrl;
    }

    public String mvnEmptyProject(String groupId, String artifactId, String versionId) throws Exception {
        String templateVersionId = "";
        String path = this.fileComponent.getFileStoreDir();
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("cd " + path);
        commands.add("rm -rf " + artifactId + "/");
        commands.add("mvn org.apache.maven.plugins:maven-archetype-plugin:2.4:generate -DgroupId=" + groupId + " -DartifactId=" + artifactId + " -Dversion=" + versionId + " -Dpackagin=jar -Dpackage=com -DinteractiveMode=false -DarchetypeGroupId=com.shiji -DarchetypeArtifactId=ftMicroNormal-archetype -DarchetypeCatalog=http://maven.sjhgo.com:8081/nexus/content/repositories/efuture-omni/archetype-catalog.xml");
        CMDUtils.execLinuxCMDFlow(commands);
        this.fileComponent.toZip(path + "/" + artifactId);
        String fileName = String.format("%1$s.zip", artifactId);
        String downloadURL = String.format("%1$s://%2$s:%3$d/explain/download/%4$s", this.request.getScheme(), this.request.getServerName(), this.request.getServerPort(), fileName);
        this.fileComponent.deleteFileFolder(path + "/" + artifactId);
        return downloadURL;
    }

    private String getEmptyProjectByFreeMarkerTemplate(JSONObject paramsObject) throws Exception {
        String artifactId = paramsObject.get((Object)"artifactId").toString();
        String microBaseVersion = paramsObject.get((Object)"microBaseVersion").toString();
        MicroBaseVersion version = MicroBaseVersion.getByVersionMemo((String)microBaseVersion);
        paramsObject.put("microBaseVersion", (Object)version.getVersionId());
        paramsObject.put("mode", (Object)version.getType());
        if (paramsObject.containsKey((Object)"nacosIds")) {
            List dataIds = (List)paramsObject.getObject("nacosIds", List.class);
            paramsObject.put("nacosIds", (Object)dataIds.stream().map(e -> e.toString()).collect(Collectors.joining(",")));
        }
        String tmpStorePath = this.fileComponent.getFileStoreDir();
        String filefolder = tmpStorePath + "/" + artifactId;
        this.fileComponent.deleteFileFolder(filefolder);
        this.fileComponent.createFolder(filefolder);
        URL url = this.getClass().getClassLoader().getResource("templates/project-generator");
        if (url.toString().contains(".jar")) {
            String jarpath = url.toString().substring(0, url.toString().indexOf("!/") + 2);
            String prefix = "BOOT-INF/classes/templates/project-generator";
            this.handleTemplateResourceByJar(jarpath, prefix, paramsObject, filefolder);
        } else {
            this.handleTemplateResourceByFile(url, paramsObject, filefolder);
        }
        this.fileComponent.saveFile(filefolder + "/.gitignore", this.gitignoreContent());
        this.fileComponent.toZip(filefolder);
        String fileName = String.format("%1$s.zip", artifactId);
        String downloadURL = String.format("%1$s://%2$s:%3$d/explain/download/%4$s", this.request.getScheme(), this.request.getServerName(), this.request.getServerPort(), fileName);
        this.fileComponent.deleteFileFolder(filefolder);
        return downloadURL;
    }

    public void handleTemplateResourceByFile(URL url, JSONObject paramsObject, String tmpfilefolder) throws Exception {
        String path = url.getPath();
        File file = new File(path);
        if (file.isDirectory()) {
            this.generateFileFolder(file, paramsObject, tmpfilefolder);
        }
    }

    public void handleTemplateResourceByJar(String jarpath, String prefix, JSONObject jsonparam, String newDir) throws Exception {
        URL jarUrl = new URL(jarpath);
        JarURLConnection jarConn = (JarURLConnection)jarUrl.openConnection();
        JarFile jarFiles = jarConn.getJarFile();
        Enumeration<JarEntry> entries = jarFiles.entries();
        ArrayList<JarEntry> list = new ArrayList<JarEntry>();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(prefix + "/")) continue;
            list.add(entry);
        }
        JarEntry parent = this.getParentEntry(list, prefix);
        this.handleJarEntry(jarFiles, parent, list, jsonparam, newDir);
        jarFiles.close();
    }

    public void handleJarEntry(JarFile jarFiles, JarEntry parent, List<JarEntry> entries, JSONObject jsonparam, String newDir) throws Exception {
        if (parent.isDirectory()) {
            List childs = this.getChildEntries(parent, entries);
            for (JarEntry entry : childs) {
                String filepath = newDir;
                if (entry.isDirectory()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("packageName", jsonparam.getString("packageName"));
                    String[] f = entry.getName().split("/");
                    String folderName = f[f.length - 1];
                    String filename = ParserUtils.parseNameHolder((String)"${", (String)"}", (String)folderName, map);
                    String folderpath = newDir + "/" + filename.replace(".", "/");
                    this.fileComponent.createFolder(folderpath);
                    filepath = newDir + "/" + filename.replace(".", "/");
                    this.handleJarEntry(jarFiles, entry, entries, jsonparam, filepath);
                    continue;
                }
                String[] f = entry.getName().split("/");
                String filename = f[f.length - 1];
                if (filename.endsWith("ftl")) {
                    this.fileComponent.copyFile(newDir + "/" + filename, jarFiles.getInputStream(entry));
                    String content = FreemarkerUtil.genarateByTemplatePath((JSONObject)jsonparam, (String)filename, (String)newDir);
                    this.fileComponent.saveFile(newDir + "/" + filename.substring(0, filename.length() - 3), content);
                    this.fileComponent.deleteFile(newDir + "/" + filename);
                    continue;
                }
                this.fileComponent.copyFile(newDir + "/" + filename, jarFiles.getInputStream(entry));
            }
        }
    }

    public JarEntry getParentEntry(List<JarEntry> entries, String prefix) {
        return (JarEntry)entries.stream().filter(e -> e.getName().equals(prefix + "/")).collect(Collectors.toList()).get(0);
    }

    public List<JarEntry> getChildEntries(JarEntry parent, List<JarEntry> entries) {
        if (parent.isDirectory()) {
            int length = parent.getName().length();
            List<JarEntry> childs = entries.stream().filter(e -> e.getName().startsWith(parent.getName()) && !e.getName().equals(parent.getName()) && e.getName().substring(length).split("/").length <= 1).collect(Collectors.toList());
            return childs;
        }
        return null;
    }

    public JSONArray getBaseVersionList() {
        JSONArray jsonarray = new JSONArray();
        for (MicroBaseVersion version : MicroBaseVersion.values()) {
            JSONObject json = new JSONObject();
            json.put("versionId", (Object)version.versionId);
            json.put("versionMemo", (Object)version.versionMemo);
            json.put("microBaseVersionType", (Object)version.type);
            jsonarray.add((Object)json);
        }
        return jsonarray;
    }

    public void generateFileFolder(File file, JSONObject jsonparam, String newDir) throws Exception {
        if (file.isDirectory()) {
            String[] list;
            for (String s : list = file.list()) {
                String filepath = newDir;
                File f = new File(file.getPath() + "/" + s);
                if (f.isDirectory()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("packageName", jsonparam.getString("packageName"));
                    String filename = ParserUtils.parseNameHolder((String)"${", (String)"}", (String)f.getName(), map);
                    this.fileComponent.createFolder(newDir + "/" + filename.replace(".", "/"));
                    filepath = newDir + "/" + filename.replace(".", "/");
                    this.generateFileFolder(f, jsonparam, filepath);
                    continue;
                }
                if (!f.isFile()) continue;
                if (f.getName().endsWith("ftl")) {
                    String content = FreemarkerUtil.genarateByTemplatePath((JSONObject)jsonparam, (String)f.getName(), (String)f.getParent());
                    this.fileComponent.saveFile(newDir + "/" + f.getName().substring(0, f.getName().length() - 3), content);
                    continue;
                }
                this.fileComponent.copyFile(newDir + "/" + f.getName(), f);
            }
        }
    }

    public void getNacosConfigs() throws Exception {
    }

    public List<Object> getNacosNamespaces(JSONObject jsonparam) throws Exception {
        NacosConfigModel config = (NacosConfigModel)TypeUtils.toJavaObject((JSON)jsonparam, NacosConfigModel.class);
        return this.getNacosNamespaces(config);
    }

    public List<Object> getNacosNamespaces(NacosConfigModel config) throws Exception {
        String resp = RestUtils.doGet((String)(config.getNacosAddr() + "/nacos/v1/console/namespaces?username=" + config.getNacosUser() + "&password=" + config.getNacosPwd()));
        JSONObject response = JSONObject.parseObject((String)resp);
        if (response.containsKey((Object)"code")) {
            if ("200".equals(response.get((Object)"code").toString())) {
                JSONArray array = response.getJSONArray("data");
                List list = array.stream().map(e -> TypeUtils.toJSONObj((Object)e, (boolean)false, (SerializerFeature[])new SerializerFeature[0]).get((Object)"namespaceShowName")).collect(Collectors.toList());
                return this.filterNameSpace(list, config);
            }
            throw new Exception(response.get((Object)"message").toString());
        }
        throw new Exception("\u83b7\u53d6\u547d\u540d\u7a7a\u95f4\u5217\u8868\u5931\u8d25");
    }

    public List<Object> filterNameSpace(List<Object> list, NacosConfigModel config) throws Exception {
        String url = config.getNacosAddr() + "/nacos/v1/cs/configs?dataId=&group=&appName=&config_tags=&pageNo=1&pageSize=100&search=accurate&username=" + config.getNacosUser() + "&password=" + config.getNacosPwd();
        ArrayList<Object> rtnList = new ArrayList<Object>();
        for (Object obj : list) {
            try {
                RestUtils.doGet((String)(url + "&tenant=" + obj.toString()));
                rtnList.add(obj);
            }
            catch (Exception exception) {}
        }
        return rtnList;
    }

    public List<Object> getNacosDataIds(JSONObject jsonparam) throws Exception {
        NacosConfigModel config = (NacosConfigModel)TypeUtils.toJavaObject((JSON)jsonparam, NacosConfigModel.class);
        return this.getNacosDataIds(config);
    }

    public List<Object> getNacosDataIds(NacosConfigModel config) throws Exception {
        String resp;
        JSONObject response;
        String url = config.getNacosAddr() + "/nacos/v1/cs/configs?dataId=&appName=&config_tags=&pageNo=1&pageSize=100&search=accurate&username=" + config.getNacosUser() + "&password=" + config.getNacosPwd() + "&tenant=" + config.getNacosNs();
        if (!StringUtils.isEmpty((Object)config.getNacosGroup())) {
            url = url + "&group=" + config.getNacosGroup();
        }
        if ((response = JSONObject.parseObject((String)(resp = RestUtils.doGet((String)url)))).containsKey((Object)"pageItems")) {
            JSONArray array = response.getJSONArray("pageItems");
            return array.stream().map(e -> TypeUtils.toJSONObj((Object)e, (boolean)false, (SerializerFeature[])new SerializerFeature[0]).get((Object)"dataId")).collect(Collectors.toList());
        }
        throw new Exception("\u83b7\u53d6dataId\u5217\u8868\u5931\u8d25");
    }

    public String gitignoreContent() {
        return ".DS_Store\n.idea/\n.gradle/\n/target/\n.classpath\n.classpath/\n.project\n.project/\n.settings\n.settings/\n*.iml\n*.project\n*.class\n*.project\n\ntest/\ntarget/\nlogs/\n.factorypath";
    }
}

