/*
 * Decompiled with CFR 0.152.
 */
package app.mysql.explain.component;

import app.mysql.explain.model.RuleModel;
import app.mysql.explain.utils.ReturnT;
import app.mysql.explain.utils.StringUtil;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlSchemaStatVisitor;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.fastjson.JSONObject;
import com.product.component.JDBCCompomentServiceImpl;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.UniqueID;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.jdbc.core.JdbcTemplate;

public class RuleServiceImpl
extends JDBCCompomentServiceImpl<RuleModel> {
    private static final Logger log = LoggerFactory.getLogger(RuleServiceImpl.class);
    @Autowired
    @Qualifier(value="jdbcMainTemplate")
    private JdbcTemplate jdbcMainTemplate;

    public RuleServiceImpl(FMybatisTemplate mybatisTemplate, String collectionName, String keyfieldName) {
        super(mybatisTemplate, collectionName, keyfieldName);
    }

    protected Document onBeforeRowInsert(Query query, Update update) {
        return null;
    }

    public ServiceResponse onQuery(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse sr = super.onQuery(session, paramsObject);
        return sr;
    }

    public ReturnT auditSql(String sql) {
        List stmtList;
        List types = this.jdbcMainTemplate.queryForList("select a.* from rule as a right join (select typeCode from ruletype where status=1   ) as b on a.typeCode = b.typeCode");
        List rList = StringUtil.ruleKeyValue((String)sql, (List)types);
        if (rList.size() > 0) {
            return ReturnT.define((int)0, (String)"\u5ba1\u8ba1\u5931\u8d25").put(StringUtil.FAIL, (Object)rList);
        }
        try {
            stmtList = SQLUtils.parseStatements((String)sql, (String)"mysql");
        }
        catch (ParserException parseException) {
            return ReturnT.define((int)0, (String)"\u5ba1\u8ba1\u5931\u8d25").put(StringUtil.FAIL, (Object)"SQL \u8bed\u53e5\u683c\u5f0f\u9519\u8bef");
        }
        log.info("\u89e3\u6790\u51fa\u72ec\u7acbsql\u8bed\u53e5\u4e2a\u6570:" + stmtList.size());
        for (SQLStatement stmt : stmtList) {
            MySqlSchemaStatVisitor visitor = new MySqlSchemaStatVisitor();
            stmt.accept((SQLASTVisitor)visitor);
            log.info("Features : " + visitor.getFeatures());
            log.info("Manipulation : " + visitor.getTables());
            log.info("fields : " + visitor.getColumns());
        }
        return ReturnT.define((int)1, (String)"\u5ba1\u8ba1\u901a\u8fc7");
    }

    public ServiceResponse onNew(ServiceSession session, JSONObject paramsObject) {
        long rid = UniqueID.getUniqueID();
        paramsObject.put(this.getKeyfieldName(), (Object)rid);
        String currentDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        paramsObject.put("creator", (Object)session.getUser_name());
        paramsObject.put("createDate", (Object)currentDate);
        paramsObject.put("modifier", (Object)session.getUser_name());
        paramsObject.put("updateDate", (Object)currentDate);
        return this.onInsert(session, paramsObject);
    }

    public ServiceResponse onDelete(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse response = super.onDelete(session, paramsObject);
        return response;
    }

    public ServiceResponse onSave(ServiceSession session, JSONObject paramsObject) {
        String currentDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        paramsObject.put("updateDate", (Object)currentDate);
        paramsObject.put("modifier", (Object)session.getUser_name());
        return this.onUpdate(session, paramsObject);
    }
}

