/*
 * Decompiled with CFR 0.152.
 */
package app.mysql.explain.config;

import app.mysql.explain.component.DataSourceServieImpl;
import app.mysql.explain.component.RuleServiceImpl;
import app.mysql.explain.component.RuleTypeServiceImpl;
import app.mysql.explain.component.SlowLogServiceImpl;
import app.mysql.explain.config.DynamicDataSourceContextHolder;
import app.mysql.explain.config.DynamicRoutingDataSource;
import app.mysql.explain.model.DataSourceModel;
import com.alibaba.fastjson.JSONObject;
import com.product.component.JDBCCompomentServiceImpl;
import com.product.config.BaseConfiger;
import com.product.model.ServiceSession;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.ServiceComUtil;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.mybatis.generator.config.JDBCConnectionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoReactiveAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableAutoConfiguration(exclude={MongoAutoConfiguration.class, MongoDataAutoConfiguration.class, MongoReactiveAutoConfiguration.class})
public class DbToolConfig
extends BaseConfiger {
    protected static final Logger logger = LoggerFactory.getLogger((String)"BaseConfiger");
    @Autowired
    @Qualifier(value="mainStorageOperation")
    FMybatisTemplate mybatisTemplate;

    @Bean
    public RestTemplate restTempldate() {
        return new RestTemplate();
    }

    @Bean(name={"dbtool.datasource"})
    public DataSourceServieImpl onDataSourceServieImpl() {
        return new DataSourceServieImpl(this.mybatisTemplate, "datasource", "sid");
    }

    @Bean(name={"dbtool.rule"})
    public RuleServiceImpl onRuleServiceImpl() {
        return new RuleServiceImpl(this.mybatisTemplate, "rule", "rid");
    }

    @Bean(name={"dbtool.ruletype"})
    public RuleTypeServiceImpl onRuleTypeServiceImpl() {
        return new RuleTypeServiceImpl(this.mybatisTemplate, "ruletype", "tid");
    }

    @Bean(name={"dbtool.slowlog"})
    public SlowLogServiceImpl onSlowLogServiceImpl() {
        return new SlowLogServiceImpl(this.mybatisTemplate, "slowlog", "id");
    }

    private Properties loadProperties(DataSourceModel sourceModel) {
        Properties properties = new Properties();
        String jdbcUrl = "jdbc:mysql://" + sourceModel.getIp() + ":" + sourceModel.getPort() + "/" + sourceModel.getDb();
        properties.setProperty("jdbcUrl", jdbcUrl + "?useSSL=false&serverTimezone=GMT%2B8&useUnicode=true&characterEncoding=utf8&autoReconnect=true&allowMultiQueries=true&useAffectedRows=true");
        properties.setProperty("username", sourceModel.getUsername());
        properties.setProperty("password", sourceModel.getPassword());
        properties.setProperty("driverClassName", "com.mysql.jdbc.Driver");
        return properties;
    }

    public DataSource createDateSource(DataSourceModel sourceModel) {
        HikariConfig config = new HikariConfig(this.loadProperties(sourceModel));
        HikariDataSource dataSource = null;
        try {
            dataSource = new HikariDataSource(config);
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u6570\u636e\u6e90[{}]\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u6709\u6548\u6027", (Object)sourceModel.toString());
        }
        return dataSource;
    }

    @Bean(value={"dynamicDataSource"})
    public DataSource dynamicDataSource() {
        DynamicRoutingDataSource dynamicRoutingDataSource = new DynamicRoutingDataSource();
        DataSourceServieImpl sourceServieImpl = new DataSourceServieImpl(this.mybatisTemplate, "datasource", "sid");
        ServiceSession session = new ServiceSession();
        JSONObject paramsObject = new JSONObject();
        sourceServieImpl.setUseEntID(false);
        List list = ServiceComUtil.listT((JDBCCompomentServiceImpl)sourceServieImpl, (ServiceSession)session, (JSONObject)paramsObject);
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
        for (DataSourceModel dataSourceModel : list) {
            DataSource dataSource = this.createDateSource(dataSourceModel);
            if (dataSource == null) continue;
            dataSourceMap.put(dataSourceModel.getCode(), dataSource);
            logger.info("\u52a0\u8f7d\u6570\u636e\u6e90[{}]", (Object)dataSourceModel.toString());
        }
        DynamicDataSourceContextHolder.dataSourceKeys.addAll(dataSourceMap.keySet());
        dynamicRoutingDataSource.setTargetDataSources(dataSourceMap);
        return dynamicRoutingDataSource;
    }

    @Bean(name={"dynamicTemplate"})
    public JdbcTemplate jdbcMainTemplate() {
        return new JdbcTemplate(this.dynamicDataSource());
    }

    public JDBCConnectionConfiguration jdbcConnectionDynamicConfiguration(FMybatisTemplate mybatisTemplate, String code) {
        DataSourceServieImpl sourceServieImpl = new DataSourceServieImpl(mybatisTemplate, "datasource", "sid");
        ServiceSession session = new ServiceSession();
        JSONObject paramsObject = new JSONObject();
        paramsObject.put("code", (Object)code);
        sourceServieImpl.setUseEntID(false);
        DataSourceModel dataSourceModel = (DataSourceModel)ServiceComUtil.getT((JDBCCompomentServiceImpl)sourceServieImpl, (ServiceSession)session, (JSONObject)paramsObject);
        Properties properties = this.loadProperties(dataSourceModel);
        JDBCConnectionConfiguration configuration = new JDBCConnectionConfiguration();
        configuration.setConnectionURL(properties.getProperty("jdbcUrl"));
        configuration.setDriverClass(properties.getProperty("driverClassName"));
        configuration.setUserId(properties.getProperty("username"));
        configuration.setPassword(properties.getProperty("password"));
        return configuration;
    }
}

