/*
 * Decompiled with CFR 0.152.
 */
package app.mysql.explain.controller;

import app.mysql.explain.component.MavenProjectServiceImpl;
import app.mysql.explain.config.DynamicDataSourceContextHolder;
import app.mysql.explain.controller.SessionContext;
import app.mysql.explain.service.GeneratorService;
import app.mysql.explain.utils.ClassInfo;
import app.mysql.explain.utils.FieldInfo;
import app.mysql.explain.utils.MapUtil;
import app.mysql.explain.utils.ParamInfo;
import app.mysql.explain.utils.ReturnT;
import app.mysql.explain.utils.TableParseUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/explain"})
public class DataController {
    private static final Logger log = LoggerFactory.getLogger(DataController.class);
    @Autowired
    SessionContext sessionContext;
    @Autowired
    private GeneratorService generatorService;
    @Autowired
    private MavenProjectServiceImpl mavenProjectService;
    @Autowired
    @Qualifier(value="dynamicTemplate")
    private JdbcTemplate dynamicJdbcTemplate;
    protected final DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    protected final DateFormat timeFormatter = new SimpleDateFormat("HH-mm-ss");

    @GetMapping(value={"/mysql/{path}"})
    public String welcome(@PathVariable(value="path") String path, @RequestParam(value="sql", required=true) String querySQL, Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        log.info("welcome...");
        model.put("time", new Date());
        model.put("message", querySQL);
        if ("mycat".equals(path) || "main".equals(path) || "order".equals(path) || "event".equals(path)) {
            return path;
        }
        return "welcome";
    }

    @GetMapping(value={"/index"})
    public String index(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        return "index";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/download"})
    public String downloadFile(@RequestParam(value="path", required=true) String path, HttpServletRequest request, HttpServletResponse response) {
        File file = new File(path);
        if (file.exists()) {
            byte[] buffer = new byte[1024];
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            try {
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis);
                ServletOutputStream os = response.getOutputStream();
                int i = bis.read(buffer);
                while (i != -1) {
                    os.write(buffer, 0, i);
                    i = bis.read(buffer);
                }
                os.flush();
                os.close();
                System.out.println("success");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return "success";
    }

    @PostMapping(value={"/generate"})
    @ResponseBody
    public ReturnT generateCode(@RequestBody ParamInfo paramInfo) throws Exception {
        this.handleParamInfo(paramInfo);
        Map result = this.getResultByParams(paramInfo.getOptions());
        log.info("table[{}] - time:[{}]", (Object)MapUtil.getString((Map)result, (String)"tableName"), (Object)new Date());
        return ReturnT.ok().put("outputJson", (Object)result);
    }

    public void handleParamInfo(ParamInfo paramInfo) throws Exception {
        Object serviceName;
        log.info(JSON.toJSONString((Object)paramInfo.getOptions()));
        this.sessionContext.setSessionID();
        if (StringUtils.isEmpty((String)paramInfo.getTableSql())) {
            throw new Exception("\u8868\u7ed3\u6784\u4fe1\u606f\u4e3a\u7a7a");
        }
        ClassInfo classInfo = null;
        String dataType = MapUtil.getString((Map)paramInfo.getOptions(), (String)"dataType");
        if ("sql".equals(dataType) || dataType == null) {
            classInfo = TableParseUtil.processTableInfoClassInfo((ParamInfo)paramInfo);
        }
        if (this.sessionContext.isSessionSet()) {
            String databaseCode = this.sessionContext.getDatabaseCode();
            DynamicDataSourceContextHolder.setDataSourceKey((String)databaseCode);
            String querySQL = String.format("SELECT * FROM %1$s LIMIT 1", classInfo.getTableName());
            List dataList = this.dynamicJdbcTemplate.queryForList(querySQL);
            Optional optional = dataList.stream().findFirst();
            if (optional.isPresent()) {
                Map dataRow = (Map)optional.get();
                List fieldList = classInfo.getFieldList();
                for (FieldInfo field : fieldList) {
                    if (!dataRow.containsKey(field.getColumnName())) continue;
                    Object value = dataRow.get(field.getColumnName());
                    if (value == null) {
                        field.setFieldValue("");
                        continue;
                    }
                    if (value instanceof Date) {
                        field.setFieldValue(this.dateFormatter.format(TypeUtils.castToDate(value)));
                        continue;
                    }
                    if (value instanceof Time) {
                        field.setFieldValue(this.timeFormatter.format(TypeUtils.castToTimestamp(value)));
                        continue;
                    }
                    field.setFieldValue(TypeUtils.castToString(value));
                }
            }
        }
        paramInfo.getOptions().put("classInfo", classInfo);
        paramInfo.getOptions().put("tableName", classInfo == null ? Long.valueOf(System.currentTimeMillis()) : classInfo.getTableName());
        boolean isServiceName = false;
        if (paramInfo.getOptions().containsKey("serviceName") && (serviceName = paramInfo.getOptions().get("serviceName")) != null && !StringUtils.isEmpty((String)serviceName.toString())) {
            isServiceName = true;
        }
        if (!isServiceName) {
            paramInfo.getOptions().put("serviceName", String.format("%1$sExposerImpl", classInfo.getClassName()));
        }
        log.info("generated table:{},size{}", (Object)classInfo.getTableName(), classInfo.getFieldList() == null ? "" : Integer.valueOf(classInfo.getFieldList().size()));
    }

    public Map<String, String> getResultByParams(Map<String, Object> options) throws Exception {
        Map result = this.generatorService.getResultByParams(options);
        return result;
    }

    @PostMapping(value={"/generateAndDownload"})
    @ResponseBody
    public ReturnT generateAndDownload(@RequestBody ParamInfo paramInfo) throws Exception {
        this.handleParamInfo(paramInfo);
        Map outputJson = this.getResultByParams(paramInfo.getOptions());
        String group = MapUtil.getString((Map)paramInfo.getOptions(), (String)"group");
        String packageName = MapUtil.getString((Map)paramInfo.getOptions(), (String)"packageName");
        String tableName = MapUtil.getString((Map)paramInfo.getOptions(), (String)"tableName");
        ClassInfo classInfo = (ClassInfo)TypeUtils.castToJavaBean(paramInfo.getOptions().get("classInfo"), ClassInfo.class);
        String className = classInfo.getClassName();
        String downloadUrl = this.generatorService.generateFreeMarkerFile(group, packageName, tableName, className, outputJson);
        JSONObject data = new JSONObject();
        data.put("outputJson", (Object)outputJson);
        data.put("downloadUrl", (Object)downloadUrl);
        return ReturnT.ok().put("data", (Object)data);
    }

    @PostMapping(value={"/codemenu"})
    @ResponseBody
    public ReturnT generateCodeMenu() {
        try {
            String templateConfig = this.generatorService.getTemplateConfig();
            JSONArray parentTemplates = JSONArray.parseArray((String)templateConfig);
            return ReturnT.ok().put("menu", (Object)parentTemplates);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            e.printStackTrace();
            return ReturnT.error((String)"\u8bfb\u53d6\u751f\u6210\u6587\u4ef6\u83dc\u5355\u5931\u8d25");
        }
    }

    @PostMapping(value={"/codedefault"})
    @ResponseBody
    public ReturnT generateCodeDefault() {
        try {
            String templateDefault = this.generatorService.getTemplateDefault();
            JSONObject defaultJSON = JSONObject.parseObject((String)templateDefault);
            return ReturnT.ok().put("data", (Object)defaultJSON);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            e.printStackTrace();
            return ReturnT.error((String)"\u8bfb\u53d6\u751f\u6210\u6587\u4ef6\u83dc\u5355\u5931\u8d25");
        }
    }

    @PostMapping(value={"/generateEmptyPro"})
    @ResponseBody
    public ReturnT generateEmptyPro(@RequestBody JSONObject jsonparam) throws Exception {
        String downloadURL = this.mavenProjectService.generateEmptyProject(jsonparam);
        return ReturnT.ok().put("data", (Object)downloadURL);
    }

    @PostMapping(value={"/initMavenProjectConfig"})
    @ResponseBody
    public ReturnT initMavenProjectConfig() throws Exception {
        JSONArray array = this.mavenProjectService.initMavenProjectConfig();
        return ReturnT.ok().put("data", (Object)array);
    }

    @PostMapping(value={"/getUiConfig"})
    @ResponseBody
    public ReturnT getUiConfig(@RequestBody JSONObject jsonparam) throws Exception {
        JSONArray array = this.mavenProjectService.get(jsonparam.getString("versionId"), jsonparam.getString("microBaseVersionType"));
        return ReturnT.ok().put("data", (Object)array);
    }

    @PostMapping(value={"/changeBaseVer"})
    @ResponseBody
    public ReturnT changeBaseVer(@RequestBody JSONObject jsonparam) throws Exception {
        JSONArray array = this.mavenProjectService.changeBaseVer(jsonparam.getString("microBaseVersion"));
        return ReturnT.ok().put("data", (Object)array);
    }

    @PostMapping(value={"/getBaseVersionList"})
    @ResponseBody
    public ReturnT getBaseVersionList() throws Exception {
        JSONArray array = this.mavenProjectService.getBaseVersionList();
        return ReturnT.ok().put("data", (Object)array);
    }

    @PostMapping(value={"/getNacosDataIds"})
    @ResponseBody
    public ReturnT getNacosDataIds(@RequestBody JSONObject jsonparam) throws Exception {
        List dataIds = this.mavenProjectService.getNacosDataIds(jsonparam);
        return ReturnT.ok().put("data", (Object)dataIds);
    }

    @PostMapping(value={"/getNacosNamespaces"})
    @ResponseBody
    public ReturnT getNacosNamespaces(@RequestBody JSONObject jsonparam) throws Exception {
        List nameSpaces = this.mavenProjectService.getNacosNamespaces(jsonparam);
        return ReturnT.ok().put("data", (Object)nameSpaces);
    }
}

