/*
 * Decompiled with CFR 0.152.
 */
package app.mysql.explain.controller;

import app.mysql.explain.file.FileComponent;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@Controller
public class FileController {
    private static final Logger log = LoggerFactory.getLogger(FileController.class);
    @Autowired
    private FileComponent fileComponent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDownload(HttpServletResponse response, File file, String fileName) throws IOException {
        int b;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FileInputStream in = new FileInputStream(file);
        BufferedInputStream bi = new BufferedInputStream(in);
        while ((b = bi.read()) != -1) {
            bos.write(b);
        }
        bi.close();
        OutputStream outputStream = null;
        try {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            outputStream = response.getOutputStream();
            bos.writeTo(outputStream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("success");
    }

    @GetMapping(value={"explain/download/{filename}"})
    public void download(@PathVariable(value="filename") String fileName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.info("\u4e0b\u8f7d\u6587\u4ef6:{}", (Object)fileName);
        String source = String.format("%1$s/%2$s", this.fileComponent.getFileStoreDir(), fileName);
        File file = new File(source);
        if (!file.exists()) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6:{} \u4e0d\u5b58\u5728!", (Object)source);
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return;
        }
        this.onDownload(response, file, fileName);
    }
}

