/*
 * Decompiled with CFR 0.152.
 */
package app.mysql.explain.controller;

import app.mysql.explain.component.RuleServiceImpl;
import app.mysql.explain.config.DbToolConfig;
import app.mysql.explain.config.DynamicDataSourceContextHolder;
import app.mysql.explain.utils.MybatisGenrator;
import app.mysql.explain.utils.ReturnT;
import com.product.storage.template.FMybatisTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.mybatis.generator.config.JDBCConnectionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/mysql"})
@RestController
public class MysqlExplainController {
    protected static final Logger logger = LoggerFactory.getLogger((String)"MysqlMainExplainController");
    @Autowired
    @Qualifier(value="dynamicTemplate")
    private JdbcTemplate jdbcTemplate;
    @Autowired
    @Qualifier(value="jdbcMainTemplate")
    private JdbcTemplate jdbcMainTemplate;
    @Autowired
    @Qualifier(value="mainStorageOperation")
    FMybatisTemplate mybatisTemplate;
    @Autowired
    @Qualifier(value="dbtool.rule")
    RuleServiceImpl ruleService;

    @GetMapping(value={"query"})
    @ResponseBody
    public List<Map<String, Object>> querydb(String sql, String db) {
        ArrayList<Map<String, Object>> listMaps = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)sql)) {
            map.put("error", "\u53c2\u6570SQL\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            listMaps.add(map);
            return listMaps;
        }
        if (StringUtils.isEmpty((String)db)) {
            map.put("error", "\u8bf7\u6307\u5b9a\u8981\u67e5\u8be2\u7684\u6570\u636e\u5e93");
            listMaps.add(map);
            return listMaps;
        }
        try {
            DynamicDataSourceContextHolder.setDataSourceKey((String)db);
            return this.jdbcTemplate.queryForList(sql);
        }
        catch (Exception e) {
            map.put("error", e.getMessage());
            logger.info(e.getMessage());
            listMaps.add(map);
            return listMaps;
        }
    }

    @GetMapping(value={"main/query"})
    @ResponseBody
    public List<Map<String, Object>> queryversion(String sql, String db) {
        ArrayList<Map<String, Object>> listMaps = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)sql)) {
            map.put("error", "\u53c2\u6570SQL\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            listMaps.add(map);
            return listMaps;
        }
        if (StringUtils.isEmpty((String)db)) {
            return this.jdbcMainTemplate.queryForList(sql);
        }
        try {
            DynamicDataSourceContextHolder.setDataSourceKey((String)db);
            return this.jdbcTemplate.queryForList(sql);
        }
        catch (Exception e) {
            map.put("error", e.getMessage());
            logger.info(e.getMessage());
            listMaps.add(map);
            return listMaps;
        }
    }

    @RequestMapping(value={"querysql"})
    @ResponseBody
    public List<Map<String, Object>> queryBySQL(String sql, Integer page_no, Integer page_size, String db) {
        ArrayList<Map<String, Object>> listMaps = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)sql)) {
            map.put("error", "\u53c2\u6570SQL\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            listMaps.add(map);
            return listMaps;
        }
        if (StringUtils.isEmpty((String)db)) {
            map.put("error", "\u8bf7\u6307\u5b9a\u8981\u67e5\u8be2\u7684\u6570\u636e\u5e93");
            listMaps.add(map);
            return listMaps;
        }
        DynamicDataSourceContextHolder.setDataSourceKey((String)db);
        logger.info("\u67e5\u8be2\u6761\u4ef6:sql [{}],page_no[{}],page_size[{}],", new Object[]{sql, page_no, page_size});
        ReturnT returnT = this.ruleService.auditSql(sql);
        int code = (Integer)returnT.get((Object)"code");
        if (code == 0) {
            listMaps.add((Map<String, Object>)returnT);
            return listMaps;
        }
        StringBuffer buffer = new StringBuffer("");
        buffer.append("select * from ( ");
        buffer.append(sql);
        buffer.append(") ta limit ");
        int startno = page_no > 1 ? (page_no - 1) * page_size + 1 : 0;
        buffer.append(startno);
        buffer.append(",");
        buffer.append(page_no * page_size);
        sql = buffer.toString();
        logger.info("\u6267\u884cMSQL\u67e5\u8be2\u8bed\u53e5[{}]", (Object)sql);
        try {
            return this.jdbcTemplate.queryForList(sql);
        }
        catch (Exception e) {
            map.put("error", e.getMessage());
            logger.info(e.getMessage());
            listMaps.add(map);
            return listMaps;
        }
    }

    @GetMapping(value={"/generator"})
    public List<Map<String, Object>> mybatisGenerator(@RequestParam(value="tablename", required=true) String tablename, @RequestParam(value="objectname", required=true) String objectname, @RequestParam(value="db", required=true) String db, HttpServletRequest request, HttpServletResponse response) {
        DbToolConfig config = new DbToolConfig();
        JDBCConnectionConfiguration jdbcConnectionDynamicConfiguration = config.jdbcConnectionDynamicConfiguration(this.mybatisTemplate, db);
        List list = MybatisGenrator.mybatisGenerator((JDBCConnectionConfiguration)jdbcConnectionDynamicConfiguration, (String)tablename, (String)objectname);
        return list;
    }
}

