/*
 * Decompiled with CFR 0.152.
 */
package app.mysql.explain.controller;

import app.mysql.explain.utils.RandomGUID;
import app.mysql.explain.utils.SessionHolder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.stereotype.Component;

@Component
public class SessionContext {
    private static final Logger log = LoggerFactory.getLogger(SessionContext.class);
    @Autowired
    HttpServletRequest request;
    @Autowired
    HttpServletResponse response;
    @Autowired
    protected RedisConnectionFactory connectionFactory;

    protected void setSessionID() {
        boolean founded = false;
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"JSESSIONID".equalsIgnoreCase(cookie.getName())) continue;
                log.info("--->Cookie:{}", (Object)cookie.getValue());
                SessionHolder.putSession((String)cookie.getValue());
                founded = true;
            }
        }
        if (!founded) {
            String randomGUID = new RandomGUID().toString();
            String origin = this.request.getHeader("Origin");
            if (origin == null) {
                origin = this.request.getHeader("Referer");
            }
            this.response.setHeader("Access-Control-Allow-Origin", origin);
            this.response.setHeader("Access-Control-Allow-Credentials", "true");
            Cookie cookie = new Cookie("JSESSIONID", randomGUID);
            cookie.setPath("/");
            this.response.addCookie(cookie);
            log.info("--->Cookie:{}", (Object)cookie.getValue());
            SessionHolder.putSession((String)cookie.getValue());
        }
    }

    protected String getSessionID() {
        String sessionID = SessionHolder.getSession();
        return sessionID;
    }

    protected boolean isSessionSet() {
        String sessionID = this.getSessionID();
        return !StringUtils.isEmpty((CharSequence)sessionID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDatabaseCode() {
        String response = "";
        try (RedisConnection conn = this.connectionFactory.getConnection();){
            String sessionID = this.getSessionID();
            String sessionKey = String.format("dbtool:%1$s", sessionID);
            log.info("\u8bfb\u53d6\u7f13\u5b58\u4f1a\u8bdd\u6570\u636e\u5e93:\u3010{}\u3011", (Object)sessionKey);
            byte[] value = conn.get(sessionKey.getBytes());
            response = new String(value);
            log.info("\u8bfb\u53d6\u7f13\u5b58\u4f1a\u8bdd\u6570\u636e\u5e93:\u3010{}=>{}\u3011", (Object)response, (Object)sessionKey);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDatabaseCode(String databaseCode) {
        String sessionID = SessionHolder.getSession();
        if (!StringUtils.isEmpty((CharSequence)sessionID)) {
            try (RedisConnection conn = this.connectionFactory.getConnection();){
                String sessionKey = String.format("dbtool:%1$s", sessionID);
                conn.set(sessionKey.getBytes(), databaseCode.getBytes(), Expiration.seconds((long)86400L), RedisStringCommands.SetOption.upsert());
                log.info("\u5199\u5165\u4f1a\u8bdd\u6570\u636e\u5e93:\u3010{}=>{}\u3011\u5230\u7f13\u5b58", (Object)sessionKey, (Object)(databaseCode + ""));
            }
        }
    }
}

