/*
 * Decompiled with CFR 0.152.
 */
package app.mysql.explain.file;

import app.mysql.explain.utils.CMDUtils;
import com.product.util.ZipUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class FileComponent {
    private static final Logger log = LoggerFactory.getLogger(FileComponent.class);
    @Value(value="${mysqlexplain.fileStoreDir:#{null}}")
    private String fileStoreDir;

    public String getFileStoreDir() {
        if (StringUtils.isEmpty((Object)this.fileStoreDir)) {
            String curpath = CMDUtils.execLinuxCMD((String)"pwd").replaceAll("\n", "");
            String dir = curpath + "/tmp";
            File file = new File(dir);
            if (!file.exists()) {
                file.mkdirs();
                return dir;
            }
            return dir;
        }
        return this.fileStoreDir;
    }

    public void deleteFileFolder(String folderPath) {
        File floder = new File(folderPath);
        this.deleteFloder(floder);
    }

    private void deleteFloder(File floder) {
        File[] files = floder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteFloder(file);
                    continue;
                }
                file.delete();
            }
        }
        floder.delete();
    }

    public void deleteFile(String fileName) {
        File f = new File(fileName);
        if (f.exists()) {
            f.delete();
        }
    }

    public void createFileFolder(String packageName) {
        String[] packages = packageName.split("\\.");
        File file = new File(this.getFileStoreDir());
        for (String fileFold : packages) {
            File f = new File(file.getPath() + "/" + fileFold);
            if (!f.exists()) {
                f.mkdirs();
            }
            file = f;
        }
    }

    public String toZip(String fullPath) throws Exception {
        String zipFileName = fullPath + ".zip";
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(zipFileName));
            ZipUtils.toZip((String)fullPath, (OutputStream)out, (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return zipFileName;
    }

    public String toZip(String fullPath, String zipFileName) throws Exception {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(this.getFileStoreDir() + "/" + zipFileName));
            ZipUtils.toZip((String)fullPath, (OutputStream)out, (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException("toZip error from FileComponent", e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return zipFileName;
    }

    public void saveFile(String fileName, String content) {
        File file = new File(fileName);
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            log.info("create dirs:{}", (Object)parentFile.getAbsolutePath());
            parentFile.mkdirs();
        }
        FileOutputStream outStream = null;
        try {
            file.createNewFile();
            outStream = new FileOutputStream(file);
            IOUtils.write((String)content, (OutputStream)outStream, (String)"utf-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void createFolder(String folder) {
        File file = new File(folder);
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            log.info("create dirs:{}", (Object)parentFile.getAbsolutePath());
            parentFile.mkdirs();
        }
        if (!file.exists()) {
            log.info("create dirs:{}", (Object)file.getAbsolutePath());
            file.mkdirs();
        }
    }

    public void copyFile(String filePath, File sourcefile) throws Exception {
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(sourcefile);
            this.copyFile(filePath, (InputStream)inStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inStream != null) {
                try {
                    ((InputStream)inStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void copyFile(String filePath, InputStream inStream) throws Exception {
        File file = new File(filePath);
        int bytesum = 0;
        int byteread = 0;
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((byteread = inStream.read(buffer)) != -1) {
                bytesum += byteread;
                outStream.write(buffer, 0, byteread);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

