/*
 * Decompiled with CFR 0.152.
 */
package app.mysql.explain.service;

import app.mysql.explain.file.FileComponent;
import app.mysql.explain.service.GeneratorService;
import app.mysql.explain.utils.FreemarkerUtil;
import app.mysql.explain.utils.MapUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class GeneratorServiceImpl
implements GeneratorService {
    String templateConfig = null;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private FileComponent fileComponent;

    public String getTemplateConfig() throws IOException {
        this.templateConfig = null;
        if (this.templateConfig == null) {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("template.json");
            this.templateConfig = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining(System.lineSeparator()));
        }
        return this.templateConfig;
    }

    public String getTemplateDefault() throws IOException {
        this.templateConfig = null;
        if (this.templateConfig == null) {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("default.json");
            this.templateConfig = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining(System.lineSeparator()));
        }
        return this.templateConfig;
    }

    public Map<String, String> getResultByParams(Map<String, Object> params) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>(32);
        result.put("tableName", MapUtil.getString(params, (String)"tableName"));
        String templateGroupId = MapUtil.getString(params, (String)"group");
        JSONArray parentTemplates = JSONArray.parseArray((String)this.getTemplateConfig());
        for (int i = 0; i < parentTemplates.size(); ++i) {
            JSONObject parentTemplateObj = parentTemplates.getJSONObject(i);
            if (!StringUtils.isEmpty((Object)templateGroupId)) {
                if (!templateGroupId.equals(parentTemplateObj.get((Object)"group"))) continue;
                this.generateFreeMarkerJSONByGroup(parentTemplateObj, params, result);
                break;
            }
            this.generateFreeMarkerJSONByGroup(parentTemplateObj, params, result);
        }
        return result;
    }

    public String generateFreeMarkerFile(String group, String packageName, String tableName, String className, Map<String, String> params) throws Exception {
        String[] packages = packageName.split("\\.");
        this.fileComponent.deleteFileFolder(this.fileComponent.getFileStoreDir() + "/" + packages[0]);
        this.fileComponent.createFileFolder(this.fileComponent.getFileStoreDir() + "/" + packageName.replace(".", "/"));
        JSONArray parentTemplates = JSONArray.parseArray((String)this.getTemplateConfig());
        params.put("className", className);
        for (int i = 0; i < parentTemplates.size(); ++i) {
            JSONObject parentTemplateObj = parentTemplates.getJSONObject(i);
            if (!group.equals(parentTemplateObj.get((Object)"group"))) continue;
            this.generateFreeMarkerFileByGroup(parentTemplateObj, params, packageName);
            break;
        }
        String fileName = String.format("%1$s.zip", tableName);
        this.fileComponent.toZip(this.fileComponent.getFileStoreDir() + "/" + packages[0], fileName);
        String downloadURL = String.format("%1$s://%2$s:%3$d/explain/download/%4$s", this.request.getScheme(), this.request.getServerName(), this.request.getServerPort(), fileName);
        this.fileComponent.deleteFileFolder(this.fileComponent.getFileStoreDir() + "/" + packages[0]);
        return downloadURL;
    }

    public void generateFreeMarkerFileByGroup(JSONObject parentTemplateObj, Map<String, String> params, String packageName) throws TemplateException, IOException {
        for (int j = 0; j < parentTemplateObj.getJSONArray("templates").size(); ++j) {
            JSONObject childTemplate = parentTemplateObj.getJSONArray("templates").getJSONObject(j);
            String str = params.get(childTemplate.get((Object)"name"));
            String className = params.get("className");
            String fileName = this.fileComponent.getFileStoreDir() + "/" + packageName.replace(".", "/") + "/" + className;
            String fullFileName = this.getFullFileName(fileName, childTemplate.get((Object)"name").toString());
            this.fileComponent.saveFile(fullFileName, str);
        }
    }

    public void generateFreeMarkerJSONByGroup(JSONObject parentTemplateObj, Map<String, Object> params, Map<String, String> result) throws Exception {
        for (int j = 0; j < parentTemplateObj.getJSONArray("templates").size(); ++j) {
            JSONObject childTemplate = parentTemplateObj.getJSONArray("templates").getJSONObject(j);
            result.put(childTemplate.getString("name"), FreemarkerUtil.processString((String)(parentTemplateObj.getString("group") + "/" + childTemplate.getString("name") + ".ftl"), params));
        }
    }

    public String getFullFileName(String fileName, String type) {
        String fullFileName = "";
        if (type.equals("DataModel")) {
            fullFileName = fileName + ".java";
        } else if (type.equals("DataService")) {
            fullFileName = fileName + "Service.java";
        } else if (type.equals("DataServiceImpl")) {
            fullFileName = fileName + "ServiceImpl.java";
        } else if (type.equals("DataExposer")) {
            fullFileName = fileName + "Exposer.java";
        } else if (type.equals("PlusModel")) {
            fullFileName = fileName + "Model.java";
        } else if (type.equals("PlusMapper")) {
            fullFileName = fileName + "Mapper.java";
        } else if (type.equals("PlusService")) {
            fullFileName = fileName + "Service.java";
        } else if (type.equals("PlusServiceImpl")) {
            fullFileName = fileName + "ServiceImpl.java";
        } else if (type.equals("PlusExposer")) {
            fullFileName = fileName + "ExposerImpl.java";
        } else if (type.equals("mybatis")) {
            fullFileName = fileName + ".xml";
        } else if (type.equals("model")) {
            fullFileName = fileName + ".java";
        } else if (type.equals("controller")) {
            fullFileName = fileName + "Controller.java";
        } else if (type.equals("service")) {
            fullFileName = fileName + "Service.java";
        } else if (type.equals("service_impl")) {
            fullFileName = fileName + "ServiceImpl.java";
        } else if (type.equals("json")) {
            fullFileName = fileName + "json";
        } else if (type.equals("xml")) {
            fullFileName = fileName + ".xml";
        } else if (type.equals("sql")) {
            fullFileName = fileName + ".txt";
        } else if (type.equals("DataFrame")) {
            fullFileName = fileName + ".java";
        }
        return fullFileName;
    }
}

