/*
 * Decompiled with CFR 0.152.
 */
package app.mysql.explain.table.utils.token;

import app.mysql.explain.table.utils.token.TableLexer;
import app.mysql.explain.table.utils.token.TableLexerBase;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONScanner;
import java.io.Closeable;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.TreeSet;

public class TableParser
implements Closeable {
    public final Object input;
    public final TableLexer lexer;

    public TableParser(Object input, TableLexer lexer) {
        this.lexer = lexer;
        this.input = input;
        char ch = lexer.getCurrent();
        if (ch == '{') {
            lexer.next();
            ((TableLexerBase)lexer).token = 12;
        } else if (ch == '[') {
            lexer.next();
            ((TableLexerBase)lexer).token = 14;
        } else {
            lexer.nextToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse(Object fieldName) {
        TableLexer lexer = this.lexer;
        switch (lexer.token()) {
            case 21: {
                lexer.nextToken();
                HashSet set = new HashSet();
                return set;
            }
            case 22: {
                lexer.nextToken();
                TreeSet treeSet = new TreeSet();
                return treeSet;
            }
            case 14: {
                JSONArray array = new JSONArray();
                if (lexer.isEnabled(Feature.UseObjectArray)) {
                    return array.toArray();
                }
                return array;
            }
            case 12: {
                JSONObject jSONObject = new JSONObject(lexer.isEnabled(Feature.OrderedField));
            }
            case 2: {
                Number intValue = lexer.integerValue();
                lexer.nextToken();
                return intValue;
            }
            case 3: {
                Number value = lexer.decimalValue(lexer.isEnabled(Feature.UseBigDecimal));
                lexer.nextToken();
                return value;
            }
            case 4: {
                String stringLiteral = lexer.stringVal();
                lexer.nextToken(16);
                if (lexer.isEnabled(Feature.AllowISO8601DateFormat)) {
                    try (JSONScanner iso8601Lexer = new JSONScanner(stringLiteral);){
                        if (iso8601Lexer.scanISO8601DateIfMatch()) {
                            Date date = iso8601Lexer.getCalendar().getTime();
                            return date;
                        }
                    }
                }
                return stringLiteral;
            }
            case 8: {
                lexer.nextToken();
                return null;
            }
            case 23: {
                lexer.nextToken();
                return null;
            }
            case 6: {
                lexer.nextToken();
                return Boolean.TRUE;
            }
            case 7: {
                lexer.nextToken();
                return Boolean.FALSE;
            }
            case 9: {
                lexer.nextToken(18);
                if (lexer.token() != 18) {
                    throw new JSONException("syntax error");
                }
                lexer.nextToken(10);
                long time = lexer.integerValue().longValue();
                return new Date(time);
            }
            case 20: {
                if (lexer.isBlankInput()) {
                    return null;
                }
                throw new JSONException("unterminated json string, " + lexer.info());
            }
            case 26: {
                byte[] bytes = lexer.bytesValue();
                lexer.nextToken();
                return bytes;
            }
            case 18: {
                String identifier = lexer.stringVal();
                if ("NaN".equals(identifier)) {
                    lexer.nextToken();
                    return null;
                }
                throw new JSONException("syntax error, " + lexer.info());
            }
        }
        throw new JSONException("syntax error, " + lexer.info());
    }

    @Override
    public void close() throws IOException {
    }
}

