/*
 * Decompiled with CFR 0.152.
 */
package app.mysql.explain.task;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.springframework.stereotype.Component;

@Component
public class ExecutorManager {
    private final ExecutorService threadPool = Executors.newCachedThreadPool();

    public void execute(Runnable task) {
        this.threadPool.execute(task);
    }

    @PreDestroy
    private void destroy() {
        this.threadPool.shutdown();
        try {
            this.threadPool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.threadPool.shutdownNow();
        }
    }
}

