/*
 * Decompiled with CFR 0.152.
 */
package app.mysql.explain.utils;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.JDBCConnectionConfiguration;
import org.mybatis.generator.config.JavaModelGeneratorConfiguration;
import org.mybatis.generator.config.SqlMapGeneratorConfiguration;
import org.mybatis.generator.config.TableConfiguration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.internal.DefaultShellCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class MybatisGenrator {
    protected static final Logger logger = LoggerFactory.getLogger((String)"esBaseLogger");

    public static List<Map<String, Object>> mybatisGenerator(JDBCConnectionConfiguration jdbcConfiguration, String tablename, String objectname) {
        ArrayList<Map<String, Object>> listMaps = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer basUrl = new StringBuffer("");
        StringBuffer mybatisUrl = new StringBuffer("");
        try {
            ArrayList warnings = new ArrayList();
            boolean overwrite = true;
            InputStream inputStream = new ClassPathResource("generatorConfig.xml").getInputStream();
            ConfigurationParser cp = new ConfigurationParser(warnings);
            Configuration config = cp.parseConfiguration(inputStream);
            List contexts = config.getContexts();
            if (contexts.size() > 0) {
                Context context = (Context)contexts.get(0);
                context.setJdbcConnectionConfiguration(jdbcConfiguration);
                JavaModelGeneratorConfiguration generatorConfig = context.getJavaModelGeneratorConfiguration();
                String strPackage = generatorConfig.getTargetPackage();
                strPackage = strPackage.replace(".", "/");
                basUrl.append(generatorConfig.getTargetProject());
                basUrl.append("/");
                basUrl.append(strPackage);
                basUrl.append("/");
                SqlMapGeneratorConfiguration sqlMapConf = context.getSqlMapGeneratorConfiguration();
                sqlMapConf.setTargetProject(generatorConfig.getTargetProject());
                mybatisUrl.append(sqlMapConf.getTargetProject());
                mybatisUrl.append("/");
                String sqlMapPak = sqlMapConf.getTargetPackage();
                mybatisUrl.append(sqlMapPak).append("/");
                List tableConfs = context.getTableConfigurations();
                if (tableConfs.size() > 0) {
                    TableConfiguration tableConf = (TableConfiguration)tableConfs.get(0);
                    tableConf.setTableName(tablename);
                    tableConf.setDomainObjectName(objectname);
                    basUrl.append(objectname).append(".java");
                    mybatisUrl.append(objectname).append("Mapper.xml");
                }
            }
            DefaultShellCallback callback = new DefaultShellCallback(overwrite);
            MyBatisGenerator myBatisGenerator = new MyBatisGenerator(config, (ShellCallback)callback, warnings);
            myBatisGenerator.generate(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("error", e.getMessage());
            logger.info(e.getMessage());
            listMaps.add(map);
        }
        map.put("modelurl", basUrl.toString());
        map.put("mybatisurl", mybatisUrl.toString());
        logger.info("model\u751f\u6210\u5730\u5740[{}]", (Object)basUrl.toString());
        logger.info("mybatisurl\u751f\u6210\u5730\u5740[{}]", (Object)mybatisUrl.toString());
        listMaps.add(map);
        return listMaps;
    }
}

