<#if isAutoImport?exists && isAutoImport==true>
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.product.model.ServiceResponse;
import com.shiji.core.annotation.RepositoryRestComponent;
import com.shiji.core.annotation.RestComponent;
import com.shiji.core.enums.HttpMethod;

import lombok.extern.slf4j.Slf4j;

import ${packageName}.service.${classInfo.className}Service;
import ${packageName}.model.${classInfo.className}Model;

</#if>
/**
 * @description ${classInfo.classComment}
 * @author ${authorName}
 * @date ${.now?string('yyyy-MM-dd')}
 */
@Slf4j
@RepositoryRestComponent(exported=true,allMethod=false,path="/${classInfo.tableName}",collectionResourceRel="${classInfo.tableName}",note="${classInfo.classComment}")
@Component(value = "${serviceName?uncap_first}")
public class ${classInfo.className}ExposerImpl {
	@Autowired
	private ${classInfo.className}Service invoker;

    /**
     * 分页查询
     *   curl -X POST -H "Content-Type: text/plain" -d '{"page_no":0,"page_size":1}' "http://localhost:8081/rest?method=${serviceName?uncap_first}.query&ent_id=0"
     *   curl -X POST -H "Content-Type: text/plain" -d '{"page_no":1,"page_size":3}' "http://localhost:8081/rest?method=${serviceName?uncap_first}.query&ent_id=0"
     */
	@RestComponent(path = "query",method=HttpMethod.POST,isReport=true,rel = "${classInfo.tableName}",exported=true,note="${classInfo.classComment}查询",responseModels={${classInfo.className}Model.class})
	public ServiceResponse query(${classInfo.className}Model ${classInfo.tableName}) {
		return invoker.query(${classInfo.tableName});
	}
	
    /**
     * 单行查看
     *   curl -X POST -H "Content-Type: text/plain" -d '{}' "http://localhost:8081/rest?method=${serviceName?uncap_first}.view&ent_id=0"
     */
	@RestComponent(path = "view", method = HttpMethod.POST, rel = "${classInfo.tableName}", exported = true, note = "${classInfo.classComment}查看", responseModels = {${classInfo.className}Model.class})
	public ServiceResponse view(String ${classInfo.tableKey}) {
		return invoker.query${classInfo.className}ByID(${classInfo.tableKey});
	}	
}
