<#if isAutoImport?exists && isAutoImport==true>
import java.io.Serializable;
import java.util.Date;
import java.util.ArrayList;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.product.model.ResponseCode;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.SpringContext;
import com.shiji.core.annotation.RepositoryRestComponent;
import com.shiji.core.annotation.RestComponent;
import com.shiji.core.component.BaseExposer;
import com.shiji.core.enums.HttpMethod;

import lombok.extern.slf4j.Slf4j;

import ${packageName}.service.${classInfo.className}Service;
import ${packageName}.model.${classInfo.className};

</#if>
/**
 * @description ${classInfo.classComment}
 * @author ${authorName}
 * @date ${.now?string('yyyy-MM-dd')}
 */
@Slf4j
@RepositoryRestComponent(exported=true,allMethod=false,path="/${classInfo.tableName}",collectionResourceRel="${classInfo.tableName}",note="${classInfo.classComment}")
@Component(value = "${serviceName?uncap_first}")
public class ${classInfo.className}Exposer extends BaseExposer<${classInfo.className},${classInfo.className}Service> {
	@Autowired
	private ${classInfo.className}Service invoker;

    @Override
    protected String getcollectionName() {
        return "${classInfo.tableName}";
    }

    /**
     * 分页查询
     *   curl -X POST -H "Content-Type: text/plain" -d '{"page_no":0,"page_size":1}' "http://localhost:8081/rest?method=${serviceName?uncap_first}.query&ent_id=0"
     *   curl -X POST -H "Content-Type: text/plain" -d '{"page_no":1,"page_size":3}' "http://localhost:8081/rest?method=${serviceName?uncap_first}.query&ent_id=0"
     */
	@RestComponent(path = "query",method=HttpMethod.POST,isReport=true,rel = "${classInfo.tableName}",exported=true,note="${classInfo.classComment}查询",responseModels={${classInfo.className}.class})
	public ServiceResponse query(${classInfo.className} ${classInfo.tableName}) {
		return this.query(invoker, ${classInfo.tableName});
	}
	
    /**
     * 单行查看
     *   curl -X POST -H "Content-Type: text/plain" -d '{}' "http://localhost:8081/rest?method=${serviceName?uncap_first}.view&ent_id=0"
     */
	@RestComponent(path = "view", method = HttpMethod.POST, rel = "${classInfo.tableName}", exported = true, note = "${classInfo.classComment}查看", responseModels = {${classInfo.className}.class})
	public ServiceResponse view(${classInfo.className} ${classInfo.tableName}) {
		return this.view(invoker, ${classInfo.tableName});
	}	

    /**
     * 新增
     *
     * curl -X POST -H "Content-Type: text/plain" -d '{...}' "http://localhost:8081/rest?method=${serviceName?uncap_first}.insert&ent_id=0"
     * 
     */
	@RestComponent(path = "insert",method=HttpMethod.POST,rel = "${classInfo.tableName}",exported=true,note="${classInfo.classComment}新增",responseModels={${classInfo.className}.class})
	public ServiceResponse insert(${classInfo.className} ${classInfo.tableName}) {
		return this.insert(invoker, ${classInfo.tableName});
	}

    /**
     * 删除
     *
     * curl -X POST -H "Content-Type: text/plain" -d '{...}' "http://localhost:8081/rest?method=${serviceName?uncap_first}.delete&ent_id=0"
     * 
     */
	@RestComponent(path = "delete",method=HttpMethod.POST,rel = "${classInfo.tableName}",exported=true,note="${classInfo.classComment}删除",responseModels={${classInfo.className}.class})
	public ServiceResponse delete(${classInfo.className} ${classInfo.tableName}) {
		return this.delete(invoker, ${classInfo.tableName});
	}
	
    /**
     * 更新
     *
     * curl -X POST -H "Content-Type: text/plain" -d '{...}' "http://localhost:8081/rest?method=${serviceName?uncap_first}.update&ent_id=0"
     * 
     */
	@RestComponent(path = "update",method=HttpMethod.POST,rel = "${classInfo.tableName}",exported=true,note="${classInfo.classComment}更新",responseModels={${classInfo.className}.class})
	public ServiceResponse update(${classInfo.className} ${classInfo.tableName}) {
		return this.update(invoker, ${classInfo.tableName});
	}
	
    /**
     * 保存
     *
     * curl -X POST -H "Content-Type: text/plain" -d '{"${classInfo.tableName}":[{...},{...}]}' "http://localhost:8081/rest?method=${serviceName?uncap_first}.save&ent_id=0"
     * 
     */
	@RestComponent(path = "save",method=HttpMethod.POST,rel = "${classInfo.tableName}",exported=true,note="${classInfo.classComment}保存",responseModels={${classInfo.className}.class})
	public ServiceResponse save(List<${classInfo.className}> ${classInfo.tableName}) throws Exception {
		return this.save(invoker, ${classInfo.tableName});
	}
}
