<#if isAutoImport?exists && isAutoImport==true>
import java.io.Serializable;
import java.util.Date;
import java.math.BigDecimal;
import java.util.List;
import com.product.model.BaseQueryModel;
import com.shiji.core.annotation.ModelProperty;
import com.product.annotation.UniqueKey;
import com.product.service.OperationFlag;
<#if classInfo.annotationType?exists && classInfo.annotationType=='1'>
import com.product.annotation.NotNull;
import com.product.annotation.Length;
<#elseif classInfo.annotationType?exists && classInfo.annotationType=='2'>
import org.hibernate.validator.constraints.Length;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.NotBlank;
</#if>

import lombok.Data;

</#if>
/**
 * @description ${classInfo.classComment}
 * @author ${authorName}
 * @date ${.now?string('yyyy-MM-dd')}
*/
<#if classInfo.uniqueKeyList?exists && classInfo.uniqueKeyList?size gt 0>
    <#list classInfo.uniqueKeyList as uniqueKey >
@UniqueKey(table = "${uniqueKey.table}", keys = { ${uniqueKey.keys} }, primaryKey = "${uniqueKey.primaryKey}", operationFlags = {
OperationFlag.Insert,OperationFlag.Update }, message = "${uniqueKey.message}")
    </#list>
</#if>
@Data
public class ${classInfo.className} extends BaseQueryModel {
<#if classInfo.fieldList?exists && classInfo.fieldList?size gt 0>
<#list classInfo.fieldList as fieldItem >
    <#if isComment?exists && isComment==true>/**
    * ${fieldItem.fieldComment}
    */
    <#if classInfo.annotationType?exists && classInfo.annotationType=='1'>
    <#if fieldItem.notNull?exists && fieldItem.notNull==true>
    @NotNull(operationFlags = { OperationFlag.Insert,OperationFlag.Update },message = "${fieldItem.fieldComment}[${fieldItem.fieldName}]不能为空")
    </#if>
    <#if fieldItem.fieldLength?exists>
    @Length(operationFlags = { OperationFlag.Insert,OperationFlag.Update },message="${fieldItem.fieldComment}[${fieldItem.fieldName}]长度不能大于${fieldItem.fieldLength}",min="1",max="${fieldItem.fieldLength}")
    </#if>
    <#elseif classInfo.annotationType?exists && classInfo.annotationType=='2'>
    <#if fieldItem.notNull?exists && fieldItem.notNull==true>
    <#if fieldItem.fieldClass=='String'>
    @NotBlank(message = "${fieldItem.fieldComment}[${fieldItem.fieldName}]不能为空")
    <#else>
    @NotNull(message = "${fieldItem.fieldComment}[${fieldItem.fieldName}]不能为空")
    </#if>
    </#if>
    <#if fieldItem.fieldLength?exists>
    @Length(message="${fieldItem.fieldComment}[${fieldItem.fieldName}]长度不能大于${fieldItem.fieldLength}",max=${fieldItem.fieldLength})
    </#if>
    </#if>
    @ModelProperty(value = "${fieldItem.fieldValue}", note = "${fieldItem.fieldComment}")
    </#if>
    private ${fieldItem.fieldClass} ${fieldItem.fieldName};

</#list>
</#if>
}
