/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import org.codehaus.marmalade.discovery.TaglibResolutionStrategy;
import org.codehaus.marmalade.discovery.tld.TldParser;
import org.codehaus.marmalade.metamodel.MarmaladeTagLibrary;
import org.codehaus.marmalade.monitor.log.DefaultLog;
import org.codehaus.marmalade.monitor.log.MarmaladeLog;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class PrefixedTldResolutionStrategy
implements TaglibResolutionStrategy {
    private MarmaladeLog log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarmaladeTagLibrary resolve(String prefix, String taglib, ClassLoader cloader) {
        PrefixedTldResolutionStrategy prefixedTldResolutionStrategy = this;
        synchronized (prefixedTldResolutionStrategy) {
            if (this.log == null) {
                this.log = new DefaultLog();
            }
        }
        MarmaladeTagLibrary tlib = null;
        InputStream tldStream = null;
        try {
            String tldFile = "META-INF/" + prefix + "/" + taglib + ".tld";
            tldStream = cloader.getResourceAsStream(tldFile);
            if (tldStream != null) {
                TldParser parser = new TldParser();
                try {
                    tlib = parser.parse(new InputStreamReader(tldStream, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    List<Object> entries = Arrays.asList(e, "Proceeding with taglib resolution.");
                    this.log.log("debug", entries);
                }
                catch (XmlPullParserException e) {
                    List<Object> entries = Arrays.asList(new Object[]{e, "Proceeding with taglib resolution."});
                    this.log.log("debug", entries);
                }
                catch (IOException e) {
                    List<Object> entries = Arrays.asList(e, "Proceeding with taglib resolution.");
                    this.log.log("debug", entries);
                }
                catch (ClassNotFoundException e) {
                    List<Object> entries = Arrays.asList(e, "Proceeding with taglib resolution.");
                    this.log.log("debug", entries);
                }
            }
        }
        finally {
            if (tldStream != null) {
                try {
                    tldStream.close();
                }
                catch (IOException e) {}
            }
        }
        List<Object> entries = Arrays.asList("Returning taglib: ", tlib, " from prefixed TLD file strategy for taglib {prefix: ", prefix, ", taglib: ", taglib, "} using classloader: ", cloader);
        this.log.log("debug", entries);
        return tlib;
    }

    public void setLog(MarmaladeLog log) {
        this.log = log;
    }
}

