/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.el;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.marmalade.el.BareBonesExpressionEvaluator;
import org.codehaus.marmalade.el.ExpressionEvaluator;
import org.codehaus.marmalade.monitor.log.DefaultLog;
import org.codehaus.marmalade.monitor.log.MarmaladeLog;

public final class ExpressionEvaluatorFactory {
    private static final String DEFAULT_EL_TYPE = "ognl";
    private static Map evaluators = new WeakHashMap();
    private MarmaladeLog log;

    public static ExpressionEvaluator getDefaultExpressionEvaluator() {
        return new ExpressionEvaluatorFactory().getExpressionEvaluator(DEFAULT_EL_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionEvaluator getExpressionEvaluator(String type) {
        Object object = this;
        synchronized (object) {
            if (this.log == null) {
                this.log = new DefaultLog();
            }
        }
        object = type.intern();
        synchronized (object) {
            ExpressionEvaluator evaluator = (ExpressionEvaluator)evaluators.get(type);
            if (evaluator == null) {
                URL classUrl;
                String elResource = "META-INF/marmalade/el/" + type;
                ClassLoader cloader = Thread.currentThread().getContextClassLoader();
                InputStream res = cloader.getResourceAsStream(elResource);
                if (res == null) {
                    return new BareBonesExpressionEvaluator();
                }
                String className = null;
                BufferedReader in = null;
                try {
                    in = new BufferedReader(new InputStreamReader(res));
                    className = in.readLine();
                }
                catch (IOException e) {
                    List<Object> entries = Arrays.asList(e, "Proceeding with taglib resolution.");
                    this.log.log("error", entries);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                }
                if (className != null && className.length() > 0 && (classUrl = cloader.getResource(className.replace('.', '/') + ".class")) != null) {
                    try {
                        Class<?> elClass = cloader.loadClass(className);
                        evaluator = (ExpressionEvaluator)elClass.newInstance();
                        evaluators.put(type, evaluator);
                    }
                    catch (ClassNotFoundException e) {
                        List<Object> entries = Arrays.asList(e, "Proceeding with taglib resolution.");
                        this.log.log("error", entries);
                    }
                    catch (InstantiationException e) {
                        List<Object> entries = Arrays.asList(e, "Proceeding with taglib resolution.");
                        this.log.log("error", entries);
                    }
                    catch (IllegalAccessException e) {
                        List<Object> entries = Arrays.asList(e, "Proceeding with taglib resolution.");
                        this.log.log("error", entries);
                    }
                    catch (UndeclaredThrowableException e) {
                        List<Object> entries = Arrays.asList(e, "Proceeding with taglib resolution.");
                        this.log.log("error", entries);
                    }
                }
            }
            return evaluator;
        }
    }

    public void setLog(MarmaladeLog log) {
        this.log = log;
    }
}

