/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.launch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.codehaus.marmalade.discovery.TaglibResolutionStrategy;
import org.codehaus.marmalade.el.ExpressionEvaluator;
import org.codehaus.marmalade.launch.MarmaladeLaunchException;
import org.codehaus.marmalade.metamodel.MarmaladeTagLibrary;
import org.codehaus.marmalade.metamodel.ModelBuilderException;
import org.codehaus.marmalade.metamodel.ScriptBuilder;
import org.codehaus.marmalade.model.MarmaladeScript;
import org.codehaus.marmalade.monitor.log.DefaultLog;
import org.codehaus.marmalade.monitor.log.MarmaladeLog;
import org.codehaus.marmalade.parsing.DefaultParsingContext;
import org.codehaus.marmalade.parsing.MarmaladeParsetimeException;
import org.codehaus.marmalade.parsing.ScriptParser;
import org.codehaus.marmalade.runtime.DefaultContext;
import org.codehaus.marmalade.runtime.MarmaladeExecutionContext;
import org.codehaus.marmalade.runtime.MarmaladeExecutionException;

public class MarmaladeLauncher {
    private final DefaultParsingContext parsingContext = new DefaultParsingContext();
    private final DefaultContext executionContext = new DefaultContext();
    private ScriptParser scriptParser;
    private boolean returnUnexternalized = false;
    private ScriptBuilder builder;
    private MarmaladeScript script;
    private MarmaladeLog log = new DefaultLog();

    public MarmaladeLauncher withUnexternalizedVarsReturned(boolean returnUnexternalized) {
        this.returnUnexternalized = returnUnexternalized;
        return this;
    }

    public MarmaladeLauncher withClassLoader(ClassLoader classloader) {
        this.parsingContext.setClassLoader(classloader);
        return this;
    }

    public MarmaladeLauncher withAdditionalTaglibDefinitionStrategies(Collection strategies) {
        this.parsingContext.addTaglibDefinitionStrategies(strategies);
        return this;
    }

    public MarmaladeLauncher withAdditionalTaglibDefinitionStrategy(TaglibResolutionStrategy strategy) {
        this.parsingContext.addTaglibDefinitionStrategy(strategy);
        return this;
    }

    public MarmaladeLauncher withDefaultExpressionEvaluator(ExpressionEvaluator evaluator) {
        this.parsingContext.setDefaultExpressionEvaluator(evaluator);
        return this;
    }

    public MarmaladeLauncher withDefaultTagLibrary(MarmaladeTagLibrary taglib) {
        this.log.log("debug", "Using default tag library: " + taglib);
        this.parsingContext.setDefaultTagLibrary(taglib);
        return this;
    }

    public MarmaladeLauncher withInput(Reader input) {
        this.parsingContext.setInput(input);
        return this;
    }

    public MarmaladeLauncher withInputURL(URL url) throws IOException {
        this.log.log("debug", "Input script URL: " + url);
        this.parsingContext.setInputLocation(url.toExternalForm());
        this.parsingContext.setInput(new InputStreamReader(url.openStream()));
        return this;
    }

    public MarmaladeLauncher withInputFile(File file) throws IOException {
        this.parsingContext.setInputLocation(file.getCanonicalPath());
        this.parsingContext.setInput(new BufferedReader(new FileReader(file)));
        return this;
    }

    public MarmaladeLauncher withInputScriptString(String script, String locationDescription) {
        this.parsingContext.setInputLocation(locationDescription);
        this.parsingContext.setInput(new StringReader(script));
        return this;
    }

    public MarmaladeLauncher withInputLocation(String inputLocation) {
        this.parsingContext.setInputLocation(inputLocation);
        return this;
    }

    public MarmaladeLauncher withTaglibDefinitionStrategies(Collection strategies) {
        this.parsingContext.setTaglibDefinitionStrategies(strategies);
        return this;
    }

    public MarmaladeLauncher withImportedContext(MarmaladeExecutionContext context) {
        this.executionContext.importContext(context);
        return this;
    }

    public MarmaladeLauncher withPreserveWhitespaceOverride(Boolean shouldOverride) {
        this.executionContext.preserveWhitespaceOverride(shouldOverride);
        return this;
    }

    public MarmaladeLauncher withPreserveWhitespaceOverride(boolean shouldOverride) {
        this.executionContext.preserveWhitespaceOverride(shouldOverride);
        return this;
    }

    public MarmaladeLauncher withoutVariable(Object key) {
        this.executionContext.removeVariable(key);
        return this;
    }

    public MarmaladeLauncher withErrWriter(PrintWriter err) {
        this.executionContext.setErrWriter(err);
        return this;
    }

    public MarmaladeLauncher withInReader(Reader in) {
        this.executionContext.setInReader(in);
        return this;
    }

    public MarmaladeLauncher withLog(MarmaladeLog log) {
        if (log != null) {
            this.log = log;
            this.executionContext.setLog(log);
            this.parsingContext.setLog(log);
        }
        log.log("debug", "Setting log on launcher.");
        return this;
    }

    public MarmaladeLauncher withOutWriter(PrintWriter out) {
        this.executionContext.setOutWriter(out);
        return this;
    }

    public MarmaladeLauncher withVariable(Object key, Object value) {
        this.executionContext.setVariable(key, value);
        return this;
    }

    public MarmaladeLauncher withVariable(Object key, Object value, boolean externalize) {
        this.executionContext.setVariable(key, value, externalize);
        return this;
    }

    public MarmaladeLauncher withVariables(Map vars) {
        this.executionContext.setVariables(vars);
        return this;
    }

    public MarmaladeLauncher withVariables(Map vars, boolean externalize) {
        this.executionContext.setVariables(vars, externalize);
        return this;
    }

    public MarmaladeLauncher withParser(ScriptParser parser) {
        this.scriptParser = parser;
        return this;
    }

    public Map run() throws MarmaladeLaunchException {
        this.buildScript();
        try {
            this.script.execute(this.executionContext);
        }
        catch (MarmaladeExecutionException e) {
            throw new MarmaladeLaunchException("Cannot launch marmalade script. There was an execution-time (runtime) error.", e);
        }
        Map vars = null;
        vars = !this.returnUnexternalized ? this.executionContext.getExternalizedVariables() : this.executionContext.getVariablesAsResolved();
        return vars;
    }

    public MarmaladeScript buildScript() throws MarmaladeLaunchException {
        this.parse();
        if (this.script == null) {
            this.log.log("debug", "building script instance.");
            try {
                this.script = this.builder.build();
                this.script.setLog(this.log);
            }
            catch (ModelBuilderException e) {
                throw new MarmaladeLaunchException("Cannot launch marmalade script. There was a problem building script hierarchy from metadata.", e);
            }
        }
        this.log.log("debug", "Script is: " + this.script);
        return this.script;
    }

    public ScriptBuilder parse() throws MarmaladeLaunchException {
        if (this.builder == null) {
            this.log.log("debug", "parsing script builder.");
            try {
                if (this.scriptParser == null) {
                    this.scriptParser = new ScriptParser();
                    this.scriptParser.setLog(this.log);
                }
                this.builder = this.scriptParser.parse(this.parsingContext);
            }
            catch (MarmaladeParsetimeException e) {
                throw new MarmaladeLaunchException("Cannot launch marmalade script. There was a parsetime error.", e);
            }
        }
        this.log.log("debug", "Builder is: " + this.builder);
        return this.builder;
    }

    public MarmaladeScript getMarmaladeScript() throws MarmaladeLaunchException {
        this.log.log("debug", "Getting script instance...");
        return this.buildScript();
    }

    public ScriptBuilder getScriptBuilder() throws MarmaladeLaunchException {
        return this.parse();
    }
}

