/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.codehaus.marmalade.el.BareBonesExpressionEvaluator;
import org.codehaus.marmalade.el.ExpressionEvaluationException;
import org.codehaus.marmalade.el.ExpressionEvaluator;
import org.codehaus.marmalade.metamodel.MarmaladeTagInfo;
import org.codehaus.marmalade.model.DefaultAttributes;
import org.codehaus.marmalade.model.MarmaladeAttributes;
import org.codehaus.marmalade.model.MarmaladeTag;
import org.codehaus.marmalade.model.ScriptStructureSupport;
import org.codehaus.marmalade.runtime.IllegalScriptStructureException;
import org.codehaus.marmalade.runtime.MarmaladeExecutionContext;
import org.codehaus.marmalade.runtime.MarmaladeExecutionException;
import org.codehaus.marmalade.runtime.MissingAttributeException;
import org.codehaus.marmalade.runtime.TagExecutionException;

public abstract class AbstractMarmaladeTag
implements MarmaladeTag {
    private ExpressionEvaluator el;
    private MarmaladeAttributes attributes;
    private MarmaladeTagInfo tagInfo;
    private boolean childrenProcessed = false;
    private List children = new ArrayList();
    private MarmaladeTag parent;
    private StringBuffer bodyText;
    private boolean bodyProcessed;
    private boolean preserveBodyWhitespace = false;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    protected AbstractMarmaladeTag() {
    }

    public final void setAttributes(MarmaladeAttributes attributes) {
        this.attributes = attributes;
    }

    public final void setExpressionEvaluator(ExpressionEvaluator el) {
        this.el = el;
        if (this.attributes != null) {
            this.attributes.setExpressionEvaluator(el);
        }
    }

    public final void setTagInfo(MarmaladeTagInfo tagInfo) {
        this.tagInfo = tagInfo;
    }

    public final MarmaladeTagInfo getTagInfo() {
        return this.tagInfo;
    }

    public final void setParent(MarmaladeTag parent) {
        this.parent = parent;
    }

    public void addChild(MarmaladeTag child) {
        this.children.add(child);
    }

    public final MarmaladeTag getParent() {
        return this.parent;
    }

    protected void doExecute(MarmaladeExecutionContext context) throws MarmaladeExecutionException {
    }

    protected boolean alwaysProcessChildren() {
        return true;
    }

    protected boolean alwaysProcessBody() {
        return true;
    }

    protected void doReset() {
    }

    protected boolean shouldAddChild(MarmaladeTag child) {
        return true;
    }

    public void appendBodyText(String text) {
        if (this.bodyText == null) {
            this.bodyText = new StringBuffer();
        }
        this.bodyText.append(text);
    }

    public final void execute(MarmaladeExecutionContext context) throws MarmaladeExecutionException {
        this.doExecute(context);
        if (!this.childrenProcessed && this.alwaysProcessChildren()) {
            this.processChildren(context);
        }
        if (!this.bodyProcessed && this.alwaysProcessBody()) {
            this.processBody(context);
        }
        this.reset();
    }

    protected final void resetChildrenProcessedFlag() {
        this.childrenProcessed = false;
    }

    protected final void resetBodyProcessedFlag() {
        this.bodyProcessed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processChildren(MarmaladeExecutionContext context) throws MarmaladeExecutionException {
        try {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                MarmaladeTag child = (MarmaladeTag)it.next();
                child.execute(context);
            }
        }
        finally {
            this.childrenProcessed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processBody(MarmaladeExecutionContext context) throws MarmaladeExecutionException {
        try {
            Object bodyValue = this._getBody(context, class$java$lang$Object == null ? (class$java$lang$Object = AbstractMarmaladeTag.class$("java.lang.Object")) : class$java$lang$Object);
            if (bodyValue != null) {
                String bodyContent = String.valueOf(bodyValue);
                context.getOutWriter().print(this.formatWhitespace(bodyContent, context));
            }
        }
        finally {
            this.bodyProcessed = true;
        }
    }

    protected final List children() {
        return Collections.unmodifiableList(this.children);
    }

    protected final void reset() {
        this.doReset();
        this.childrenProcessed = false;
    }

    public final synchronized MarmaladeAttributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new DefaultAttributes();
        }
        return this.attributes;
    }

    public final synchronized ExpressionEvaluator getExpressionEvaluator() {
        if (this.el == null) {
            this.el = new BareBonesExpressionEvaluator();
        }
        return this.el;
    }

    public final Object getBody(MarmaladeExecutionContext context) throws ExpressionEvaluationException {
        return this._getBody(context, class$java$lang$Object == null ? (class$java$lang$Object = AbstractMarmaladeTag.class$("java.lang.Object")) : class$java$lang$Object);
    }

    public final Object getBody(MarmaladeExecutionContext context, Class targetType) throws ExpressionEvaluationException {
        return this._getBody(context, targetType);
    }

    protected final String getRawBody(MarmaladeExecutionContext context) throws ExpressionEvaluationException {
        if (this.bodyText == null) {
            return null;
        }
        return this.formatWhitespace(this.bodyText.toString(), context);
    }

    protected String formatWhitespace(String src, MarmaladeExecutionContext context) throws ExpressionEvaluationException {
        boolean presWSOver;
        String formatted = src;
        Boolean preserveWSOverride = context.preserveWhitespaceOverride();
        boolean bl = presWSOver = preserveWSOverride != null ? preserveWSOverride : false;
        if (!(presWSOver || this.preserveBodyWhitespace || this.preserveBodyWhitespace(context))) {
            formatted = formatted.replaceAll("\\s+", " ").trim();
        }
        return formatted;
    }

    public void setPreserveBodyWhitespace(boolean preserve) {
        this.preserveBodyWhitespace = preserve;
    }

    protected boolean preserveBodyWhitespace(MarmaladeExecutionContext context) throws ExpressionEvaluationException {
        MarmaladeAttributes attributes = this.getAttributes();
        Boolean preserveWS = (Boolean)attributes.getValue("marmalade-control", "preserve-whitespace", class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractMarmaladeTag.class$("java.lang.Boolean")) : class$java$lang$Boolean, context, Boolean.TRUE);
        return preserveWS;
    }

    private Object _getBody(MarmaladeExecutionContext context, Class targetType) throws ExpressionEvaluationException {
        if (this.bodyText == null) {
            return null;
        }
        String expression = this.bodyText.toString();
        Object result = null;
        if (expression != null && expression.length() > 0) {
            expression = this.formatWhitespace(expression, context);
            if (this.el == null) {
                this.el = new BareBonesExpressionEvaluator();
            }
            result = this.el.evaluate(expression, context.unmodifiableVariableMap(), targetType);
        }
        this.bodyProcessed = true;
        return result;
    }

    protected File getTagAttributeAsFile(String name, MarmaladeExecutionContext context, boolean requireExists) throws ExpressionEvaluationException, TagExecutionException {
        String path = (String)this.getAttributes().getValue(name, class$java$lang$String == null ? (class$java$lang$String = AbstractMarmaladeTag.class$("java.lang.String")) : class$java$lang$String, context);
        path = path.replaceAll("[\\/]{2}", "/");
        File file = new File(path);
        if (requireExists && !file.exists()) {
            throw new TagExecutionException(this.getTagInfo(), "Specified path is required to exist but does not.");
        }
        return file;
    }

    protected File requireTagAttributeAsFile(String name, MarmaladeExecutionContext context, boolean requireExists) throws MissingAttributeException, ExpressionEvaluationException, TagExecutionException {
        String path = (String)ScriptStructureSupport.requireTagAttribute(this, name, class$java$lang$String == null ? (class$java$lang$String = AbstractMarmaladeTag.class$("java.lang.String")) : class$java$lang$String, context);
        path = path.replaceAll("[\\/]{2}", "/");
        File file = new File(path);
        if (requireExists && !file.exists()) {
            throw new TagExecutionException(this.getTagInfo(), "Specified path is required to exist but does not.");
        }
        return file;
    }

    protected Object requireTagAttribute(String name, Class type, MarmaladeExecutionContext context) throws MissingAttributeException, ExpressionEvaluationException {
        return ScriptStructureSupport.requireTagAttribute(this, name, type, context);
    }

    protected Object requireTagAttribute(String name, MarmaladeExecutionContext context) throws MissingAttributeException, ExpressionEvaluationException {
        return ScriptStructureSupport.requireTagAttribute(this, name, class$java$lang$Object == null ? (class$java$lang$Object = AbstractMarmaladeTag.class$("java.lang.Object")) : class$java$lang$Object, context);
    }

    protected void deprecateTagAttribute(String name, MarmaladeExecutionContext context) throws MissingAttributeException, ExpressionEvaluationException {
        ScriptStructureSupport.deprecateTagAttribute(this, name, context);
    }

    protected MarmaladeTag requireParent(Class cls) throws IllegalScriptStructureException {
        return ScriptStructureSupport.requireParent(this, cls);
    }

    protected MarmaladeTag getAncestor(Class cls) {
        return ScriptStructureSupport.getAncestor(this, cls);
    }

    protected MarmaladeTag requireAncestor(Class cls) throws IllegalScriptStructureException {
        return ScriptStructureSupport.requireAncestor(this, cls);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

