/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.reader.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.marmalade.el.ExpressionEvaluator;
import org.codehaus.marmalade.el.ExpressionEvaluatorFactory;
import org.codehaus.marmalade.metamodel.DefaultRawAttributes;
import org.codehaus.marmalade.metamodel.MarmaladeTagBuilder;
import org.codehaus.marmalade.metamodel.MarmaladeTagInfo;
import org.codehaus.marmalade.metamodel.MarmaladeTagLibrary;
import org.codehaus.marmalade.metamodel.MarmaladeTaglibResolver;
import org.codehaus.marmalade.metamodel.ScriptBuilder;
import org.codehaus.marmalade.metamodel.TaglibResolutionException;
import org.codehaus.marmalade.parsing.MarmaladeParsingContext;
import org.codehaus.marmalade.parsing.ParserHint;
import org.codehaus.marmalade.reader.ScriptReadException;
import org.codehaus.marmalade.reader.ScriptReader;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class Xpp3ScriptReader
implements ScriptReader {
    public static final Pattern EL_PI_PATTERN = Pattern.compile("marmalade-control:el (.+)");

    public ScriptBuilder readScript(MarmaladeParsingContext context) throws ScriptReadException, IOException {
        try {
            this.validateParsingContext(context);
            MXParser parser = new MXParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((Reader)context.getInput());
            MarmaladeTagBuilder currentBuilder = null;
            ParserHint currentParserHint = null;
            ExpressionEvaluatorFactory factory = context.getExpressionEvaluatorFactory();
            ExpressionEvaluator defaultEl = context.getDefaultExpressionEvaluator();
            int eventType = parser.getEventType();
            while (eventType != 1) {
                String piText;
                Matcher matcher;
                MarmaladeTagInfo tagInfo;
                MarmaladeTagBuilder parent;
                if (eventType == 2) {
                    if (currentParserHint != null && !currentParserHint.parseChildren()) {
                        context.getInput().startRecording();
                    } else {
                        String ns;
                        int colonIdx;
                        parent = null;
                        if (currentBuilder != null) {
                            parent = currentBuilder;
                        }
                        tagInfo = new MarmaladeTagInfo();
                        currentBuilder = new MarmaladeTagBuilder();
                        currentBuilder.startParsing(context);
                        if (parent != null) {
                            currentBuilder.setParent(parent);
                            parent.addChild(currentBuilder);
                        }
                        String scheme = (colonIdx = (ns = parser.getNamespace()).indexOf(":")) > 0 ? ns.substring(0, colonIdx) : null;
                        String taglib = colonIdx > 0 ? ns.substring(colonIdx + 1) : ns;
                        tagInfo.setElement(parser.getName());
                        tagInfo.setScheme(scheme);
                        tagInfo.setTaglib(taglib);
                        tagInfo.setPrefix(parser.getPrefix());
                        tagInfo.setSourceLine(parser.getLineNumber());
                        tagInfo.setSourceColumn(parser.getColumnNumber());
                        tagInfo.setSourceFile(context.getInputLocation());
                        DefaultRawAttributes attributes = new DefaultRawAttributes();
                        int attributeCount = parser.getAttributeCount();
                        for (int i = 0; i < attributeCount; ++i) {
                            String aPrefix = parser.getAttributePrefix(i);
                            String aNamespace = parser.getAttributeNamespace(i);
                            String aName = parser.getAttributeName(i);
                            String aValue = parser.getAttributeValue(i);
                            attributes.addAttribute(aPrefix, aNamespace, aName, aValue);
                            if (!"marmalade-control".equals(aNamespace) || !"el".equals(aName)) continue;
                            defaultEl = factory.getExpressionEvaluator(aValue);
                        }
                        currentBuilder.setAttributes(attributes);
                        currentBuilder.setTagInfo(tagInfo);
                        MarmaladeTaglibResolver resolver = context.getTaglibResolver();
                        MarmaladeTagLibrary tagLibrary = resolver.resolve(scheme, taglib);
                        currentParserHint = tagLibrary.getParserHint(parser.getName());
                        currentBuilder.setTagLibrary(tagLibrary);
                        currentBuilder.setExpressionEvaluator(defaultEl);
                    }
                } else if (eventType == 4) {
                    if (currentParserHint != null && currentParserHint.parseChildren() && currentBuilder != null) {
                        currentBuilder.addText(parser.getText());
                    }
                } else if (eventType == 3) {
                    if (currentBuilder != null) {
                        if (currentParserHint != null && !currentParserHint.parseChildren()) {
                            String body = context.getInput().getRecordedInput();
                            currentBuilder.addText(body);
                        }
                        if ((parent = currentBuilder.getParent()) != null) {
                            currentBuilder = parent;
                            tagInfo = parent.getTagInfo();
                            MarmaladeTagLibrary tagLibrary = parent.getTagLibrary();
                            currentParserHint = tagLibrary.getParserHint(tagInfo.getElement());
                        }
                    }
                } else if (eventType == 8 && (matcher = EL_PI_PATTERN.matcher(piText = parser.getText())).matches()) {
                    String elType = matcher.group(1);
                    defaultEl = factory.getExpressionEvaluator(elType);
                }
                eventType = parser.nextToken();
            }
            ScriptBuilder builder = new ScriptBuilder(context.getInputLocation(), currentBuilder);
            return builder;
        }
        catch (XmlPullParserException e) {
            throw new ScriptReadException(e);
        }
        catch (TaglibResolutionException e) {
            throw new ScriptReadException(e);
        }
    }

    private void validateParsingContext(MarmaladeParsingContext context) {
        if (context.getInput() == null) {
            throw new IllegalStateException("context input cannot be null");
        }
        if (!context.getTaglibResolver().hasStrategies()) {
            context.addTaglibDefinitionStrategies(MarmaladeTaglibResolver.DEFAULT_STRATEGY_CHAIN);
        }
    }
}

