/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.codehaus.marmalade.el.BareBonesExpressionEvaluator;
import org.codehaus.marmalade.el.ExpressionEvaluationException;
import org.codehaus.marmalade.el.ExpressionEvaluator;
import org.codehaus.marmalade.monitor.event.ComposableDispatcherManager;
import org.codehaus.marmalade.monitor.event.EventDispatcherManager;
import org.codehaus.marmalade.monitor.event.context.ContextEventDispatcher;
import org.codehaus.marmalade.monitor.event.context.DefaultContextEventDispatcher;
import org.codehaus.marmalade.monitor.log.DefaultLog;
import org.codehaus.marmalade.monitor.log.MarmaladeLog;
import org.codehaus.marmalade.runtime.MarmaladeExecutionContext;
import org.codehaus.marmalade.util.ScopedMap;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class DefaultContext
implements MarmaladeExecutionContext {
    private static final PrintWriter SYSOUT = new PrintWriter(new OutputStreamWriter(System.out));
    private static final PrintWriter SYSERR = new PrintWriter(new OutputStreamWriter(System.err));
    private static final Reader SYSIN = new BufferedReader(new InputStreamReader(System.in));
    public static final String PRESERVE_WS_OVERRIDE_VARIABLE = "marmalade:preserve-whitespace-override";
    private Map context;
    private Map systemContext;
    private PrintWriter out = SYSOUT;
    private PrintWriter err = SYSERR;
    private Reader in = SYSIN;
    private XmlSerializer xmlSerializer;
    private Set externalized = new HashSet();
    private EventDispatcherManager eventDispatcherManager;
    private ContextEventDispatcher contextDispatcher;
    private MarmaladeLog log;
    static /* synthetic */ Class class$java$lang$Object;

    public DefaultContext() {
        this.systemContext = Collections.unmodifiableMap(new TreeMap<Object, Object>(System.getProperties()));
        this.context = new ScopedMap(this.systemContext);
        this.buildDefaultEventDispatcher();
    }

    public DefaultContext(Map context) {
        this.systemContext = new HashMap();
        this.systemContext.putAll(System.getProperties());
        this.systemContext = Collections.unmodifiableMap(this.systemContext);
        this.context = new ScopedMap(this.systemContext);
        this.context.putAll(context);
        this.buildDefaultEventDispatcher();
    }

    public DefaultContext(EventDispatcherManager eventDispatcherManager) {
        this.systemContext = Collections.unmodifiableMap(new TreeMap<Object, Object>(System.getProperties()));
        this.context = new ScopedMap(this.systemContext);
        this.eventDispatcherManager = eventDispatcherManager;
        this.contextDispatcher = eventDispatcherManager.getContextDispatcher();
    }

    public DefaultContext(Map context, EventDispatcherManager eventDispatcherManager) {
        this.systemContext = new HashMap();
        this.systemContext.putAll(System.getProperties());
        this.systemContext = Collections.unmodifiableMap(this.systemContext);
        this.context = new ScopedMap(this.systemContext);
        this.context.putAll(context);
        this.eventDispatcherManager = eventDispatcherManager;
        this.contextDispatcher = eventDispatcherManager.getContextDispatcher();
    }

    public void setLog(MarmaladeLog log) {
        if (log == null) {
            this.log = log;
        }
    }

    public synchronized MarmaladeLog getLog() {
        if (this.log == null) {
            this.log = new DefaultLog();
        }
        return this.log;
    }

    private void buildDefaultEventDispatcher() {
        ComposableDispatcherManager mgr = new ComposableDispatcherManager();
        DefaultContextEventDispatcher ctxDispatcher = new DefaultContextEventDispatcher();
        mgr.initContextDispatcher(ctxDispatcher);
        this.eventDispatcherManager = mgr;
        this.contextDispatcher = ctxDispatcher;
    }

    public void setOutWriter(PrintWriter out) {
        PrintWriter old = this.out;
        this.out = out;
        this.contextDispatcher.outWriterChanged(old, out);
    }

    public void setErrWriter(PrintWriter err) {
        PrintWriter old = this.err;
        this.err = err;
        this.contextDispatcher.errWriterChanged(old, err);
    }

    public void setInReader(Reader in) {
        Reader old = this.in;
        this.in = in;
        this.contextDispatcher.inReaderChanged(old, in);
    }

    public Object getVariable(Object key, ExpressionEvaluator el) throws ExpressionEvaluationException {
        Object result = this.context.get(key);
        if (el == null) {
            el = new BareBonesExpressionEvaluator();
        }
        if (result != null && result instanceof String) {
            result = el.evaluate((String)result, this.context, class$java$lang$Object == null ? (class$java$lang$Object = DefaultContext.class$("java.lang.Object")) : class$java$lang$Object);
        }
        return result;
    }

    public Object setVariable(Object key, Object value) {
        this.contextDispatcher.variableSet(key, value, false);
        return this.context.put(key, value);
    }

    public Object setVariable(Object key, Object value, boolean externalize) {
        if (externalize) {
            this.externalized.add(key);
        }
        this.contextDispatcher.variableSet(key, value, externalize);
        return this.context.put(key, value);
    }

    public Object removeVariable(Object key) {
        Object result = this.context.remove(key);
        this.externalized.remove(key);
        this.contextDispatcher.variableRemoved(key);
        return result;
    }

    public Map unmodifiableVariableMap() {
        return Collections.unmodifiableMap(this.context);
    }

    public void newScope() {
        this.context = new ScopedMap(this.context);
        this.contextDispatcher.scopeCreated();
    }

    public Map lastScope() {
        return this._lastScope(false);
    }

    public Map lastScope(boolean export) {
        return this._lastScope(export);
    }

    private Map _lastScope(boolean export) {
        Map replaced = null;
        if (this.context instanceof ScopedMap) {
            Map parent = ((ScopedMap)this.context).getSuperMap();
            Map local = ((ScopedMap)this.context).getLocalMap();
            if (parent != null && parent instanceof ScopedMap) {
                this.context = parent;
                replaced = local;
            }
        }
        if (replaced != null && export) {
            this.context.putAll(replaced);
        }
        this.contextDispatcher.scopeRestored();
        return replaced;
    }

    public PrintWriter getErrWriter() {
        return this.err;
    }

    public PrintWriter getOutWriter() {
        return this.out;
    }

    public Reader getInReader() {
        return this.in;
    }

    public Boolean preserveWhitespaceOverride() {
        return (Boolean)this.context.get(PRESERVE_WS_OVERRIDE_VARIABLE);
    }

    public void preserveWhitespaceOverride(Boolean shouldOverride) {
        if (shouldOverride == null) {
            this.context.remove(PRESERVE_WS_OVERRIDE_VARIABLE);
        } else {
            this.context.put(PRESERVE_WS_OVERRIDE_VARIABLE, shouldOverride);
        }
    }

    public void importContext(MarmaladeExecutionContext otherContext) {
        Map vars = otherContext.unmodifiableVariableMap();
        this.context.putAll(vars);
    }

    public void setVariables(Map vars) {
        this.context.putAll(vars);
    }

    public void setVariables(Map vars, boolean externalize) {
        if (externalize) {
            Iterator it = vars.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                this.externalized.add(key);
            }
        }
        this.context.putAll(vars);
    }

    public XmlSerializer getXmlSerializer() throws XmlPullParserException, IOException {
        if (this.xmlSerializer == null) {
            this.xmlSerializer = new MXSerializer();
            this.xmlSerializer.setOutput((Writer)this.getOutWriter());
        }
        return this.xmlSerializer;
    }

    public Map getExternalizedVariables(ExpressionEvaluator el) throws ExpressionEvaluationException {
        return this.getVariablesAsResolved(this.externalized, el);
    }

    public Map getExternalizedVariables() {
        try {
            return this.getVariablesAsResolved(this.externalized, null);
        }
        catch (ExpressionEvaluationException e) {
            StringWriter sWriter = new StringWriter();
            PrintWriter pWriter = new PrintWriter(sWriter);
            e.printStackTrace(pWriter);
            throw new RuntimeException("This should never, ever happen! Error was:\n" + sWriter.toString());
        }
    }

    public Map getVariablesAsResolved(ExpressionEvaluator el) throws ExpressionEvaluationException {
        return this.getVariablesAsResolved(this.context.keySet(), el);
    }

    public Map getVariablesAsResolved() {
        try {
            return this.getVariablesAsResolved(this.context.keySet(), null);
        }
        catch (ExpressionEvaluationException e) {
            StringWriter sWriter = new StringWriter();
            PrintWriter pWriter = new PrintWriter(sWriter);
            e.printStackTrace(pWriter);
            throw new RuntimeException("This should never, ever happen! Error was:\n" + sWriter.toString());
        }
    }

    private Map getVariablesAsResolved(Set variableKeys, ExpressionEvaluator el) throws ExpressionEvaluationException {
        HashMap result = new HashMap();
        Iterator it = variableKeys.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            result.put(key, this.getVariable(key, el));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

