/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.marmalade.util.ScopedMapEntriesSet;

public class ScopedMap
implements Map {
    private Map superMap;
    private Map thisMap;
    private ScopedMapEntriesSet keySet;
    private ScopedMapEntriesSet valueSet;
    private ScopedMapEntriesSet entrySet;

    public ScopedMap() {
        this.init(Collections.EMPTY_MAP);
    }

    public ScopedMap(Map superMap) {
        this.init(superMap);
    }

    private void init(Map superMap) {
        Map m = superMap;
        if (m == null) {
            m = Collections.EMPTY_MAP;
        }
        this.superMap = m;
        this.thisMap = new HashMap();
        this.entrySet = new ScopedMapEntriesSet(superMap, this.thisMap, null);
        this.keySet = new ScopedMapEntriesSet(superMap, this.thisMap, Boolean.TRUE);
        this.valueSet = new ScopedMapEntriesSet(superMap, this.thisMap, Boolean.FALSE);
    }

    public Map getSuperMap() {
        return this.superMap;
    }

    public Map getLocalMap() {
        return this.thisMap;
    }

    private void update() {
        this.entrySet.update();
        this.keySet.update();
        this.valueSet.update();
    }

    public int size() {
        return this.superMap.size() + this.thisMap.size();
    }

    public void clear() {
        this.thisMap.clear();
        this.update();
    }

    public boolean isEmpty() {
        return this.superMap.isEmpty() && this.thisMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.thisMap.containsKey(key) || this.superMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.thisMap.containsValue(value) || this.superMap.containsValue(value);
    }

    public Collection values() {
        return this.valueSet;
    }

    public void putAll(Map t) {
        boolean changed = false;
        Iterator it = t.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (this.superMap.containsKey(key)) continue;
            this.thisMap.put(key, t.get(key));
            changed = true;
        }
        if (changed) {
            this.update();
        }
    }

    public Set entrySet() {
        return this.entrySet;
    }

    public Set keySet() {
        return this.keySet;
    }

    public Object get(Object key) {
        Object result = this.thisMap.get(key);
        if (result == null) {
            result = this.superMap.get(key);
        }
        return result;
    }

    public Object remove(Object key) {
        Object result = this.thisMap.remove(key);
        if (result != null) {
            this.update();
        }
        return result;
    }

    public Object put(Object key, Object value) {
        Object result = null;
        result = this.thisMap.put(key, value);
        this.update();
        return result;
    }

    public String toString() {
        return "ScopedMap:\n==========================\nlocal:\n\t" + String.valueOf(this.thisMap) + "\n\nparent:\n\t" + String.valueOf(this.superMap);
    }
}

