/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.marmalade.util.ScopedMapEntriesIterator;
import org.codehaus.marmalade.util.ScopedMapEntry;

public class ScopedMapEntriesSet
implements Set {
    private Map superMap;
    private Map thisMap;
    private Boolean extractKey;
    private List entries = new ArrayList();

    public ScopedMapEntriesSet(Map superMap, Map thisMap, Boolean extractKey) {
        this.superMap = superMap;
        this.thisMap = thisMap;
        this.extractKey = extractKey;
        this.update();
    }

    public Object extract(ScopedMapEntry entry) {
        if (this.extractKey == null) {
            return entry;
        }
        if (Boolean.TRUE == this.extractKey) {
            return entry.getKey();
        }
        return entry.getValue();
    }

    public int size() {
        return this.entries.size();
    }

    public void clear() {
        this.thisMap.clear();
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            ScopedMapEntry entry = (ScopedMapEntry)it.next();
            if (!entry.isMutable()) continue;
            it.remove();
        }
    }

    public boolean isEmpty() {
        return this.thisMap.isEmpty() && this.superMap.isEmpty();
    }

    public Object[] toArray() {
        Object[] objects = new Object[this.entries.size()];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = this.extract((ScopedMapEntry)this.entries.get(i));
        }
        return objects;
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException("Add operation is not supported.");
    }

    public boolean contains(Object o) {
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            if (!this.extract((ScopedMapEntry)it.next()).equals(o)) continue;
            return true;
        }
        return false;
    }

    public boolean remove(Object o) {
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            ScopedMapEntry entry = (ScopedMapEntry)it.next();
            if (!this.extract(entry).equals(o)) continue;
            if (entry.isMutable()) {
                it.remove();
                this.thisMap.remove(entry.getKey());
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException("Add-all operation is not supported.");
    }

    public boolean containsAll(Collection c) {
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            if (c.contains(this.extract((ScopedMapEntry)it.next()))) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection c) {
        boolean changed = false;
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            ScopedMapEntry entry = (ScopedMapEntry)it.next();
            if (!c.contains(this.extract(entry)) || !entry.isMutable()) continue;
            it.remove();
            this.thisMap.remove(entry.getKey());
            changed = true;
        }
        return changed;
    }

    public boolean retainAll(Collection c) {
        boolean changed = false;
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            ScopedMapEntry entry = (ScopedMapEntry)it.next();
            if (c.contains(this.extract(entry)) || !entry.isMutable()) continue;
            it.remove();
            this.thisMap.remove(entry.getKey());
            changed = true;
        }
        return changed;
    }

    public Iterator iterator() {
        return new ScopedMapEntriesIterator(this, this.extractKey);
    }

    public Object[] toArray(Object[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.entries.get(i);
        }
        if (this.entries.size() > a.length) {
            throw new ArrayIndexOutOfBoundsException(a.length);
        }
        return a;
    }

    Iterator entryIterator() {
        return this.entries.iterator();
    }

    void removeEntry(ScopedMapEntry entry) {
        if (entry.isMutable()) {
            this.entries.remove(entry);
            this.thisMap.remove(entry.getKey());
        }
    }

    void update() {
        Map.Entry entry;
        Iterator it = this.superMap.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            Object key = entry.getKey();
            if (this.thisMap.containsKey(key)) continue;
            ScopedMapEntry sme = new ScopedMapEntry(entry, false);
            this.entries.add(sme);
        }
        it = this.thisMap.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            ScopedMapEntry sme = new ScopedMapEntry(entry, true);
            this.entries.add(sme);
        }
    }
}

