/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.codehaus.marmalade.metamodel.MarmaladeTagInfo;

public final class TagRelatedProblemSupport {
    private MarmaladeTagInfo tagInfo;
    private boolean suppressVerboseStackTraceOutput = false;

    public TagRelatedProblemSupport(MarmaladeTagInfo tagInfo) {
        this.tagInfo = tagInfo;
    }

    public boolean suppressVerboseStackTraceOutput() {
        return this.suppressVerboseStackTraceOutput;
    }

    public void setSuppressVerboseStackTraceOutput(boolean suppressVerboseStackTraceOutput) {
        this.suppressVerboseStackTraceOutput = suppressVerboseStackTraceOutput;
    }

    public MarmaladeTagInfo getOffendingTagInfo() {
        return this.tagInfo;
    }

    public String getSourceFile() {
        return this.tagInfo.getSourceFile();
    }

    public int getSourceLine() {
        return this.tagInfo.getSourceLine();
    }

    public void printStackTrace(Exception owningException) {
        this.printStackTrace(owningException, System.err);
    }

    public void printStackTrace(Exception owningException, PrintStream err) {
        err.println(this.getFormattedProblemStatistics());
        err.println("\nException Message: " + owningException.getLocalizedMessage());
        StackTraceElement[] traceElements = owningException.getStackTrace();
        for (int i = 0; i < traceElements.length; ++i) {
            err.println("    " + traceElements[i]);
        }
    }

    public void printStackTrace(Exception owningException, PrintWriter err) {
        err.println(this.getFormattedProblemStatistics());
        err.println("\nException Message: " + owningException.getLocalizedMessage());
        StackTraceElement[] traceElements = owningException.getStackTrace();
        for (int i = 0; i < traceElements.length; ++i) {
            err.println("    " + traceElements[i]);
        }
    }

    private String getFormattedProblemStatistics() {
        StringBuffer buffer = new StringBuffer();
        if (!this.suppressVerboseStackTraceOutput) {
            buffer.append("There was a tag error in Marmalade! Here are the vital statistics:").append("\n  o Element: ").append(this.tagInfo.getElement()).append("\n  o File: ").append(this.tagInfo.getSourceFile()).append("\n  o Line: ").append(this.tagInfo.getSourceLine());
        }
        return buffer.toString();
    }
}

