/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.discovery.tld;

import java.io.IOException;
import java.io.Reader;
import org.codehaus.marmalade.discovery.tld.TldDefinedTagLibrary;
import org.codehaus.marmalade.metamodel.MarmaladeTagLibrary;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class TldParser {
    public static final String TAGLIB_TAG = "taglib";
    public static final String TAG_TAG = "tag";
    public static final String NAME_TAG = "name";
    public static final String TAGCLASS_TAG = "tagclass";

    public MarmaladeTagLibrary parse(Reader reader) throws XmlPullParserException, IOException, ClassNotFoundException {
        TldDefinedTagLibrary taglib = null;
        MXParser parser = new MXParser();
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
        parser.setInput(reader);
        ClassLoader cloader = Thread.currentThread().getContextClassLoader();
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (TAGLIB_TAG.equals(parser.getName())) {
                    taglib = new TldDefinedTagLibrary();
                } else if (TAG_TAG.equals(parser.getName())) {
                    String tagName = null;
                    Class<?> tagClass = null;
                    while (parser.nextTag() == 2) {
                        if (NAME_TAG.equals(parser.getName())) {
                            tagName = parser.nextText();
                            continue;
                        }
                        if (!TAGCLASS_TAG.equals(parser.getName())) continue;
                        String className = parser.nextText();
                        tagClass = cloader.loadClass(className);
                    }
                    taglib.registerTag(tagName, tagClass);
                }
            }
            eventType = parser.next();
        }
        return taglib;
    }
}

