/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.metamodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.marmalade.discovery.LiteralResolutionStrategy;
import org.codehaus.marmalade.discovery.PassThroughResolutionStrategy;
import org.codehaus.marmalade.discovery.PrefixedDefFileResolutionStrategy;
import org.codehaus.marmalade.discovery.PrefixedTldResolutionStrategy;
import org.codehaus.marmalade.discovery.TaglibResolutionStrategy;
import org.codehaus.marmalade.metamodel.MarmaladeTagLibrary;
import org.codehaus.marmalade.metamodel.TaglibResolutionException;
import org.codehaus.marmalade.monitor.log.DefaultLog;
import org.codehaus.marmalade.monitor.log.MarmaladeLog;

public class MarmaladeTaglibResolver {
    public static final List DEFAULT_STRATEGY_CHAIN = Arrays.asList(new LiteralResolutionStrategy(), new PrefixedTldResolutionStrategy(), new PrefixedDefFileResolutionStrategy(), new PassThroughResolutionStrategy());
    public static final List NO_PASSTHROUGH_STRATEGY_CHAIN = Arrays.asList(new LiteralResolutionStrategy(), new PrefixedTldResolutionStrategy(), new PrefixedDefFileResolutionStrategy());
    private List strategies = new LinkedList();
    private String defaultPrefix;
    private MarmaladeTagLibrary defaultTagLibrary;
    private MarmaladeLog log;
    private ClassLoader classloader;

    public boolean hasStrategies() {
        return !this.strategies.isEmpty();
    }

    public void addTaglibDefinitionStrategy(TaglibResolutionStrategy strategy) {
        if (!this.strategies.contains(strategy)) {
            this.strategies.add(strategy);
        }
        if (this.log != null) {
            strategy.setLog(this.log);
        }
    }

    public void addTaglibDefinitionStrategies(Collection strategies) {
        Iterator it = strategies.iterator();
        while (it.hasNext()) {
            TaglibResolutionStrategy strategy = (TaglibResolutionStrategy)it.next();
            this.addTaglibDefinitionStrategy(strategy);
        }
    }

    public void setTaglibDefinitionStrategies(Collection strategies) {
        if (this.log != null) {
            Iterator it = strategies.iterator();
            while (it.hasNext()) {
                TaglibResolutionStrategy strategy = (TaglibResolutionStrategy)it.next();
                strategy.setLog(this.log);
            }
        }
        this.strategies = new ArrayList(strategies);
    }

    public void setDefaultTagLibrary(MarmaladeTagLibrary taglib) {
        this.defaultTagLibrary = taglib;
    }

    public MarmaladeTagLibrary getDefaultTagLibrary() {
        return this.defaultTagLibrary;
    }

    public void setClassLoader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarmaladeTagLibrary resolve(String prefix, String taglib) throws TaglibResolutionException {
        MarmaladeTaglibResolver marmaladeTaglibResolver = this;
        synchronized (marmaladeTaglibResolver) {
            if (this.log == null) {
                this.log = new DefaultLog();
            }
            if (this.classloader == null) {
                this.classloader = this.getClass().getClassLoader();
            }
        }
        this.log.log("debug", "Resolving tag library for: {prefix: '" + prefix + "', taglib: '" + taglib + "'}");
        MarmaladeTagLibrary tlib = null;
        if (!(this.defaultTagLibrary == null || prefix != null && prefix.trim().length() >= 1 || taglib != null && taglib.trim().length() >= 1)) {
            this.log.log("debug", "Using default taglib.");
            tlib = this.defaultTagLibrary;
        } else {
            Iterator it = this.strategies.iterator();
            while (it.hasNext()) {
                TaglibResolutionStrategy strategy = (TaglibResolutionStrategy)it.next();
                tlib = strategy.resolve(prefix, taglib, this.classloader);
                if (tlib == null) continue;
                List<Object> entries = Arrays.asList("resolved taglib: ", tlib, " using strategy: ", strategy);
                this.log.log("debug", entries);
                break;
            }
        }
        if (tlib == null) {
            throw new TaglibResolutionException(prefix, taglib, "Cannot find matching tag library implementation.");
        }
        return tlib;
    }

    public void setLog(MarmaladeLog log) {
        this.log = log;
        if (this.strategies != null) {
            Iterator it = this.strategies.iterator();
            while (it.hasNext()) {
                TaglibResolutionStrategy strategy = (TaglibResolutionStrategy)it.next();
                strategy.setLog(log);
            }
        }
    }
}

