/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.tags.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.marmalade.discovery.TaglibResolutionStrategy;
import org.codehaus.marmalade.metamodel.MarmaladeTaglibResolver;
import org.codehaus.marmalade.metamodel.ModelBuilderException;
import org.codehaus.marmalade.metamodel.ScriptBuilder;
import org.codehaus.marmalade.model.AbstractMarmaladeTag;
import org.codehaus.marmalade.model.MarmaladeAttributes;
import org.codehaus.marmalade.model.MarmaladeScript;
import org.codehaus.marmalade.parsing.DefaultParsingContext;
import org.codehaus.marmalade.parsing.MarmaladeParsetimeException;
import org.codehaus.marmalade.parsing.ScriptParser;
import org.codehaus.marmalade.runtime.MarmaladeExecutionContext;
import org.codehaus.marmalade.runtime.MarmaladeExecutionException;
import org.codehaus.marmalade.runtime.TagExecutionException;
import org.codehaus.marmalade.tags.TaglibResolutionStrategyOwner;
import org.codehaus.marmalade.util.RecordingReader;

public class ImportTag
extends AbstractMarmaladeTag
implements TaglibResolutionStrategyOwner {
    public static final String URL_ATTRIBUTE = "url";
    public static final String VAR_ATTRIBUTE = "var";
    public static final String PARSE_ONLY_ATTRIBUTE = "parse-only";
    public static final String RESOLVER_ATTRIBUTE = "resolver";
    private List strategies = new LinkedList();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExecute(MarmaladeExecutionContext context) throws MarmaladeExecutionException {
        Object location = this.requireTagAttribute(URL_ATTRIBUTE, class$java$lang$Object == null ? (class$java$lang$Object = ImportTag.class$("java.lang.Object")) : class$java$lang$Object, context);
        URL resource = null;
        if (location instanceof URL) {
            resource = (URL)location;
        } else {
            if (location instanceof String) {
                try {
                    resource = new URL((String)location);
                }
                catch (MalformedURLException e) {
                    throw new TagExecutionException(this.getTagInfo(), "Error parsing url into java.net.URL.", e);
                }
            }
            if (!(location instanceof File)) throw new TagExecutionException(this.getTagInfo(), "url attribute must be String, java.net.URL, or java.io.File type.");
            try {
                resource = ((File)location).toURL();
            }
            catch (MalformedURLException e) {
                throw new TagExecutionException(this.getTagInfo(), "Error parsing url into java.net.URL.", e);
            }
        }
        MarmaladeAttributes attributes = this.getAttributes();
        RecordingReader reader = null;
        try {
            try {
                String var;
                boolean shouldExec;
                reader = new RecordingReader(new BufferedReader(new InputStreamReader(resource.openStream())));
                DefaultParsingContext pContext = new DefaultParsingContext();
                pContext.setInput(reader);
                pContext.setInputLocation(resource.toExternalForm());
                pContext.setDefaultExpressionEvaluator(this.getExpressionEvaluator());
                if (this.strategies.isEmpty()) {
                    pContext.addTaglibDefinitionStrategies(MarmaladeTaglibResolver.DEFAULT_STRATEGY_CHAIN);
                } else {
                    pContext.addTaglibDefinitionStrategies(this.strategies);
                }
                ScriptParser parser = new ScriptParser();
                ScriptBuilder builder = parser.parse(pContext);
                MarmaladeScript script = builder.build();
                Boolean parseOnly = (Boolean)attributes.getValue(PARSE_ONLY_ATTRIBUTE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ImportTag.class$("java.lang.Boolean")) : class$java$lang$Boolean, context, (Object)Boolean.FALSE);
                boolean bl = parseOnly == null ? true : (shouldExec = parseOnly == false);
                if (shouldExec) {
                    script.execute(context);
                }
                if ((var = (String)attributes.getValue(VAR_ATTRIBUTE, class$java$lang$String == null ? (class$java$lang$String = ImportTag.class$("java.lang.String")) : class$java$lang$String, context)) != null && var.length() > 0) {
                    context.setVariable(var, script);
                }
            }
            catch (MarmaladeParsetimeException e) {
                throw new TagExecutionException(this.getTagInfo(), "Error parsing script from: " + resource.toExternalForm(), e);
            }
            catch (ModelBuilderException e) {
                throw new TagExecutionException(this.getTagInfo(), "Error parsing script from: " + resource.toExternalForm(), e);
            }
            catch (IOException e) {
                throw new TagExecutionException(this.getTagInfo(), "Error parsing script from: " + resource.toExternalForm(), e);
            }
            Object var14_18 = null;
            if (reader == null) return;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        reader.close();
        return;
    }

    protected void doReset() {
        this.strategies.clear();
    }

    public void addTaglibResolutionStrategy(TaglibResolutionStrategy strategy) {
        if (!this.strategies.contains(strategy)) {
            this.strategies.add(strategy);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

