/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.el.commonsEl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.commons.el.ExpressionEvaluatorImpl;
import org.codehaus.marmalade.el.AbstractExpressionEvaluator;
import org.codehaus.marmalade.el.ExpressionEvaluationException;
import org.codehaus.marmalade.util.Reflector;
import org.codehaus.marmalade.util.ReflectorException;

public class CommonsElExpressionEvaluator
extends AbstractExpressionEvaluator {
    public static final String BOOLEAN_PATTERN = "true|false";
    private static final String DIGIT_STRING_PATTERN = "[0-9]+";
    private static final String POSITIVE_NEGATIVE_PATTERN = "[-+]?";
    public static final String ROUND_NUMBER_PATTERN = "[-+]?[0-9]+";
    public static final String FRACTIONAL_NUMBER_PATTERN = "[-+]?[0-9]+.[0-9]+";
    private ExpressionEvaluatorImpl elImpl = new ExpressionEvaluatorImpl(true);
    private Reflector reflector = new Reflector();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;

    public Object doEval(String expression, Map context, Class expectedType) throws ExpressionEvaluationException {
        Class realExpectedType = expectedType;
        if (expectedType.equals(class$java$lang$Object == null ? (class$java$lang$Object = CommonsElExpressionEvaluator.class$("java.lang.Object")) : class$java$lang$Object)) {
            if (expression.matches(BOOLEAN_PATTERN)) {
                realExpectedType = class$java$lang$Boolean == null ? (class$java$lang$Boolean = CommonsElExpressionEvaluator.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            } else if (expression.matches(ROUND_NUMBER_PATTERN)) {
                realExpectedType = class$java$lang$Long == null ? (class$java$lang$Long = CommonsElExpressionEvaluator.class$("java.lang.Long")) : class$java$lang$Long;
            } else if (expression.matches(FRACTIONAL_NUMBER_PATTERN)) {
                realExpectedType = class$java$lang$Double == null ? (class$java$lang$Double = CommonsElExpressionEvaluator.class$("java.lang.Double")) : class$java$lang$Double;
            }
        }
        Object result = this.eval(expression, context, realExpectedType);
        return result;
    }

    public Object assign(Object targetObject, String propertyName, Object value) throws ExpressionEvaluationException {
        Object result = null;
        if (targetObject == null) {
            throw new ExpressionEvaluationException("Cannot set property on null target.");
        }
        if (propertyName == null || propertyName.length() < 1) {
            throw new ExpressionEvaluationException("Cannot set empty property.");
        }
        Object target = targetObject;
        String property = propertyName;
        int lastDot = property.lastIndexOf(46);
        if (lastDot > -1) {
            String expr = "${target." + property.substring(0, lastDot) + "}";
            TreeMap<String, Object> ctx = new TreeMap<String, Object>();
            ctx.put("target", target);
            target = this.eval(expr, ctx, class$java$lang$Object == null ? (class$java$lang$Object = CommonsElExpressionEvaluator.class$("java.lang.Object")) : class$java$lang$Object);
            property = property.substring(lastDot + 1);
        }
        result = this.set(target, property, value);
        return result;
    }

    private Object set(Object target, String property, Object value) throws ExpressionEvaluationException {
        Object result;
        block8: {
            result = null;
            try {
                Method method = this.findMethod(target, property, value);
                if (method != null) {
                    result = method.invoke(target, value);
                    break block8;
                }
                Field field = target.getClass().getField(property);
                int fieldModifiers = field.getModifiers();
                if (Modifier.isPublic(fieldModifiers) && !Modifier.isFinal(fieldModifiers) && field.getType().isAssignableFrom(value.getClass())) {
                    field.set(target, value);
                    result = value;
                    break block8;
                }
                throw new ExpressionEvaluationException("Cannot set property: '" + property + "' on target: " + target);
            }
            catch (IllegalArgumentException e) {
                throw new ExpressionEvaluationException("Error assigning value to property field.", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ExpressionEvaluationException("Error assigning value to property field.", (Throwable)e);
            }
            catch (SecurityException e) {
                throw new ExpressionEvaluationException("Error assigning value to property field.", (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                throw new ExpressionEvaluationException("Property not found: '" + property + "' on target: " + target, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ExpressionEvaluationException("Error assigning value via property method.", (Throwable)e);
            }
        }
        return result;
    }

    private Method findMethod(Object target, String property, Object value) {
        StringBuffer propNameBuffer = new StringBuffer(property.length() + 3);
        propNameBuffer.append("set").append(Character.toUpperCase(property.charAt(0))).append(property.substring(1));
        String methodName = propNameBuffer.toString();
        Class<?> targetClass = target.getClass();
        Method method = null;
        if (value != null) {
            Class[] paramClasses = new Class[]{value.getClass()};
            try {
                method = this.reflector.getMethod(targetClass, methodName, paramClasses);
                method = targetClass.getMethod(methodName, paramClasses);
            }
            catch (NoSuchMethodException e) {
            }
            catch (ReflectorException e) {}
        } else {
            try {
                method = this.reflector.getMethod(targetClass, methodName, new Class[0]);
            }
            catch (ReflectorException e) {
                // empty catch block
            }
        }
        return method;
    }

    private Object eval(String expression, Map context, Class expectedReturnType) throws ExpressionEvaluationException {
        try {
            Object result = this.elImpl.evaluate(expression, expectedReturnType, (VariableResolver)new ElVarResolver(context), (FunctionMapper)new ElFuncMapper());
            if (result != null && !expectedReturnType.isAssignableFrom(result.getClass())) {
                throw new ExpressionEvaluationException("Result of evaluation is not of type " + expectedReturnType.getName());
            }
            return result;
        }
        catch (ELException e) {
            throw new ExpressionEvaluationException(expression, (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ElFuncMapper
    implements FunctionMapper {
        ElFuncMapper() {
        }

        public Method resolveFunction(String arg0, String arg1) {
            return null;
        }
    }

    private static final class ElVarResolver
    implements VariableResolver {
        private Map context;

        ElVarResolver(Map context) {
            this.context = context;
        }

        public Object resolveVariable(String name) throws ELException {
            return this.context.get(name);
        }
    }
}

