/*
 * Decompiled with CFR 0.152.
 */
package me.dinowernli.grpc.prometheus;

import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.time.Clock;
import me.dinowernli.grpc.prometheus.Configuration;
import me.dinowernli.grpc.prometheus.GrpcMethod;
import me.dinowernli.grpc.prometheus.MonitoringServerCall;
import me.dinowernli.grpc.prometheus.MonitoringServerCallListener;
import me.dinowernli.grpc.prometheus.ServerMetrics;

public class MonitoringServerInterceptor
implements ServerInterceptor {
    private final Clock clock;
    private final Configuration configuration;
    private final ServerMetrics.Factory serverMetricsFactory;

    public static MonitoringServerInterceptor create(Configuration configuration) {
        return new MonitoringServerInterceptor(Clock.systemDefaultZone(), configuration, new ServerMetrics.Factory(configuration));
    }

    private MonitoringServerInterceptor(Clock clock, Configuration configuration, ServerMetrics.Factory factory) {
        this.clock = clock;
        this.configuration = configuration;
        this.serverMetricsFactory = factory;
    }

    public <R, S> ServerCall.Listener<R> interceptCall(ServerCall<R, S> serverCall, Metadata metadata, ServerCallHandler<R, S> serverCallHandler) {
        MethodDescriptor methodDescriptor = serverCall.getMethodDescriptor();
        ServerMetrics serverMetrics = this.serverMetricsFactory.createMetricsForMethod(methodDescriptor);
        GrpcMethod grpcMethod = GrpcMethod.of(methodDescriptor);
        MonitoringServerCall<R, S> monitoringServerCall = new MonitoringServerCall<R, S>(serverCall, this.clock, grpcMethod, serverMetrics, this.configuration);
        return new MonitoringServerCallListener(serverCallHandler.startCall(monitoringServerCall, metadata), serverMetrics, GrpcMethod.of(methodDescriptor));
    }
}

